/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.JsonParser;
import top.gregtao.concerto.enums.OrderType;
import top.gregtao.concerto.enums.Sources;
import top.gregtao.concerto.music.HttpFileMusic;
import top.gregtao.concerto.music.LocalFileMusic;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.FixedPlaylist;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.music.meta.music.list.PlaylistMetaData;
import top.gregtao.concerto.music.parser.BilibiliMusicJsonParser;
import top.gregtao.concerto.music.parser.KuGouMusicJsonParser;
import top.gregtao.concerto.music.parser.NeteaseCloudMusicJsonParser;
import top.gregtao.concerto.music.parser.PathFileMusicJsonParser;
import top.gregtao.concerto.music.parser.QQMusicJsonParser;
import top.gregtao.concerto.music.parser.SharedMusicJsonParser;
import top.gregtao.concerto.music.parser.meta.BasicMusicMetaJsonParser;
import top.gregtao.concerto.music.parser.meta.TimelessMusicMetaJsonParser;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.util.JsonUtil;

public class MusicJsonParsers {
    private static final HashMap<String, JsonParser<Music>> MUSIC_PARSERS = new HashMap();
    private static final HashMap<String, JsonParser<MusicMetaData>> META_PARSERS = new HashMap();
    public static final JsonParser<Music> LOCAL_FILE = MusicJsonParsers.registerMusicParser((JsonParser<? extends Music>)new PathFileMusicJsonParser<LocalFileMusic>(Sources.LOCAL_FILE.method_15434()){

        @Override
        public LocalFileMusic fromJson(JsonObject object) {
            return new LocalFileMusic(object.get("path").getAsString());
        }
    });
    public static final JsonParser<Music> HTTP_FILE = MusicJsonParsers.registerMusicParser((JsonParser<? extends Music>)new PathFileMusicJsonParser<HttpFileMusic>(Sources.INTERNET.method_15434()){

        @Override
        public HttpFileMusic fromJson(JsonObject object) {
            return new HttpFileMusic(object.get("path").getAsString());
        }
    });
    public static final JsonParser<Music> NETEASE_CLOUD = MusicJsonParsers.registerMusicParser(new NeteaseCloudMusicJsonParser());
    public static final JsonParser<Music> QQ_MUSIC = MusicJsonParsers.registerMusicParser(new QQMusicJsonParser());
    public static final JsonParser<Music> KUGOU_MUSIC = MusicJsonParsers.registerMusicParser(new KuGouMusicJsonParser());
    public static final JsonParser<Music> BILIBILI = MusicJsonParsers.registerMusicParser(new BilibiliMusicJsonParser());
    public static final JsonParser<Music> SHARED = MusicJsonParsers.registerMusicParser(new SharedMusicJsonParser());
    public static final JsonParser<MusicMetaData> TIMELESS_META = MusicJsonParsers.registerMetaParser(new TimelessMusicMetaJsonParser());
    public static final JsonParser<MusicMetaData> BASIC_META = MusicJsonParsers.registerMetaParser(new BasicMusicMetaJsonParser());

    public static void registerMusicParser(String name, JsonParser<Music> parser) {
        MUSIC_PARSERS.put(name, parser);
    }

    public static void registerMetaParser(String name, JsonParser<MusicMetaData> parser) {
        META_PARSERS.put(name, parser);
    }

    public static JsonParser<Music> registerMusicParser(JsonParser<? extends Music> parser) {
        JsonParser<Music> parser1 = parser;
        MusicJsonParsers.registerMusicParser(parser.name(), parser1);
        return parser1;
    }

    public static JsonParser<MusicMetaData> registerMetaParser(JsonParser<? extends MusicMetaData> parser) {
        JsonParser<MusicMetaData> parser1 = parser;
        MusicJsonParsers.registerMetaParser(parser.name(), parser1);
        return parser1;
    }

    public static Music from(String str) {
        return MusicJsonParsers.from(JsonUtil.from(str));
    }

    public static Music from(String str, boolean withMeta) {
        return MusicJsonParsers.from(JsonUtil.from(str), withMeta);
    }

    public static Music from(JsonObject jsonObject) {
        return MusicJsonParsers.from(jsonObject, true);
    }

    public static Music from(JsonObject jsonObject, boolean withMeta) {
        try {
            JsonParser<Music> parser = MUSIC_PARSERS.get(jsonObject.get("name").getAsString());
            Music music = parser.fromJson(jsonObject);
            if (withMeta) {
                JsonObject metaObject = jsonObject.getAsJsonObject("meta");
                music.setMusicMeta(META_PARSERS.get(metaObject.get("name").getAsString()).fromJson(metaObject));
            }
            return music;
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Error occurred when converting from JSON to music, {}: {}", (Object)e, (Object)jsonObject.toString());
            return null;
        }
    }

    public static JsonObject to(Music music) {
        return MusicJsonParsers.to(music, true);
    }

    public static JsonObject to(Music music, boolean withMeta) {
        try {
            JsonObject object = new JsonObject();
            JsonObject metaObject = new JsonObject();
            object.addProperty("name", music.getJsonParser().name());
            object = music.getJsonParser().toJson(object, music);
            if (withMeta) {
                MusicMetaData meta = music.getMeta();
                metaObject.addProperty("name", meta.getJsonParser().name());
                object.add("meta", (JsonElement)meta.getJsonParser().toJson(metaObject, meta));
            }
            return object;
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Error occurred when converting from music to JSON, {}: {}", (Object)e, (Object)music.getMeta());
            return null;
        }
    }

    public static Playlist fromPlaylist(String str) {
        return MusicJsonParsers.fromPlaylist(JsonUtil.from(str), false);
    }

    public static Playlist fromPlaylist(String str, boolean withMeta) {
        return MusicJsonParsers.fromPlaylist(JsonUtil.from(str), withMeta);
    }

    public static Playlist fromPlaylist(JsonObject object) {
        return MusicJsonParsers.fromPlaylist(object, false);
    }

    public static Playlist fromPlaylist(JsonObject object, boolean withMeta) {
        try {
            String title = object.get("title").getAsString();
            String author = object.get("author").getAsString();
            String createTime = object.get("createTime").getAsString();
            String description = object.get("description").getAsString();
            boolean isAlbum = object.get("isAlbum").getAsBoolean();
            ArrayList<Music> musicList = new ArrayList<Music>();
            for (JsonElement element : object.getAsJsonArray("list")) {
                Music music = MusicJsonParsers.from(element.getAsJsonObject(), withMeta);
                if (music == null) continue;
                musicList.add(music);
            }
            return new FixedPlaylist(musicList, new PlaylistMetaData(author, title, createTime, description), isAlbum);
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Error occurred when converting from JSON to playlist, {}: {}", (Object)e, (Object)object.toString());
            return null;
        }
    }

    public static JsonObject toPlaylist(Playlist playlist) {
        return MusicJsonParsers.toPlaylist(playlist, false);
    }

    public static JsonObject toPlaylist(Playlist playlist, boolean withMeta) {
        try {
            playlist.load();
            JsonObject object = new JsonObject();
            PlaylistMetaData meta = playlist.getMeta();
            object.addProperty("title", meta.title());
            object.addProperty("author", meta.author());
            object.addProperty("createTime", meta.createTime());
            object.addProperty("description", meta.description());
            object.addProperty("isAlbum", Boolean.valueOf(playlist.isAlbum()));
            JsonArray array = new JsonArray();
            for (Music music : playlist.getList()) {
                JsonObject musicObject = MusicJsonParsers.to(music, withMeta);
                if (musicObject == null) continue;
                array.add((JsonElement)musicObject);
            }
            object.add("list", (JsonElement)array);
            return object;
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Error occurred when converting from playlist to JSON, {}: {}", (Object)e, (Object)playlist.getMeta());
            return null;
        }
    }

    public static MusicPlayerHandler fromRaw(String json) {
        try {
            if (json.isEmpty()) {
                return new MusicPlayerHandler();
            }
            ArrayList<Music> list = new ArrayList<Music>();
            JsonObject object = JsonUtil.from(json);
            JsonArray array = object.get("data").getAsJsonArray();
            array.forEach(element -> {
                Music music = MusicJsonParsers.from(element.getAsJsonObject());
                if (music != null) {
                    list.add(music);
                }
            });
            return new MusicPlayerHandler(list, Math.min(JsonUtil.getIntOrElse(object, "cur", -1), array.size() - 1), OrderType.valueOf(JsonUtil.getStringOrElse(object, "ord", OrderType.NORMAL.toString())));
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Error parsing JSON from music.json: {}", (Object)e.toString());
            return new MusicPlayerHandler();
        }
    }

    public static String toRaw(MusicPlayerHandler status) {
        JsonArray array = new JsonArray();
        status.getMusicList().forEach(music -> {
            JsonObject object = MusicJsonParsers.to(music);
            if (object != null) {
                array.add((JsonElement)object);
            }
        });
        JsonObject object = new JsonObject();
        object.add("data", (JsonElement)array);
        object.addProperty("cur", (Number)status.getCurrentIndex());
        object.addProperty("ord", status.getOrderType().toString());
        return object.toString();
    }
}

