/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.http.kugou;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import top.gregtao.concerto.util.Pair;
import top.gregtao.concerto.util.TextUtil;

public class KuGouLyricsUtil {
    public static Pair<String, String> krcToLrc(String krc) {
        String[] lines = krc.split("\n|\r|\r\n");
        ArrayList<Pair<String, String>> pairList = new ArrayList<Pair<String, String>>();
        for (String line : lines) {
            String[] parts;
            if ((line = line.trim()).isEmpty() || (parts = line.split("]")).length < 1) continue;
            String string = parts[0].substring(1);
            if (parts.length > 1) {
                String lyricPart = parts[parts.length - 1].trim();
                if (lyricPart.isEmpty()) continue;
                pairList.add(Pair.of(string, lyricPart));
                continue;
            }
            pairList.add(Pair.of(string, ""));
        }
        List<Object> transLyricStr = new ArrayList();
        ArrayList<CallSite> mainLyric = new ArrayList<CallSite>();
        ArrayList<CallSite> transLyric = new ArrayList<CallSite>();
        int i = 0;
        for (Pair pair : pairList) {
            String first = (String)pair.getFirst();
            if (first.startsWith("language")) {
                String[] strings = first.split(":");
                if (strings.length != 2) continue;
                transLyricStr = KuGouLyricsUtil.getTransLyric(strings[1]);
                continue;
            }
            String second = (String)pair.getSecond();
            if (second != null && first.matches("\\d+,.+")) {
                String[] strings = first.split(",");
                String time = strings[0];
                String formattedTime = KuGouLyricsUtil.formatTime(Integer.parseInt(time));
                String lyric = second.replaceAll("<\\d+,[^>]+>", "");
                mainLyric.add((CallSite)((Object)(formattedTime + lyric)));
                if (transLyricStr.size() > i) {
                    transLyric.add((CallSite)((Object)(formattedTime + (String)transLyricStr.get(i))));
                }
                ++i;
                continue;
            }
            String string = "[" + first + second + "]";
            mainLyric.add((CallSite)((Object)string));
            transLyric.add((CallSite)((Object)string));
        }
        return Pair.of(String.join((CharSequence)"\n", mainLyric), String.join((CharSequence)"\n", transLyric));
    }

    public static List<String> getTransLyric(String language) {
        String json = TextUtil.fromBase64(language);
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        return Optional.ofNullable(jsonObject).map(obj -> obj.getAsJsonArray("content")).flatMap(arr -> arr.asList().stream().filter(el -> Optional.ofNullable(el.getAsJsonObject()).map(object -> object.get("type")).map(type -> type.getAsInt() == 1).orElse(false)).findFirst()).map(JsonElement::getAsJsonObject).map(lyric -> lyric.getAsJsonArray("lyricContent")).map(arr -> arr.asList().stream().map(JsonElement::getAsJsonArray).map(timeAndLyric -> timeAndLyric.isEmpty() ? "" : timeAndLyric.get(0).getAsString()).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public static String formatTime(int ms) {
        int minutes = ms / 60000;
        int seconds = ms % 60000 / 1000;
        int hundredths = ms % 1000 / 10;
        return String.format("[%02d:%02d.%02d]", minutes, seconds, hundredths);
    }
}

