/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music.list;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import top.gregtao.concerto.http.qq.QQMusicApiClient;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.music.meta.music.list.PlaylistMetaData;
import top.gregtao.concerto.util.Pair;

public class QQMusicPlaylist
extends Playlist {
    public final String id;
    public boolean simply = false;

    public QQMusicPlaylist(String id, boolean isAlbum) {
        super(isAlbum);
        this.id = id;
    }

    public QQMusicPlaylist(JsonObject object, boolean isAlbum, boolean simply) {
        super(isAlbum ? QQMusicApiClient.INSTANCE.parseAlbumJson(object, simply) : QQMusicApiClient.INSTANCE.parsePlaylistJson(object, simply), isAlbum);
        this.simply = simply;
        this.id = object.get(isAlbum ? "albumMID" : "dissid").getAsString();
    }

    @Override
    Pair<ArrayList<Music>, PlaylistMetaData> loadData() {
        try {
            return this.isAlbum ? QQMusicApiClient.INSTANCE.getAlbum(this.id) : QQMusicApiClient.INSTANCE.getPlaylist(this.id);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayList<Music> getList() {
        if (this.simply && this.isLoaded()) {
            this.list = this.loadData().getFirst();
        }
        return super.getList();
    }
}

