/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.network;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.command.ConcertoServerCommand;
import top.gregtao.concerto.config.PresetPlaylistsConfig;
import top.gregtao.concerto.config.ServerConfig;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.network.ConcertoPayload;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.network.room.MusicRoom;
import top.gregtao.concerto.network.room.ServerMusicAgent;
import top.gregtao.concerto.util.TextUtil;

public class ServerMusicNetworkHandler {
    public static Map<UUID, MusicDataPacket> WAIT_AUDITION = new HashMap<UUID, MusicDataPacket>();

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(ConcertoPayload.ID, ServerMusicNetworkHandler::generalReceiver);
    }

    public static void removeFirst() {
        Iterator<Map.Entry<UUID, MusicDataPacket>> iterator = WAIT_AUDITION.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Map.Entry<UUID, MusicDataPacket> entry = iterator.next();
        ServerMusicNetworkHandler.sendS2CAuditionSyncData(entry.getKey(), entry.getValue(), true);
        iterator.remove();
    }

    public static void generalReceiver(ConcertoPayload payload, ServerPlayNetworking.Context context) {
        switch (payload.channel) {
            case MUSIC_DATA: {
                ServerMusicNetworkHandler.musicDataReceiver(payload, context);
                break;
            }
            case MUSIC_ROOM: {
                MusicRoom.serverReceiver(payload, context);
                break;
            }
            case MUSIC_AGENT: {
                ServerMusicNetworkHandler.musicAgentReceiver(payload, context);
            }
        }
    }

    public static void passAudition(@Nullable class_1657 auditor, UUID uuid) {
        if (WAIT_AUDITION.containsKey(uuid)) {
            MusicDataPacket packet = WAIT_AUDITION.get(uuid);
            WAIT_AUDITION.remove(uuid);
            boolean success = ServerMusicNetworkHandler.sendS2CMusicData(packet, true);
            if (auditor != null) {
                if (success) {
                    auditor.method_7353((class_2561)class_2561.method_43469((String)"concerto.audit.pass", (Object[])new Object[]{packet.from, packet.music.getMeta().title()}), false);
                } else {
                    auditor.method_7353((class_2561)class_2561.method_43469((String)"concerto.share.s2c_failed", (Object[])new Object[]{uuid.toString()}), false);
                }
                ConcertoServer.LOGGER.info("Auditor {} passed request from {}: {} to {}", new Object[]{auditor.method_5477().getString(), packet.from, packet.music.getMeta().title(), packet.to});
            }
            ConcertoServer.LOGGER.info("Auditor ??? passed request from {}: {} to {}", new Object[]{packet.from, packet.music.getMeta().title(), packet.to});
            ServerMusicNetworkHandler.sendS2CAuditionSyncData(uuid, packet, true);
        } else if (auditor != null) {
            auditor.method_7353((class_2561)class_2561.method_43471((String)"concerto.audit.uuid_not_found"), false);
        }
    }

    public static void rejectAll(@Nullable class_1657 auditor) {
        WAIT_AUDITION.forEach((uuid, packet) -> {
            class_3222 player = packet.server.method_3760().method_14566(packet.from);
            String title = packet.music.getMeta().title();
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"concerto.share.rejected", (Object[])new Object[]{title}), false);
            }
        });
        WAIT_AUDITION.clear();
        if (auditor != null) {
            auditor.method_7353((class_2561)class_2561.method_43469((String)"concerto.audit.reject", (Object[])new Object[]{"ALL", "ALL"}), false);
        }
        ConcertoServer.LOGGER.info("Auditor {} rejected all request", (Object)(auditor == null ? "?" : auditor.method_5477().getString()));
    }

    public static void rejectAudition(@Nullable class_1657 auditor, UUID uuid) {
        if (WAIT_AUDITION.containsKey(uuid)) {
            MusicDataPacket packet = WAIT_AUDITION.get(uuid);
            WAIT_AUDITION.remove(uuid);
            class_3222 player = packet.server.method_3760().method_14566(packet.from);
            String title = packet.music.getMeta().title();
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"concerto.share.rejected", (Object[])new Object[]{title}), false);
            }
            if (auditor != null) {
                auditor.method_7353((class_2561)class_2561.method_43469((String)"concerto.audit.reject", (Object[])new Object[]{player == null ? "an unknown player" : player.method_5477().getString(), title}), false);
            }
            ConcertoServer.LOGGER.info("Auditor {} rejected request from {}: {} to {}", new Object[]{auditor == null ? "???" : auditor.method_5477().getString(), packet.from, title, packet.to});
            ServerMusicNetworkHandler.sendS2CAuditionSyncData(uuid, packet, true);
        } else if (auditor != null) {
            auditor.method_7353((class_2561)class_2561.method_43471((String)"concerto.audit.uuid_not_found"), false);
        }
    }

    public static void sendAuditionSyncPacket(UUID uuid, class_3222 player, MusicDataPacket packet, boolean isDelete) {
        ConcertoPayload payload = new ConcertoPayload(ConcertoPayload.Channel.AUDITION_SYNC, (isDelete ? "DEL;" : "ADD;") + String.valueOf(uuid) + ";" + (isDelete ? "QwQ" : Objects.requireNonNull(MusicJsonParsers.to(packet.music)).toString()));
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void sendS2CAuditionSyncData(UUID uuid, MusicDataPacket packet, boolean isDelete) {
        class_3324 playerManager = packet.server.method_3760();
        for (class_3222 player : playerManager.method_14571()) {
            if (!player.method_64475(packet.server.method_3798())) continue;
            ServerMusicNetworkHandler.sendAuditionSyncPacket(uuid, player, packet, isDelete);
        }
    }

    public static void sendS2CAllAuditionData(class_3222 player) {
        WAIT_AUDITION.forEach((uuid, packet) -> ServerMusicNetworkHandler.sendAuditionSyncPacket(uuid, player, packet, false));
    }

    public static void sendS2CPresetRadiosPacket(class_3222 player) {
        ConcertoPayload payload = new ConcertoPayload(ConcertoPayload.Channel.PRESET_RADIOS, PresetPlaylistsConfig.PRESET_RADIOS.toString());
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static boolean sendS2CMusicData(MusicDataPacket packet, boolean audit) {
        if (!packet.isS2C) {
            throw new RuntimeException("Not an S2C music data packet");
        }
        if (packet.server == null || !packet.server.method_3806()) {
            throw new RuntimeException("Server not found or not running");
        }
        ConcertoPayload payload = packet.toPacket();
        class_3324 playerManager = packet.server.method_3760();
        ConcertoServer.LOGGER.info("Trying to send music request to {}", (Object)packet.to);
        if (packet.to.equals("@a")) {
            playerManager.method_14571().forEach(serverPlayer -> ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)payload));
        } else {
            class_3222 target = playerManager.method_14566(packet.to);
            class_3222 from = playerManager.method_14566(packet.from);
            if (target == null) {
                if (from != null) {
                    from.method_64398((class_2561)class_2561.method_43469((String)"concerto.share.s2c_player_not_found", (Object[])new Object[]{packet.to}));
                }
                ConcertoServer.LOGGER.warn("Target not found, failed to send.");
                return false;
            }
            ServerPlayNetworking.send((class_3222)target, (class_8710)payload);
            if (audit && from != null) {
                from.method_64398((class_2561)class_2561.method_43469((String)"concerto.share.audition_passed", (Object[])new Object[]{packet.to, packet.music.getMeta().title()}));
            }
        }
        ConcertoServer.LOGGER.info("Successfully.");
        return true;
    }

    public static void musicDataReceiver(ConcertoPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = context.player().method_51469().method_8503();
        try {
            MusicDataPacket packet = MusicDataPacket.fromPacket(payload, false);
            if (packet != null && packet.music != null && server != null) {
                class_3324 playerManager = server.method_3760();
                if (!ServerMusicNetworkHandler.playerExist(playerManager, packet.to)) {
                    player.method_64398((class_2561)class_2561.method_43469((String)"concerto.share.c2s_player_not_found", (Object[])new Object[]{packet.to}));
                    ConcertoServer.LOGGER.info("Received a music request from {} to an unknown player", (Object)player.method_5477().getString());
                } else {
                    packet.from = player.method_5477().getString();
                    packet.isS2C = true;
                    packet.server = server;
                    boolean audit = ServerConfig.INSTANCE.options.auditionRequired && packet.to.equals("@a");
                    boolean success = true;
                    if (audit) {
                        UUID uuid = UUID.randomUUID();
                        for (class_3222 player1 : playerManager.method_14571()) {
                            if (!player1.method_64475(server.method_3798())) continue;
                            player1.method_64398(TextUtil.PAGE_SPLIT);
                            player1.method_64398(ConcertoServerCommand.chatMessageBuilder(uuid, packet.from, packet.music.getMeta().title()));
                            player1.method_64398(TextUtil.PAGE_SPLIT);
                            ServerMusicNetworkHandler.sendAuditionSyncPacket(uuid, player1, packet, false);
                        }
                        WAIT_AUDITION.put(uuid, packet);
                        if (WAIT_AUDITION.size() > 300) {
                            ServerMusicNetworkHandler.removeFirst();
                        }
                    } else {
                        success = ServerMusicNetworkHandler.sendS2CMusicData(packet, false);
                    }
                    player.method_64398((class_2561)class_2561.method_43469((String)("concerto.share." + (success ? "success" : "failed") + (audit ? "_audit" : "")), (Object[])new Object[]{packet.music.getMeta().title()}));
                    MusicMetaData meta = packet.music.getMeta();
                    ConcertoServer.LOGGER.info("Received a music request {} - {} from {} to {}", new Object[]{meta.getSource(), meta.title(), player.method_5477().getString(), packet.to});
                }
            } else {
                player.method_64398((class_2561)class_2561.method_43471((String)"concerto.share.error"));
                ConcertoServer.LOGGER.warn("Received an unknown music data packet from {}", (Object)player.method_5477().getString());
            }
        }
        catch (Exception e) {
            ConcertoServer.LOGGER.warn("Received an unsafe music data packet from {}", (Object)player.method_5477().getString());
        }
    }

    public static void playerJoinHandshake(class_3222 player) {
        ConcertoPayload payload = new ConcertoPayload(ConcertoPayload.Channel.HANDSHAKE, "CONCERTO:CallJoin:" + player.method_5477().getString() + (ServerConfig.INSTANCE.options.serverMusicAgent && ServerConfig.INSTANCE.options.agentInviteWhenJoin ? ":Invite" : ""));
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        ServerMusicNetworkHandler.sendS2CAllAuditionData(player);
        ServerMusicNetworkHandler.sendS2CPresetRadiosPacket(player);
    }

    public static boolean playerExist(class_3324 manager, String name) {
        return name.equals("@a") || manager.method_14566(name) != null;
    }

    public static void musicAgentSendMusic(class_3222 player, Music music) {
        JsonObject object = MusicJsonParsers.to(music, true);
        if (object == null) {
            return;
        }
        ServerMusicNetworkHandler.musicAgentSendMusic(player, object.toString());
    }

    public static void musicAgentSendMusic(class_3222 player, String music) {
        ConcertoPayload payload = new ConcertoPayload(ConcertoPayload.Channel.MUSIC_AGENT, TextUtil.toBase64(music));
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void musicAgentSendStop(class_3222 player) {
        ConcertoPayload payload = new ConcertoPayload(ConcertoPayload.Channel.MUSIC_AGENT, "Stop");
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void musicAgentSendMusic(List<class_3222> players, Music music) {
        JsonObject object = MusicJsonParsers.to(music, true);
        if (object == null) {
            return;
        }
        players.forEach(player -> ServerMusicNetworkHandler.musicAgentSendMusic(player, object.toString()));
    }

    public static void musicAgentReceiver(ConcertoPayload payload, ServerPlayNetworking.Context context) {
        if (!ServerConfig.INSTANCE.options.serverMusicAgent) {
            context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.not_available"));
            return;
        }
        String[] args = payload.string.split(":");
        if (args[0].equals("Join")) {
            ServerMusicAgent.INSTANCE.playerJoin(context.player());
            context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.join"));
        } else if (args[0].equals("Quit")) {
            ServerMusicAgent.INSTANCE.playerQuit(context.player());
            context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.quit"));
        } else if (args[0].equals("Query")) {
            List<Music> list = ServerMusicAgent.INSTANCE.getMusicQueue();
            context.player().method_64398(TextUtil.PAGE_SPLIT);
            list.forEach(music -> context.player().method_64398((class_2561)class_2561.method_43470((String)(music.getMeta().title() + " - " + music.getMeta().author()))));
            context.player().method_64398(TextUtil.PAGE_SPLIT);
        } else if (args.length < 2 || !ServerMusicAgent.INSTANCE.isMember(context.player())) {
            context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.error"));
        } else if (args[0].equals("Vote")) {
            if (args[1].equals("New")) {
                ServerMusicAgent.INSTANCE.receiveVoteRequest(context.player());
            } else if (args[1].length() == 1) {
                ServerMusicAgent.INSTANCE.receiveVote(context.player(), args[1].equals("1"));
            } else {
                context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.error"));
            }
        } else if (args[0].equals("Add")) {
            Music music2 = MusicJsonParsers.from(TextUtil.fromBase64(args[1]), false);
            if (music2 != null && MusicDataPacket.isMusicSafe(music2)) {
                ServerMusicAgent.INSTANCE.addMusic(context.player(), music2);
            } else {
                context.player().method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.error"));
            }
        }
    }

    public static void sendVote2Member(class_3222 player) {
        player.method_64398(TextUtil.PAGE_SPLIT);
        player.method_64398((class_2561)class_2561.method_43471((String)"concerto.agent.vote").method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.accept").method_10862(TextUtil.getRunCommandStyle("/musicroom agent vote true").method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"]")).method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.reject").method_10862(TextUtil.getRunCommandStyle("/musicroom agent vote false").method_10977(class_124.field_1061))).method_10852((class_2561)class_2561.method_43470((String)"]")));
        player.method_64398(TextUtil.PAGE_SPLIT);
    }
}

