/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.network.room.MusicRoom;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.player.streamplayer.enums.Status;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayer;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerEvent;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerException;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerListener;
import top.gregtao.concerto.util.ConcertoRunner;

public class MusicPlayer
extends StreamPlayer
implements StreamPlayerListener {
    public static MusicPlayer INSTANCE;
    public static final Logger PLAYER_LOGGER;
    public boolean forcePaused = false;
    public boolean started = false;
    public AtomicBoolean playNextLock = new AtomicBoolean(false);
    public boolean isPlayingTemp = false;

    public static void resetInstance() {
        try {
            if (MusicPlayerHandler.INSTANCE.currentSource != null) {
                MusicPlayerHandler.INSTANCE.currentSource.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        INSTANCE = new MusicPlayer(PLAYER_LOGGER);
    }

    public MusicPlayer() {
        this.addStreamPlayerListener(this);
    }

    public MusicPlayer(Logger logger) {
        super(logger);
        this.addStreamPlayerListener(this);
    }

    public void addMusic(Music music) {
        this.addMusic(music, () -> {});
    }

    public void addMusic(List<Music> musics) {
        this.addMusic(musics, () -> {});
    }

    public void addMusic(Music music, Runnable callback) {
        ConcertoRunner.run(() -> MusicPlayerHandler.INSTANCE.addMusic(music), callback);
    }

    public void addMusic(List<Music> musics, Runnable callback) {
        ConcertoRunner.run(() -> MusicPlayerHandler.INSTANCE.addMusic(musics), callback);
    }

    public void addMusic(Supplier<List<Music>> musicListAdder, Runnable callback) {
        ConcertoRunner.run(() -> MusicPlayerHandler.INSTANCE.addMusic((List)musicListAdder.get()), callback);
    }

    public void addMusicHere(Music music, boolean skip) {
        this.addMusicHere(music, skip, () -> {});
    }

    public void addMusicHere(Music music, boolean skip, Runnable callback) {
        ConcertoRunner.run(() -> {
            MusicPlayerHandler.INSTANCE.addMusicHere(music);
            if (skip) {
                this.skipTo(MusicPlayerHandler.INSTANCE.getCurrentIndex() + 1);
            }
        }, callback);
    }

    @Override
    public void play() throws StreamPlayerException {
        class_310 client = class_310.method_1551();
        client.method_1538().method_4859();
        super.play();
        this.syncVolume();
    }

    public void forcePause() {
        this.forcePaused = true;
        this.pause();
    }

    public void forceResume() {
        this.forcePaused = false;
        MusicRoom.clientPause(false);
        super.resume();
    }

    @Override
    public boolean pause() {
        if (!super.isPaused()) {
            MusicPlayerHandler.INSTANCE.writeConfig();
            MusicRoom.clientPause(true);
            return super.pause();
        }
        return false;
    }

    @Override
    public boolean resume() {
        if (this.forcePaused) {
            return false;
        }
        if (super.isPaused()) {
            MusicRoom.clientPause(false);
            return super.resume();
        }
        return false;
    }

    public boolean musicRoomPause() {
        this.forcePaused = true;
        return super.pause();
    }

    public boolean musicRoomResume() {
        this.forcePaused = false;
        return super.resume();
    }

    public void syncVolume() {
        try {
            this.setGain(MusicPlayer.getProperVolume());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static double getProperVolume() {
        class_310 client = class_310.method_1551();
        class_315 options = client.field_1690;
        return (double)(options.method_71978(class_3419.field_15250) * options.method_71978(class_3419.field_15253)) * 0.5;
    }

    @Override
    public void opened(Object dataSource, Map<String, Object> properties) {
    }

    @Override
    public void progress(int nEncodedBytes, long microsecondPosition, byte[] pcmData, Map<String, Object> properties) {
        MusicPlayerHandler.INSTANCE.updateDisplayTexts(microsecondPosition / 1000L);
    }

    @Override
    public void statusUpdated(StreamPlayerEvent event) {
        Status status = event.getPlayerStatus();
        if (status == Status.EOM) {
            if (!this.playNextLock.get()) {
                MusicPlayerHandler.INSTANCE.resetInfo();
            }
            if (MusicPlayerHandler.INSTANCE.isEmpty()) {
                this.started = false;
            } else if (!this.playNextLock.get() && !this.isPlayingTemp) {
                this.playNext(1);
            }
            this.isPlayingTemp = false;
            this.forcePaused = false;
        }
    }

    public void playTempMusic(Music music, Runnable callback) {
        ConcertoRunner.run(() -> {
            block3: {
                class_746 player = class_310.method_1551().field_1724;
                InputStream source = music.getMusicSourceOrNull();
                if (source == null) {
                    return;
                }
                this.forcePaused = false;
                this.playNextLock.set(true);
                this.started = true;
                this.stop();
                MusicPlayerHandler status = MusicPlayerHandler.INSTANCE;
                status.resetInfo();
                status.currentMusic = music;
                status.currentSource = source;
                status.initMusicStatus();
                status.updateDisplayTexts();
                try {
                    this.open(source);
                    this.play();
                    ConcertoClient.LOGGER.info("Start playing temporary music {} - {} from {}", new Object[]{music.getMeta().title(), music.getMeta().author(), music.getMeta().getSource()});
                }
                catch (StreamPlayerException e) {
                    this.forcePaused = false;
                    this.isPlayingTemp = false;
                    this.started = false;
                    ConcertoClient.LOGGER.error(e.toString());
                    if (player == null) break block3;
                    player.method_7353((class_2561)class_2561.method_43469((String)"concerto.player.error", (Object[])new Object[]{e.toString()}), false);
                }
            }
            this.isPlayingTemp = true;
            this.playNextLock.set(false);
        }, callback);
    }

    public void playTempMusic(Music music) {
        this.playTempMusic(music, () -> {});
    }

    public void playNext(int forward) {
        this.playNext(forward, () -> {});
    }

    public void playNext(int forward, Runnable callback) {
        this.playNext(forward, (Integer index) -> callback.run());
    }

    public void playNext(int forward, Consumer<Integer> callback) {
        ConcertoRunner.run(() -> {
            class_746 player = class_310.method_1551().field_1724;
            try {
                if (!this.started || MusicPlayerHandler.INSTANCE.isEmpty()) {
                    this.started = false;
                    return;
                }
                this.playNextLock.set(true);
                this.stop();
                Music music = MusicPlayerHandler.INSTANCE.playNext(forward);
                if (music != null) {
                    InputStream source;
                    while ((source = music.getMusicSourceOrNull()) == null) {
                        ConcertoClient.LOGGER.error("Unable to play music: {} - {} from {}", new Object[]{music.getMeta().title(), music.getMeta().author(), music.getMeta().getSource()});
                        if (player != null) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"concerto.player.unable", (Object[])new Object[]{music.getMeta().title(), music.getMeta().author(), music.getMeta().getSource()}), false);
                        }
                        MusicPlayerHandler.INSTANCE.setCurrentIndex((MusicPlayerHandler.INSTANCE.getCurrentIndex() + 1) % MusicPlayerHandler.INSTANCE.getMusicList().size());
                        MusicPlayerHandler.INSTANCE.resetInfo();
                        music = MusicPlayerHandler.INSTANCE.playNext(0);
                        if (music != null) continue;
                        return;
                    }
                    MusicPlayerHandler.INSTANCE.currentSource = source;
                    this.open(source);
                    this.play();
                    ConcertoClient.LOGGER.info("Start playing music {} - {}", (Object)music.getMeta().title(), (Object)music.getMeta().author());
                    MusicRoom.clientUpdate(music);
                    callback.accept(MusicPlayerHandler.INSTANCE.getCurrentIndex());
                }
                this.playNextLock.set(false);
                this.forcePaused = false;
                this.isPlayingTemp = false;
            }
            catch (Exception e) {
                ConcertoClient.LOGGER.error(e.toString());
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"concerto.player.error", (Object[])new Object[]{e.toString()}), false);
                }
                this.playNextLock.set(false);
                this.forcePaused = false;
                this.isPlayingTemp = false;
                this.playNext(1);
            }
        });
    }

    public void skipTo(int index) {
        MusicPlayerHandler.INSTANCE.setCurrentIndex(Math.min(MusicPlayerHandler.INSTANCE.getMusicList().size(), index));
        MusicPlayerHandler.INSTANCE.resetInfo();
        this.start();
    }

    public void start() {
        this.started = true;
        this.forcePaused = false;
        this.playNextLock.set(false);
        this.playNext(0);
    }

    public void clear() {
        ConcertoRunner.run(() -> {
            this.started = false;
            this.stop();
            MusicPlayerHandler.INSTANCE.clear();
        });
    }

    public void reloadConfig(Runnable callback) {
        ConcertoRunner.run(() -> {
            this.started = false;
            this.stop();
            MusicPlayerHandler.INSTANCE = MusicJsonParsers.fromRaw(ConcertoClient.MUSIC_CONFIG.read());
        }, callback);
    }

    public void cut(Runnable callback) {
        ConcertoRunner.run(() -> {
            if (!this.isPlayingTemp) {
                MusicPlayerHandler.INSTANCE.removeCurrent();
            }
            this.playNext(0);
        }, callback);
    }

    public void remove(int index, Runnable callback) {
        if (index == MusicPlayerHandler.INSTANCE.getCurrentIndex()) {
            this.cut(callback);
        } else {
            ConcertoRunner.run(() -> {
                MusicPlayerHandler.INSTANCE.remove(index);
                if (MusicPlayerHandler.INSTANCE.isEmpty()) {
                    this.cut(() -> {});
                }
            }, callback);
        }
    }

    static {
        FileHandler fileHandler;
        PLAYER_LOGGER = Logger.getLogger(MusicPlayer.class.getName());
        File file = new File("Concerto");
        if (!(file.exists() || file.isDirectory() || file.mkdir())) {
            throw new RuntimeException("Cannot mkdir!");
        }
        try {
            fileHandler = new FileHandler("Concerto/player.log", false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        fileHandler.setFormatter(new SimpleFormatter());
        PLAYER_LOGGER.addHandler(fileHandler);
        PLAYER_LOGGER.setLevel(Level.ALL);
        MusicPlayer.resetInstance();
    }
}

