/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import top.gregtao.concerto.api.CacheableMusic;
import top.gregtao.concerto.api.Likeable;
import top.gregtao.concerto.command.argument.OrderTypeArgumentType;
import top.gregtao.concerto.command.builder.MusicAdderBuilder;
import top.gregtao.concerto.config.CacheManager;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.config.MusicCacheManager;
import top.gregtao.concerto.config.PresetPlaylistsConfig;
import top.gregtao.concerto.enums.OrderType;
import top.gregtao.concerto.enums.Sources;
import top.gregtao.concerto.music.HttpFileMusic;
import top.gregtao.concerto.music.LocalFileMusic;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.FixedPlaylist;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.music.meta.music.list.PlaylistMetaData;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.Pair;
import top.gregtao.concerto.util.TextUtil;

public class MusicCommand {
    private static final List<MusicAdderBuilder.MusicGetter<Music>> GETTERS = List.of(context -> {
        LocalFileMusic music = new LocalFileMusic(StringArgumentType.getString((CommandContext)context, (String)"path"));
        return Pair.of(music, class_2561.method_43469((String)Sources.LOCAL_FILE.getKey("add"), (Object[])new Object[]{music.getRawPath()}));
    }, context -> {
        HttpFileMusic music = new HttpFileMusic(StringArgumentType.getString((CommandContext)context, (String)"path"));
        return Pair.of(music, class_2561.method_43469((String)Sources.INTERNET.getKey("add"), (Object[])new Object[]{music.getRawPath()}));
    });

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        LiteralCommandNode node = dispatcher.register(MusicCommand.registerPlayerControllers((LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"concerto").then(MusicCommand.addMusicCommand())).then(MusicCommand.insertMusicCommand()))));
        if (ClientConfig.INSTANCE.options.registerMusicCommand) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"music").redirect((CommandNode)node));
        }
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerPlayerControllers(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        MusicPlayer player = MusicPlayer.INSTANCE;
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"pause").executes(context -> {
            if (player.forcePaused) {
                player.forceResume();
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.resume"));
            } else {
                player.forcePause();
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.pause"));
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"start").executes(context -> {
            if (!player.started) {
                player.start();
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.start"));
            } else {
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.already_started"));
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"stop").executes(context -> {
            player.started = false;
            player.playNextLock.set(true);
            player.stop();
            MusicPlayerHandler.INSTANCE.resetInfo();
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.stop"));
            return 0;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skip").executes(context -> {
            MusicPlayer.INSTANCE.stop();
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.skip"));
            return 0;
        })).then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            MusicPlayer.INSTANCE.skipTo(index - 1);
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43469((String)"concerto.player.skip_to", (Object[])new Object[]{index}));
            return 0;
        })))).then(ClientCommandManager.literal((String)"cut").executes(context -> {
            MusicPlayer.INSTANCE.cut(() -> {});
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.cut"));
            return 0;
        }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
            MusicPlayer.INSTANCE.clear();
            MusicPlayer.resetInstance();
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.clear"));
            return 0;
        }))).then(ClientCommandManager.literal((String)"restart").executes(context -> {
            MusicPlayer.resetInstance();
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.success"));
            return 0;
        }))).then(ClientCommandManager.literal((String)"mode").then(ClientCommandManager.argument((String)"mode", (ArgumentType)OrderTypeArgumentType.orderType()).executes(context -> {
            OrderType type = OrderTypeArgumentType.getOrderType((CommandContext<FabricClientCommandSource>)context, "mode");
            MusicPlayerHandler.INSTANCE.setOrderType(type);
            TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43469((String)"concerto.player.mode", (Object[])new Object[]{type.getName().getString()}));
            return 0;
        })))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            MusicPlayer.INSTANCE.reloadConfig(() -> TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.player.reload")));
            ClientConfig.INSTANCE.readOptions();
            PresetPlaylistsConfig.LOCAL_PLAYLISTS.read();
            MusicPlayer.resetInstance();
            return 0;
        }))).then(ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_746 clientPlayer = ((FabricClientCommandSource)context.getSource()).getPlayer();
            ConcertoRunner.run(() -> {
                int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
                ArrayList<Music> list = MusicPlayerHandler.INSTANCE.getMusicList();
                page = Math.min(page, (int)Math.ceil((float)list.size() / 10.0f));
                clientPlayer.method_7353(TextUtil.PAGE_SPLIT, false);
                for (int i = 10 * (page - 1); i < Math.min(10 * page, list.size()); ++i) {
                    MusicMetaData meta = ((Music)list.get(i)).getMeta();
                    clientPlayer.method_7353((class_2561)class_2561.method_43470((String)(i + 1 + ". " + meta.title() + " | " + meta.author() + " | " + meta.getSource() + " | " + meta.getDuration().toShortString())).method_10862(TextUtil.getRunCommandStyle("/concerto skip " + (i + 1))), false);
                }
                clientPlayer.method_7353(TextUtil.PAGE_SPLIT, false);
            });
            return 0;
        })))).then(ClientCommandManager.literal((String)"save").executes(context -> {
            class_746 clientPlayer = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicPlayerHandler.INSTANCE.currentMusic == null) {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.unknown"), false);
            } else {
                Music patt0$temp = MusicPlayerHandler.INSTANCE.currentMusic;
                if (patt0$temp instanceof CacheableMusic) {
                    CacheableMusic music = (CacheableMusic)((Object)patt0$temp);
                    ConcertoRunner.run(() -> {
                        try {
                            MusicCacheManager.INSTANCE.addMusic(music);
                            clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.success"), false);
                        }
                        catch (IOException | UnsupportedAudioFileException e) {
                            throw new RuntimeException(e);
                        }
                    });
                } else {
                    clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.not_cacheable"), false);
                }
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"like").executes(context -> {
            class_746 clientPlayer = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Music music = MusicPlayerHandler.INSTANCE.getCurrentMusic();
            if (music instanceof Likeable) {
                Likeable likeable = (Likeable)((Object)music);
                CompletableFuture.supplyAsync(likeable::likeIt, ConcertoRunner.RUNNERS_POOL).thenAcceptAsync(success -> clientPlayer.method_7353((class_2561)(success != false ? class_2561.method_43469((String)"concerto.like", (Object[])new Object[]{music.getMeta().title(), music.getMeta().getSource()}) : class_2561.method_43471((String)"concerto.fail")), false), ConcertoRunner.RUNNERS_POOL);
            } else {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.error.unsupported_operation"), false);
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"dislike").executes(context -> {
            class_746 clientPlayer = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Music music = MusicPlayerHandler.INSTANCE.getCurrentMusic();
            if (music instanceof Likeable) {
                Likeable likeable = (Likeable)((Object)music);
                CompletableFuture.supplyAsync(likeable::dislikeIt, ConcertoRunner.RUNNERS_POOL).thenAcceptAsync(success -> clientPlayer.method_7353((class_2561)(success != false ? class_2561.method_43469((String)"concerto.dislike", (Object[])new Object[]{music.getMeta().title(), music.getMeta().getSource()}) : class_2561.method_43471((String)"concerto.fail")), false), ConcertoRunner.RUNNERS_POOL);
            } else {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.error.unsupported_operation"), false);
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"download-current").executes(context -> {
            MusicPlayerHandler.downloadMusics(List.of(MusicPlayerHandler.INSTANCE.getCurrentMusic()));
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43471((String)"concerto.success"), false);
            return 0;
        }))).then(ClientCommandManager.literal((String)"download-all").executes(context -> {
            MusicPlayerHandler.downloadMusics(MusicPlayerHandler.INSTANCE.getMusicList());
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43471((String)"concerto.success"), false);
            return 0;
        }))).then(ClientCommandManager.literal((String)"export-as-playlist").executes(context -> {
            class_746 clientPlayer = ((FabricClientCommandSource)context.getSource()).getPlayer();
            class_2561 playerName = clientPlayer.method_5476();
            if (PresetPlaylistsConfig.saveToLocalPlaylists(new FixedPlaylist(MusicPlayerHandler.INSTANCE.getMusicList(), new PlaylistMetaData(playerName == null ? "Unknown" : playerName.getString(), "Default Playlist", LocalDateTime.now().toString(), "Default Playlist"), false))) {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.playlist.export.success"), false);
            } else {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)"concerto.playlist.export.fail"), false);
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"clean-cache").executes(context -> {
            CacheManager.cleanAllCache();
            return 0;
        }));
    }

    public static ArgumentBuilder<FabricClientCommandSource, ?> addMusicCommand() {
        return ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"local").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> MusicAdderBuilder.execute((CommandContext<FabricClientCommandSource>)context, GETTERS.get(0).get((CommandContext<FabricClientCommandSource>)context), false)))).then(ClientCommandManager.literal((String)"folder").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String path = StringArgumentType.getString((CommandContext)context, (String)"path");
            MusicPlayer.INSTANCE.addMusic(() -> LocalFileMusic.getMusicsInFolder(new File(path)), () -> ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43469((String)Sources.LOCAL_FILE.getKey("add"), (Object[])new Object[]{path}), false));
            return 0;
        }))))).then(ClientCommandManager.literal((String)"http").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> MusicAdderBuilder.execute((CommandContext<FabricClientCommandSource>)context, GETTERS.get(1).get((CommandContext<FabricClientCommandSource>)context), false))));
    }

    public static ArgumentBuilder<FabricClientCommandSource, ?> insertMusicCommand() {
        return ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"insert").then(ClientCommandManager.literal((String)"local").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> MusicAdderBuilder.execute((CommandContext<FabricClientCommandSource>)context, GETTERS.get(0).get((CommandContext<FabricClientCommandSource>)context), true))))).then(ClientCommandManager.literal((String)"http").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> MusicAdderBuilder.execute((CommandContext<FabricClientCommandSource>)context, GETTERS.get(1).get((CommandContext<FabricClientCommandSource>)context), true))));
    }
}

