/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5242;
import net.minecraft.class_7157;
import top.gregtao.concerto.api.UnsafeMusicException;
import top.gregtao.concerto.command.argument.ShareMusicTargetArgumentType;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.network.ClientMusicNetworkHandler;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.TextUtil;

public class ShareMusicCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sharemusic").then(ClientCommandManager.literal((String)"to").then(ClientCommandManager.argument((String)"target", (ArgumentType)ShareMusicTargetArgumentType.create()).executes(context -> {
            String target = ShareMusicTargetArgumentType.get((CommandContext<FabricClientCommandSource>)context, "target");
            ConcertoRunner.run(() -> {
                Music current = MusicPlayerHandler.INSTANCE.getCurrentMusic();
                if (current != null) {
                    TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.share.sent"));
                    try {
                        ClientMusicNetworkHandler.sendC2SMusicData(new MusicDataPacket(current, target, false));
                    }
                    catch (UnsafeMusicException e) {
                        TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.share.unsafe"));
                    }
                } else {
                    TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43471((String)"concerto.share.no_music"));
                }
            });
            return 0;
        })))).then(ClientCommandManager.literal((String)"accept").then(ClientCommandManager.argument((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = (UUID)context.getArgument("uuid", UUID.class);
            ClientMusicNetworkHandler.accept((class_1657)((FabricClientCommandSource)context.getSource()).getPlayer(), uuid, class_310.method_1551());
            return 0;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reject").then(ClientCommandManager.argument((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = (UUID)context.getArgument("uuid", UUID.class);
            ClientMusicNetworkHandler.reject((class_1657)((FabricClientCommandSource)context.getSource()).getPlayer(), uuid, class_310.method_1551());
            return 0;
        }))).then(ClientCommandManager.literal((String)"all").executes(context -> {
            ClientMusicNetworkHandler.rejectAll((class_1657)((FabricClientCommandSource)context.getSource()).getPlayer(), class_310.method_1551());
            return 0;
        })))).then(ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ConcertoRunner.run(() -> {
                int i;
                int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
                Map<UUID, MusicDataPacket> map = ClientMusicNetworkHandler.WAIT_CONFIRMATION;
                Iterator<Map.Entry<UUID, MusicDataPacket>> iterator = map.entrySet().iterator();
                page = Math.min(page, (int)Math.ceil((float)map.size() / 10.0f));
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, TextUtil.PAGE_SPLIT);
                for (i = 1; i < 10 * (page - 1); ++i) {
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                }
                for (i = 10 * (page - 1); i < Math.min(10 * page, map.size()) && iterator.hasNext(); ++i) {
                    Map.Entry<UUID, MusicDataPacket> entry = iterator.next();
                    MusicDataPacket packet = entry.getValue();
                    TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, (class_2561)class_2561.method_43470((String)(i + 1 + ". ")).method_10852(ShareMusicCommand.chatMessageBuilder(entry.getKey(), packet.from, packet.music.getMeta().title())));
                }
                TextUtil.commandMessageClient((CommandContext<FabricClientCommandSource>)context, TextUtil.PAGE_SPLIT);
            });
            return 0;
        }))));
    }

    public static class_2561 chatMessageBuilder(UUID uuid, String name, String title) {
        return class_2561.method_43469((String)"concerto.share.wait_confirmation", (Object[])new Object[]{name, title}).method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.accept").method_10862(TextUtil.getRunCommandStyle("/sharemusic accept " + String.valueOf(uuid)).method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"]")).method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.reject").method_10862(TextUtil.getRunCommandStyle("/sharemusic reject " + String.valueOf(uuid)).method_10977(class_124.field_1061))).method_10852((class_2561)class_2561.method_43470((String)"]"));
    }
}

