/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music.list;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.music.meta.music.list.PlaylistMetaData;
import top.gregtao.concerto.util.MathUtil;
import top.gregtao.concerto.util.Optionals;
import top.gregtao.concerto.util.Pair;

public class KuGouMusicPlaylist
extends Playlist {
    private final String id;

    public KuGouMusicPlaylist(String id, boolean isAlbum) {
        super(isAlbum);
        this.id = id;
    }

    public KuGouMusicPlaylist(JsonObject object, boolean isAlbum, boolean isFromDetail) {
        super(isAlbum);
        if (!isAlbum) {
            this.id = Optional.ofNullable(object).map(json -> json.get(isFromDetail ? "global_collection_id" : "gid")).map(JsonElement::getAsString).orElseThrow();
            this.meta = KuGouMusicPlaylist.parsePlaylistInfo(object, isFromDetail);
        } else {
            this.id = Optional.ofNullable(object).map(json -> json.get("albumid")).map(JsonElement::getAsString).orElseThrow();
            this.meta = KuGouMusicPlaylist.parseAlbumInfo(object);
        }
        this.loaded = true;
    }

    public String getId() {
        return this.id;
    }

    public static PlaylistMetaData parsePlaylistInfo(JsonObject jsonObject, boolean isDetail) {
        String authorKey = isDetail ? "list_create_username" : "nickname";
        String titleKey = isDetail ? "name" : "specialname";
        Optional<JsonObject> optional = Optional.ofNullable(jsonObject);
        String author = optional.map(json -> json.get(authorKey)).map(JsonElement::getAsString).orElse("");
        String title = optional.map(json -> json.get(titleKey)).map(JsonElement::getAsString).orElse("");
        String desc = optional.map(json -> json.get("intro")).map(JsonElement::getAsString).orElse("");
        String createTime = optional.map(json -> json.get("create_time")).map(JsonElement::getAsString).map(Integer::parseInt).map(i -> (long)i.intValue() * 1000L).map(MathUtil::formattedTime).orElse("");
        return new PlaylistMetaData(author, title, createTime, desc);
    }

    public static PlaylistMetaData parseAlbumInfo(JsonObject jsonObject) {
        Optional<JsonObject> optional = Optional.ofNullable(jsonObject);
        String title = Optionals.firstOf(optional, json -> json.get("albumname"), json -> json.get("album_name")).map(JsonElement::getAsString).orElse("");
        List authorsList = Optionals.firstOf(optional, json -> json.getAsJsonArray("singers"), json -> json.getAsJsonArray("authors")).map(arr -> arr.asList().stream()).map(stream -> stream.map(JsonElement::getAsJsonObject).map(object -> Optionals.firstOf(Optional.of(object), json -> json.get("name"), json -> json.get("author_name")).map(JsonElement::getAsString).orElse("")).collect(Collectors.toList())).orElse(new ArrayList());
        String desc = optional.map(json -> json.get("intro")).map(JsonElement::getAsString).orElse("");
        String createTime = Optionals.firstOf(optional, json -> json.get("publish_time"), json -> json.get("publish_date")).map(JsonElement::getAsString).orElse("");
        return new PlaylistMetaData(String.join((CharSequence)", ", authorsList), title, createTime, desc);
    }

    @Override
    Pair<ArrayList<Music>, PlaylistMetaData> loadData() {
        return this.isAlbum ? KuGouMusicApiClient.INSTANCE.getAlbum(this.id) : KuGouMusicApiClient.INSTANCE.getPlaylist(this.id);
    }

    @Override
    public ArrayList<Music> getList() {
        Pair<ArrayList<Music>, PlaylistMetaData> pair = this.loadData();
        this.list = pair.getFirst();
        this.meta = pair.getSecond();
        this.loaded = true;
        return this.list;
    }
}

