/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.images.ArtworkFactory;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.CacheableMusic;
import top.gregtao.concerto.api.LazyLoadable;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.enums.OrderType;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.MusicTimestamp;
import top.gregtao.concerto.music.lyrics.Lyrics;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.screen.widget.URLImageWidget;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.Pair;

public class MusicPlayerHandler {
    public static MusicPlayerHandler INSTANCE = new MusicPlayerHandler();
    public static int MAX_SIZE = 10000;
    private ArrayList<Music> musicList = new ArrayList();
    private int currentIndex = -1;
    public Music currentMusic = null;
    public InputStream currentSource = null;
    public Lyrics currentLyrics = null;
    public Lyrics currentSubLyrics = null;
    public MusicMetaData currentMeta = null;
    private MusicTimestamp currentTime = null;
    private String[] displayTexts = new String[]{"", "", "", ""};
    public URLImageWidget headPicture = new URLImageWidget(20, 20, 0, 0, null, false);
    private String timeFormat = "%s" + " ".repeat(30) + "%s";
    private OrderType orderType = OrderType.NORMAL;
    public float progressPercentage = 0.0f;
    private long startTime = 0L;
    private final Random random = new Random();
    private static final Pattern ILLEGAL_CHARS = Pattern.compile("[\\\\/:*?\"<>|]");

    public MusicPlayerHandler() {
    }

    public MusicPlayerHandler(ArrayList<Music> musics, int currentIndex, OrderType orderType) {
        this.currentIndex = currentIndex;
        this.orderType = orderType;
        this.musicList = musics.size() > MAX_SIZE ? (ArrayList<Object>)musics.subList(0, MAX_SIZE - 1) : musics;
        MusicPlayerHandler.loadInThreadPool(this.musicList);
    }

    public static <T extends LazyLoadable> void loadInThreadPool(List<T> objects, boolean force) {
        try (ExecutorService service = Executors.newFixedThreadPool(32);){
            objects.forEach(object -> {
                if (force || !object.isLoaded()) {
                    service.submit(() -> object.load());
                }
            });
            service.shutdown();
            try {
                if (!service.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS)) {
                    throw new TimeoutException();
                }
            }
            catch (InterruptedException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T extends LazyLoadable> void loadInThreadPool(List<T> objects) {
        MusicPlayerHandler.loadInThreadPool(objects, false);
    }

    public void resetInfo() {
        this.currentSubLyrics = null;
        this.currentLyrics = null;
        this.currentMeta = null;
        this.currentTime = MusicTimestamp.of(0);
        this.displayTexts = new String[]{"", "", "", ""};
        this.timeFormat = "%s" + " ".repeat(30) + "%s";
        this.progressPercentage = 0.0f;
        this.startTime = 0L;
        this.headPicture.setUrl(null);
    }

    public void clear() {
        try {
            if (this.currentSource != null) {
                this.currentSource.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.resetInfo();
        this.musicList.clear();
        this.orderType = OrderType.NORMAL;
        this.currentIndex = -1;
        this.writeConfig();
    }

    public boolean addMusic(Music music) {
        if (this.musicList.size() - this.maxRemovable() >= MAX_SIZE) {
            return false;
        }
        this.removeMusic(this.musicList.size() + 1 - MAX_SIZE);
        if (!music.isLoaded()) {
            music.load();
        }
        this.musicList.add(music);
        this.writeConfig();
        return true;
    }

    public boolean addMusic(List<Music> musics) {
        if (musics.size() + this.musicList.size() - this.maxRemovable() > MAX_SIZE) {
            return false;
        }
        this.removeMusic(this.musicList.size() + musics.size() - MAX_SIZE);
        MusicPlayerHandler.loadInThreadPool(musics);
        this.musicList.addAll(musics);
        this.writeConfig();
        return true;
    }

    public void addMusicHere(Music music) {
        if (!music.isLoaded()) {
            music.load();
        }
        this.musicList.add(this.getCurrentIndex() + 1, music);
        this.writeConfig();
    }

    private int maxRemovable() {
        return this.orderType == OrderType.REVERSED ? this.musicList.size() - this.currentIndex - 1 : this.currentIndex;
    }

    private void removeMusic(int size) {
        if (this.orderType == OrderType.REVERSED) {
            while (size-- > 0) {
                this.musicList.remove(this.musicList.size() - 1);
            }
        } else {
            while (size-- > 0) {
                this.musicList.remove(0);
            }
        }
    }

    public void updateDisplayTexts() {
        if (this.currentMeta != null) {
            this.displayTexts[2] = this.currentMeta.title() + " | " + this.currentMeta.author() + " | " + this.currentMeta.getSource();
            MusicTimestamp timestamp = this.currentMeta.getDuration();
            this.timeFormat = "%s" + (String)(timestamp == null ? "" : " ".repeat(30) + this.currentMeta.getDuration().toShortString());
            if (!this.currentMeta.headPictureUrl().isEmpty()) {
                this.headPicture.setUrl(this.currentMeta.headPictureUrl());
                this.headPicture.loadImage(true, ClientConfig.INSTANCE.options.coverImgInCircle);
            }
        } else {
            this.displayTexts[2] = "";
        }
    }

    public void updateDisplayTexts(long millisecond) {
        MusicTimestamp duration = this.currentMeta.getDuration();
        this.progressPercentage = duration == null ? 0.0f : (float)(millisecond += this.startTime) / (float)duration.asMilliseconds();
        this.currentTime = MusicTimestamp.ofMilliseconds(millisecond);
        this.displayTexts[3] = this.timeFormat.formatted(this.currentTime.toShortString());
        this.displayTexts[0] = this.currentLyrics != null ? this.currentLyrics.stayOrNext(millisecond).getString() : (millisecond < 5000L ? class_2561.method_43471((String)"concerto.no_subtitle").getString() : "");
        this.displayTexts[1] = this.currentSubLyrics != null ? this.currentSubLyrics.stayOrNext(millisecond).getString() : "";
    }

    public Music playNext(int forward) {
        if (this.musicList.isEmpty()) {
            return null;
        }
        this.displayTexts[2] = class_2561.method_43471((String)"concerto.loading").getString();
        this.currentIndex = this.getNext(forward);
        try {
            this.currentMusic = this.musicList.get(this.currentIndex);
        }
        catch (IndexOutOfBoundsException e) {
            this.currentMusic = null;
            return null;
        }
        this.initMusicStatus();
        this.updateDisplayTexts();
        this.writeConfig();
        return this.currentMusic;
    }

    public void initMusicStatus(long startTime) {
        this.initMusicStatus();
        this.startTime = startTime;
    }

    public void initMusicStatus() {
        this.currentMeta = this.currentMusic.getMeta();
        try {
            Pair<Lyrics, Lyrics> lyrics = this.currentMusic.getLyrics();
            if (lyrics != null) {
                this.currentLyrics = lyrics.getFirst() == null || lyrics.getFirst().isEmpty() ? null : lyrics.getFirst();
                this.currentSubLyrics = lyrics.getSecond() == null || lyrics.getSecond().isEmpty() ? null : lyrics.getSecond();
            }
        }
        catch (Exception e) {
            this.currentSubLyrics = null;
            this.currentLyrics = null;
        }
        this.displayTexts[2] = "";
    }

    public void removeCurrent() {
        if (this.musicList.size() == 1) {
            this.clear();
        } else if (this.currentIndex < this.musicList.size()) {
            this.musicList.remove(this.currentIndex);
        }
    }

    public void remove(int index) {
        if (index <= this.currentIndex) {
            --this.currentIndex;
        }
        if (index < this.musicList.size()) {
            this.musicList.remove(index);
        }
    }

    private int getNext(int forward) {
        if (forward == 0) {
            return class_3532.method_15340((int)this.currentIndex, (int)0, (int)(this.getMusicList().size() - 1));
        }
        if (this.orderType == OrderType.NORMAL) {
            return (this.currentIndex + forward) % this.musicList.size();
        }
        if (this.orderType == OrderType.REVERSED) {
            if (this.currentIndex - (forward %= this.musicList.size()) < 0) {
                return this.musicList.size() - (forward - this.currentIndex);
            }
            return this.currentIndex - forward;
        }
        if (this.orderType == OrderType.LOOP) {
            return this.currentIndex;
        }
        return this.musicList.isEmpty() ? -1 : this.random.nextInt(this.musicList.size());
    }

    public void setOrderType(OrderType type) {
        this.orderType = type;
        this.writeConfig();
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public boolean isEmpty() {
        return this.musicList.isEmpty();
    }

    public String[] getDisplayTexts() {
        return this.displayTexts;
    }

    public Music getCurrentMusic() {
        return this.currentMusic;
    }

    public int getCurrentIndex() {
        return class_3532.method_15340((int)0, (int)this.currentIndex, (int)(this.musicList.size() - 1));
    }

    public ArrayList<Music> getMusicList() {
        return this.musicList;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
    }

    public void writeConfig() {
        ConcertoClient.MUSIC_CONFIG.write(MusicJsonParsers.toRaw(this));
    }

    public static String filenameFilter(String str) {
        return ILLEGAL_CHARS.matcher(str).replaceAll(" ");
    }

    public static void downloadMusics(List<Music> musics) {
        ConcertoRunner.run(() -> {
            File folder = new File("Concerto/Downloads");
            if (!folder.exists() || !folder.isDirectory()) {
                if (folder.mkdirs()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    return;
                }
            }
            try (ExecutorService service = Executors.newFixedThreadPool(16);){
                musics.forEach(music -> {
                    if (music instanceof CacheableMusic) {
                        CacheableMusic cacheableMusic = (CacheableMusic)((Object)music);
                        service.submit(() -> {
                            block19: {
                                MusicMetaData metaData = music.getMeta();
                                String filename = MusicPlayerHandler.filenameFilter(metaData.title() + " - " + metaData.author() + " - " + metaData.getSource());
                                File file = folder.toPath().resolve(filename + "." + cacheableMusic.getSuffix()).toFile();
                                File lrcFile = folder.toPath().resolve(filename + ".lrc").toFile();
                                try {
                                    if (!file.exists()) {
                                        if (file.createNewFile()) {
                                            try (FileOutputStream stream = new FileOutputStream(file);){
                                                stream.write(music.getMusicSource().readAllBytes());
                                            }
                                        }
                                        ConcertoClient.LOGGER.info("Downloaded: {}", (Object)filename);
                                    }
                                    String lyrics = music.getLyrics().getFirst().toString();
                                    try {
                                        AudioFile audioFile = AudioFileIO.read(file);
                                        Tag tag = audioFile.getTagOrCreateAndSetDefault();
                                        tag.setField(FieldKey.TITLE, metaData.title());
                                        tag.setField(FieldKey.ARTISTS, metaData.author());
                                        tag.setField(FieldKey.LYRICS, lyrics);
                                        if (!metaData.headPictureUrl().isEmpty()) {
                                            tag.setField(ArtworkFactory.createLinkedArtworkFromURL(metaData.headPictureUrl()));
                                        }
                                        audioFile.commit();
                                    }
                                    catch (Exception e) {
                                        ConcertoClient.LOGGER.warn("Cannot write tags into file: {}", (Object)file);
                                    }
                                    if (lrcFile.exists()) break block19;
                                    if (lrcFile.createNewFile()) {
                                        try (FileOutputStream stream = new FileOutputStream(lrcFile);){
                                            stream.write(lyrics.getBytes(StandardCharsets.UTF_8));
                                        }
                                    }
                                    ConcertoClient.LOGGER.info("Downloaded LRC: {}", (Object)filename);
                                }
                                catch (IOException e) {
                                    ConcertoClient.LOGGER.error("{} - {}", (Object)e, (Object)file.getAbsolutePath());
                                }
                            }
                        });
                    } else {
                        ConcertoClient.LOGGER.info("Detected non-cacheable music");
                    }
                });
                service.shutdown();
                try {
                    if (!service.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

