/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player.streamplayer.stream;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import top.gregtao.concerto.player.streamplayer.enums.AudioType;
import top.gregtao.concerto.player.streamplayer.stream.DataSource;
import top.gregtao.concerto.player.streamplayer.tools.TimeTool;

public class FileDataSource
implements DataSource {
    private final File source;

    FileDataSource(File source) {
        this.source = source;
    }

    @Override
    public AudioFileFormat getAudioFileFormat() throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormat(this.source);
    }

    @Override
    public AudioInputStream getAudioInputStream() throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStream(this.source);
    }

    @Override
    public int getDurationInSeconds() {
        return TimeTool.durationInSeconds(this.source.getAbsolutePath(), AudioType.FILE);
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeTool.durationInMilliseconds(this.source.getAbsolutePath(), AudioType.FILE);
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.getDurationInMilliseconds());
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return "FileDataSource with " + this.source.toString();
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

