/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player.streamplayer.stream;

import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Outlet {
    private final Logger logger;
    private FloatControl balanceControl;
    private FloatControl gainControl;
    private BooleanControl muteControl;
    private FloatControl panControl;
    private SourceDataLine sourceDataLine;

    public Outlet(Logger logger) {
        this.logger = logger;
    }

    public FloatControl getBalanceControl() {
        return this.balanceControl;
    }

    public FloatControl getGainControl() {
        return this.gainControl;
    }

    public BooleanControl getMuteControl() {
        return this.muteControl;
    }

    public FloatControl getPanControl() {
        return this.panControl;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public void setBalanceControl(FloatControl balanceControl) {
        this.balanceControl = balanceControl;
    }

    public void setGainControl(FloatControl gainControl) {
        this.gainControl = gainControl;
    }

    public void setMuteControl(BooleanControl muteControl) {
        this.muteControl = muteControl;
    }

    public void setPanControl(FloatControl panControl) {
        this.panControl = panControl;
    }

    public void setSourceDataLine(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
    }

    public boolean hasControl(Control.Type control, Control component) {
        return component != null && this.sourceDataLine != null && this.sourceDataLine.isControlSupported(control);
    }

    public float getGainValue() {
        if (this.hasControl(FloatControl.Type.MASTER_GAIN, this.getGainControl())) {
            return this.getGainControl().getValue();
        }
        return 0.0f;
    }

    void drainStopAndFreeDataLine() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.drain();
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
            this.sourceDataLine = null;
        }
    }

    void flushAndFreeDataLine() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.flush();
            this.sourceDataLine.close();
            this.sourceDataLine = null;
        }
    }

    void flushAndStop() {
        if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
            this.sourceDataLine.flush();
            this.sourceDataLine.stop();
        }
    }

    boolean isStartable() {
        return this.sourceDataLine != null && !this.sourceDataLine.isRunning();
    }

    void start() {
        this.sourceDataLine.start();
    }

    void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        this.logger.info("Entered OpenLine()!:\n");
        if (this.sourceDataLine != null) {
            this.sourceDataLine.open(format, bufferSize);
            if (this.sourceDataLine.isOpen()) {
                if (this.sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    this.setGainControl((FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN));
                } else {
                    this.setGainControl(null);
                }
                if (this.sourceDataLine.isControlSupported(FloatControl.Type.PAN)) {
                    this.setPanControl((FloatControl)this.sourceDataLine.getControl(FloatControl.Type.PAN));
                } else {
                    this.setPanControl(null);
                }
                BooleanControl muteControl1 = this.sourceDataLine.isControlSupported(BooleanControl.Type.MUTE) ? (BooleanControl)this.sourceDataLine.getControl(BooleanControl.Type.MUTE) : null;
                this.setMuteControl(muteControl1);
                FloatControl balanceControl = this.sourceDataLine.isControlSupported(FloatControl.Type.BALANCE) ? (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.BALANCE) : null;
                this.setBalanceControl(balanceControl);
            }
        }
        this.logger.info("Exited OpenLine()!:\n");
    }
}

