/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player.streamplayer.tools;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.io.RandomFileInputStream;
import org.kc7bfi.jflac.metadata.StreamInfo;
import top.gregtao.concerto.player.streamplayer.enums.AudioType;
import top.gregtao.concerto.player.streamplayer.tools.IOInfo;

public final class TimeTool {
    private TimeTool() {
    }

    public static String getTimeEditedOnHours(int seconds) {
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public static String getTimeEdited(int seconds) {
        if (seconds < 60) {
            return String.format("%02ds", seconds % 60);
        }
        if (seconds / 60 / 60 <= 0) {
            return String.format("%02dm:%02d", seconds / 60 % 60, seconds % 60);
        }
        return String.format("%02dh:%02dm:%02d", seconds / 60 / 60, seconds / 60 % 60, seconds % 60);
    }

    public static String millisecondsToTime(long ms) {
        int millis = (int)(ms % 1000L / 100L);
        return String.format(".%d", millis);
    }

    public static int durationInSeconds(String name, AudioType type) {
        long time = TimeTool.durationInMilliseconds(name, type);
        return (int)(time == 0L || time == -1L ? time : time / 1000L);
    }

    public static long durationInMilliseconds(String input, AudioType audioType) {
        return audioType == AudioType.FILE ? TimeTool.durationInMilliseconds_Part2(new File(input)) : -1L;
    }

    private static long durationInMilliseconds_Part2(File file) {
        long milliseconds = -1L;
        if (file.exists() && file.length() != 0L) {
            String extension = IOInfo.getFileExtension(file.getName());
            if ("mp3".equals(extension)) {
                try {
                    milliseconds = (long)new MP3File(file).getMP3AudioHeader().getTrackLength() * 1000L;
                    if (milliseconds == 0L) {
                        MP3AudioHeader header = new MP3File(file).getMP3AudioHeader();
                        double frameLengthInMilliseconds = (double)(switch (header.getMpegLayer()) {
                            case "Layer 1" -> 384;
                            case "Layer 2" -> 576;
                            case "Layer 3" -> 1152;
                            default -> 1152;
                        }) / (double)header.getSampleRateAsNumber() * 1000.0;
                        milliseconds = (long)((double)header.getNumberOfFrames() * frameLengthInMilliseconds);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Problem getting the time of-> " + file.getAbsolutePath());
                }
            } else if ("ogg".equals(extension) || "wav".equals(extension)) {
                try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);){
                    AudioFormat format = audioInputStream.getFormat();
                    milliseconds = (long)((double)file.length() / ((double)format.getFrameSize() * (double)format.getFrameRate()) * 1000.0);
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    System.err.println("Problem getting the time of-> " + file.getAbsolutePath());
                }
            } else if ("flac".equals(extension)) {
                try {
                    FLACDecoder decoder = new FLACDecoder(new RandomFileInputStream(file));
                    StreamInfo streamInfo = decoder.readStreamInfo();
                    if (streamInfo != null) {
                        long totalSamples = streamInfo.getTotalSamples();
                        int sampleRate = streamInfo.getSampleRate();
                        if (sampleRate > 0) {
                            return totalSamples / (long)sampleRate * 1000L;
                        }
                    }
                }
                catch (Exception e) {
                    milliseconds = 0L;
                }
            }
        }
        return milliseconds < 0L ? -1L : milliseconds;
    }
}

