/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_410;
import net.minecraft.class_437;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.api.UnsafeMusicException;
import top.gregtao.concerto.music.LocalFileMusic;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.screen.ConcertoScreen;
import top.gregtao.concerto.screen.GeneralPlaylistScreen;

public abstract class ApplyDraggedFileScreen
extends ConcertoScreen {
    public ApplyDraggedFileScreen(class_2561 title, class_437 parent) {
        super(title, parent);
    }

    public void method_29638(List<Path> paths) {
        if (this.field_22787 == null) {
            return;
        }
        String message = paths.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                AtomicInteger integer = new AtomicInteger(0);
                MusicPlayer.INSTANCE.addMusic(() -> {
                    ArrayList list = new ArrayList();
                    paths.forEach(path -> {
                        block11: {
                            File file = path.toFile();
                            try {
                                if (file.isDirectory()) {
                                    list.addAll(LocalFileMusic.getMusicsInFolder(file));
                                    break block11;
                                }
                                if (path.toString().toLowerCase().endsWith(".json")) {
                                    try (FileInputStream inputStream = new FileInputStream(file);){
                                        Playlist playlist = MusicJsonParsers.fromPlaylist(new String(inputStream.readAllBytes()));
                                        if (playlist != null) {
                                            list.addAll(playlist.getList());
                                        }
                                        break block11;
                                    }
                                }
                                list.add(new LocalFileMusic(file.getAbsolutePath()));
                            }
                            catch (IOException e) {
                                this.displayAlert((class_2561)class_2561.method_43470((String)e.getMessage()));
                            }
                            catch (UnsafeMusicException e) {
                                this.displayAlert((class_2561)class_2561.method_43471((String)"concerto.error.invalid_path"));
                            }
                        }
                    });
                    integer.set(list.size());
                    return list;
                }, () -> {
                    MusicPlayer.INSTANCE.skipTo(MusicPlayerHandler.INSTANCE.getMusicList().size() - integer.get());
                    ApplyDraggedFileScreen patt0$temp = this;
                    if (patt0$temp instanceof GeneralPlaylistScreen) {
                        GeneralPlaylistScreen screen = (GeneralPlaylistScreen)patt0$temp;
                        screen.toggleSearch();
                    }
                });
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"concerto.drag_confirm"), (class_2561)class_2561.method_43470((String)message)));
    }
}

