/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen.kugou;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.screen.ConcertoScreen;
import top.gregtao.concerto.screen.login.CaptchaLoginScreen;
import top.gregtao.concerto.screen.login.CookieLoginScreen;
import top.gregtao.concerto.screen.login.PasswordLoginScreen;
import top.gregtao.concerto.screen.login.QRCodeLoginScreen;
import top.gregtao.concerto.util.Pair;
import top.gregtao.concerto.util.QRCodeRenderer;

public class KuGouMusicLoginScreen
extends ConcertoScreen {
    public static class_2561 SOURCE_TEXT = class_2561.method_43471((String)"concerto.source.kugou_music");

    public KuGouMusicLoginScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"concerto.screen.login").getString() + SOURCE_TEXT.getString())), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"concerto.screen.login.type.password"), button -> class_310.method_1551().method_1507((class_437)this.passwordLogin())).method_46437(100, 20).method_46433(this.field_22789 / 2 - 50, 40).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"concerto.screen.login.type.captcha"), button -> class_310.method_1551().method_1507((class_437)this.captchaLogin())).method_46437(100, 20).method_46433(this.field_22789 / 2 - 50, 70).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"concerto.screen.login.type.qrcode"), button -> class_310.method_1551().method_1507((class_437)this.qrCodeLogin())).method_46437(100, 20).method_46433(this.field_22789 / 2 - 50, 100).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"concerto.screen.login.type.cookie"), button -> class_310.method_1551().method_1507((class_437)this.cookieLogin())).method_46437(100, 20).method_46433(this.field_22789 / 2 - 50, 130).method_46431());
    }

    private static boolean loginChecker() {
        return KuGouMusicApiClient.LOCAL_USER.isLoggedIn();
    }

    public PasswordLoginScreen passwordLogin() {
        return new PasswordLoginScreen(KuGouMusicLoginScreen::loginChecker, (username, password) -> {
            try {
                Optional<Pair<Long, String>> optional = KuGouMusicApiClient.INSTANCE.login((String)username, (String)password);
                if (optional.isPresent()) {
                    Pair<Long, String> pair = optional.get();
                    this.setCookies(pair.getFirst(), pair.getSecond());
                    return class_2561.method_43471((String)"concerto.login.kugou.success");
                }
                return class_2561.method_43471((String)"concerto.login.kugou.failed");
            }
            catch (Exception e) {
                return class_2561.method_43471((String)"concerto.login.kugou.error");
            }
        }, SOURCE_TEXT, this);
    }

    public CaptchaLoginScreen captchaLogin() {
        return new CaptchaLoginScreen(phone -> {
            try {
                KuGouMusicApiClient.INSTANCE.sendPhoneCaptcha((String)phone);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, KuGouMusicLoginScreen::loginChecker, (username, password) -> {
            try {
                Optional<Pair<Long, String>> result = KuGouMusicApiClient.INSTANCE.cellphoneLogin((String)username, (String)password);
                if (result.isPresent()) {
                    Pair<Long, String> pair = result.get();
                    this.setCookies(pair.getFirst(), pair.getSecond());
                    return class_2561.method_43471((String)"concerto.login.kugou.success");
                }
                return class_2561.method_43471((String)"concerto.login.kugou.failed");
            }
            catch (Exception e) {
                return class_2561.method_43471((String)"concerto.login.kugou.error");
            }
        }, SOURCE_TEXT, this);
    }

    public QRCodeLoginScreen qrCodeLogin() {
        return new QRCodeLoginScreen(() -> {
            try {
                return KuGouMusicApiClient.INSTANCE.generateQRCodeKey();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, key -> QRCodeRenderer.generateQRCode(KuGouMusicApiClient.INSTANCE.getQRCodeLoginLink((String)key), 5), key -> {
            try {
                Optional<JsonObject> optional = KuGouMusicApiClient.INSTANCE.getQRCodeStatus((String)key);
                Optional<JsonObject> dataOpt = optional.map(json -> json.getAsJsonObject("data"));
                Integer status = dataOpt.map(data -> data.get("status")).map(JsonElement::getAsInt).orElse(0);
                if (status == 1 || status == 2) {
                    return QRCodeLoginScreen.Status.WAITING;
                }
                if (status == 0) {
                    return QRCodeLoginScreen.Status.EXPIRED;
                }
                if (status == 4) {
                    Long userId = dataOpt.map(data -> data.get("userid")).map(JsonElement::getAsLong).orElseThrow();
                    String token = dataOpt.map(data -> data.get("token")).map(JsonElement::getAsString).orElseThrow();
                    this.setCookies(userId, token);
                    return QRCodeLoginScreen.Status.SUCCESS;
                }
                return QRCodeLoginScreen.Status.EMPTY;
            }
            catch (Exception e) {
                ConcertoClient.LOGGER.error("Error in KuGou Music QR Login", (Throwable)e);
                throw new RuntimeException(e);
            }
        }, 110, 110, SOURCE_TEXT, this);
    }

    public void setCookies(Long userId, String token) throws IOException, URISyntaxException {
        KuGouMusicApiClient.LOCAL_USER.setUserId(userId);
        KuGouMusicApiClient.INSTANCE.setCookies("https://www.kugou.com/", new HashMap<String, String>(Map.of("userid", userId.toString(), "token", token)));
        KuGouMusicApiClient.LOCAL_USER.updateLoginStatus();
        KuGouMusicApiClient.LOCAL_USER.updateVIPStatus();
    }

    public CookieLoginScreen cookieLogin() {
        return new CookieLoginScreen(() -> {
            boolean updated = KuGouMusicApiClient.LOCAL_USER.updateLoginStatus();
            if (updated) {
                KuGouMusicApiClient.LOCAL_USER.updateVIPStatus();
            }
            return updated;
        }, List.of("https://www.kugou.com/"), KuGouMusicApiClient.INSTANCE, SOURCE_TEXT, this);
    }
}

