/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_7172;
import org.apache.logging.log4j.util.TriConsumer;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.enums.TextAlignment;

public class ConcertoOptions {
    public static ConcertoOptions INSTANCE = new ConcertoOptions(ClientConfig.INSTANCE);
    public boolean canUpdate = false;
    private final ClientConfig config;
    private final List<OptionsUpdater> updaters = new ArrayList<OptionsUpdater>();

    public ConcertoOptions(ClientConfig config) {
        this.config = config;
        this.updaters.add(new SingleBooleanOption("confirmAfterReceived", value -> {
            this.config.options.confirmAfterReceived = value;
        }, () -> this.config.options.confirmAfterReceived));
        this.updaters.add(new SingleBooleanOption("hideWhenChat", value -> {
            this.config.options.hideWhenChat = value;
        }, () -> this.config.options.hideWhenChat));
        this.updaters.add(new SingleBooleanOption("printRequestResults", value -> {
            this.config.options.printRequestResults = value;
        }, () -> this.config.options.printRequestResults));
        this.updaters.add(new SingleBooleanOption("joinAgentWhenInvited", value -> {
            this.config.options.joinAgentWhenInvited = value;
        }, () -> this.config.options.joinAgentWhenInvited));
        this.updaters.add(new SingleBooleanOption("textShadow", value -> {
            this.config.options.textShadow = value;
        }, () -> this.config.options.textShadow));
        this.updaters.add(new SingleBooleanOption("handshakeRequired", value -> {
            this.config.options.handshakeRequired = value;
        }, () -> this.config.options.handshakeRequired));
        this.updaters.add(new TextOptions("lyrics", (TriConsumer<Boolean, TextAlignment, String>)((TriConsumer)(display, align, pos) -> {
            this.config.options.displayLyrics = display;
            this.config.options.lyricsAlignment = align;
            this.config.options.lyricsPosition = pos;
            this.config.parseOptions();
        }), options -> {
            options.display.method_41748((Object)this.config.options.displayLyrics);
            options.align.method_41748((Object)this.config.options.lyricsAlignment.ordinal());
            TextOptions.setPosition(options, this.config.lyricsPosSupplier);
        }));
        this.updaters.add(new TextOptions("subLyrics", (TriConsumer<Boolean, TextAlignment, String>)((TriConsumer)(display, align, pos) -> {
            this.config.options.displaySubLyrics = display;
            this.config.options.subLyricsAlignment = align;
            this.config.options.subLyricsPosition = pos;
            this.config.parseOptions();
        }), options -> {
            options.display.method_41748((Object)this.config.options.displaySubLyrics);
            options.align.method_41748((Object)this.config.options.subLyricsAlignment.ordinal());
            TextOptions.setPosition(options, this.config.subLyricsPosSupplier);
        }));
        this.updaters.add(new TextOptions("musicDetails", (TriConsumer<Boolean, TextAlignment, String>)((TriConsumer)(display, align, pos) -> {
            this.config.options.displayMusicDetails = display;
            this.config.options.musicDetailsAlignment = align;
            this.config.options.musicDetailsPosition = pos;
            this.config.parseOptions();
        }), options -> {
            options.display.method_41748((Object)this.config.options.displayMusicDetails);
            options.align.method_41748((Object)this.config.options.musicDetailsAlignment.ordinal());
            TextOptions.setPosition(options, this.config.musicDetailsPosSupplier);
        }));
        this.updaters.add(new TextOptions("timeProgress", (TriConsumer<Boolean, TextAlignment, String>)((TriConsumer)(display, align, pos) -> {
            this.config.options.displayTimeProgress = display;
            this.config.options.timeProgressAlignment = align;
            this.config.options.timeProgressPosition = pos;
            this.config.parseOptions();
        }), options -> {
            options.display.method_41748((Object)this.config.options.displayTimeProgress);
            options.align.method_41748((Object)this.config.options.timeProgressAlignment.ordinal());
            TextOptions.setPosition(options, this.config.timeProgressPosSupplier);
        }));
        this.updaters.add(new ImageOptions("coverImg", (TriConsumer<Boolean, Integer, String>)((TriConsumer)(display, size, pos) -> {
            this.config.options.displayCoverImg = display;
            this.config.options.coverImgSize = size;
            this.config.options.coverImgPosition = pos;
            this.config.parseOptions();
        }), options -> {
            options.display.method_41748((Object)this.config.options.displayCoverImg);
            options.size.method_41748((Object)this.config.options.coverImgSize);
            PosOptions.setPosition(options, this.config.coverImgPosSupplier);
        }));
        this.updaters.add(new SingleBooleanOption("coverImgInCircle", value -> {
            this.config.options.coverImgInCircle = value;
        }, () -> this.config.options.coverImgInCircle));
        this.updaters.add(new SingleBooleanOption("coverImgRotate", value -> {
            this.config.options.coverImgRotate = value;
        }, () -> this.config.options.coverImgRotate));
        this.updaters.add(new SingleBooleanOption("kugouIsLite", value -> {
            this.config.options.kuGouMusicLite = value;
        }, () -> this.config.options.kuGouMusicLite));
        this.updaters.add(new SingleBooleanOption("autoGetKuGouDailyVIP", value -> {
            this.config.options.autoGetKuGouDailyVIP = value;
        }, () -> this.config.options.autoGetKuGouDailyVIP));
    }

    public class_7172<?>[] getOptions() {
        return (class_7172[])this.updaters.stream().flatMap(OptionsUpdater::streamOptions).toArray(class_7172[]::new);
    }

    public void readOptions() {
        this.canUpdate = false;
        this.updaters.forEach(OptionsUpdater::readOptions);
        this.canUpdate = true;
    }

    public void writeOptions() {
        if (!this.canUpdate) {
            return;
        }
        this.updaters.forEach(OptionsUpdater::writeOptions);
        this.config.parseOptions();
    }

    public void saveOptions() {
        this.writeOptions();
        this.config.writeOptions();
    }

    public void resetOptions() {
        this.config.resetOptions();
        this.readOptions();
    }

    private static class_2561 getPixelValueText(class_2561 prefix, int value) {
        return class_2561.method_43469((String)"options.pixel_value", (Object[])new Object[]{prefix, value});
    }

    private static class_2561 getPercentValueText(class_2561 prefix, double value) {
        return class_2561.method_43469((String)"options.percent_value", (Object[])new Object[]{prefix, (int)(value * 100.0)});
    }

    private static class_2561 getAlignValueText(class_2561 prefix, int value) {
        return class_2561.method_43469((String)"concerto.options.align", (Object[])new Object[]{prefix, class_2561.method_43471((String)("concerto.options.align." + TextAlignment.values()[value].name().toLowerCase()))});
    }

    private static String getPositionString(double percent, int delta) {
        return String.format("%.2f%+d", Math.clamp(percent, 0.0, 1.0), delta);
    }

    private static String getPositionXYString(double xPercent, int xDelta, double yPercent, int yDelta) {
        return ConcertoOptions.getPositionString(xPercent, xDelta) + "," + ConcertoOptions.getPositionString(yPercent, yDelta);
    }

    private class SingleBooleanOption
    implements OptionsUpdater {
        public final class_7172<Boolean> option;
        private final Consumer<Boolean> writer;
        private final Supplier<Boolean> reader;

        public SingleBooleanOption(String name, Consumer<Boolean> writer, Supplier<Boolean> reader) {
            this.writer = writer;
            this.reader = reader;
            this.option = class_7172.method_41751((String)("concerto.options." + name), (boolean)true, value -> this.writeOptions());
        }

        @Override
        public void readOptions() {
            this.option.method_41748((Object)this.reader.get());
        }

        @Override
        public void writeOptions() {
            if (!ConcertoOptions.this.canUpdate) {
                return;
            }
            this.writer.accept((Boolean)this.option.method_41753());
        }

        @Override
        public Stream<class_7172<?>> streamOptions() {
            return Stream.of(this.option);
        }
    }

    private class TextOptions
    extends PosOptions {
        public final class_7172<Integer> align;
        private final TriConsumer<Boolean, TextAlignment, String> writer;
        private final Consumer<TextOptions> reader;

        public TextOptions(String name, TriConsumer<Boolean, TextAlignment, String> writer, Consumer<TextOptions> reader) {
            super(name, null, null);
            this.writer = writer;
            this.reader = reader;
            this.align = new class_7172("concerto.options.align." + name, class_7172.method_42399(), ConcertoOptions::getAlignValueText, (class_7172.class_7178)new class_7172.class_7174(0, 2), (Object)0, value -> this.writeOptions());
        }

        @Override
        public void readOptions() {
            this.reader.accept(this);
        }

        @Override
        public void writeOptions() {
            if (!ConcertoOptions.this.canUpdate) {
                return;
            }
            this.writer.accept((Object)((Boolean)this.display.method_41753()), (Object)TextAlignment.values()[(Integer)this.align.method_41753()], (Object)ConcertoOptions.getPositionXYString((Double)this.posXPercent.method_41753(), (Integer)this.posXDelta.method_41753(), (Double)this.posYPercent.method_41753(), (Integer)this.posYDelta.method_41753()));
        }

        @Override
        public Stream<class_7172<?>> streamOptions() {
            return Stream.of(this.display, this.align, this.posXPercent, this.posXDelta, this.posYPercent, this.posYDelta);
        }
    }

    private class ImageOptions
    extends PosOptions {
        public final class_7172<Integer> size;
        private final TriConsumer<Boolean, Integer, String> writer;
        private final Consumer<ImageOptions> reader;

        public ImageOptions(String name, TriConsumer<Boolean, Integer, String> writer, Consumer<ImageOptions> reader) {
            super(name, null, null);
            this.writer = writer;
            this.reader = reader;
            this.size = new class_7172("concerto.options.size." + name, class_7172.method_42399(), ConcertoOptions::getPixelValueText, (class_7172.class_7178)new class_7172.class_7174(0, 300), (Object)0, value -> this.writeOptions());
        }

        @Override
        public void readOptions() {
            this.reader.accept(this);
        }

        @Override
        public void writeOptions() {
            if (!ConcertoOptions.this.canUpdate) {
                return;
            }
            this.writer.accept((Object)((Boolean)this.display.method_41753()), (Object)((Integer)this.size.method_41753()), (Object)ConcertoOptions.getPositionXYString((Double)this.posXPercent.method_41753(), (Integer)this.posXDelta.method_41753(), (Double)this.posYPercent.method_41753(), (Integer)this.posYDelta.method_41753()));
        }

        @Override
        public Stream<class_7172<?>> streamOptions() {
            return Stream.of(this.display, this.size, this.posXPercent, this.posXDelta, this.posYPercent, this.posYDelta);
        }
    }

    private class PosOptions
    implements OptionsUpdater {
        public final class_7172<Boolean> display;
        public final class_7172<Double> posXPercent;
        public final class_7172<Integer> posXDelta;
        public final class_7172<Double> posYPercent;
        public final class_7172<Integer> posYDelta;
        private final BiConsumer<Boolean, String> writer;
        private final Consumer<PosOptions> reader;

        public PosOptions(String name, BiConsumer<Boolean, String> writer, Consumer<PosOptions> reader) {
            this.writer = writer;
            this.reader = reader;
            this.display = class_7172.method_41751((String)("concerto.options.display." + name), (boolean)true, value -> this.writeOptions());
            this.posXPercent = new class_7172("concerto.options.posXPercent." + name, class_7172.method_42399(), ConcertoOptions::getPercentValueText, (class_7172.class_7178)class_7172.class_7177.field_37875, (Object)1.0, value -> this.writeOptions());
            this.posXDelta = new class_7172("concerto.options.posXDelta." + name, class_7172.method_42399(), ConcertoOptions::getPixelValueText, (class_7172.class_7178)new class_7172.class_7174(-250, 250), (Object)0, value -> this.writeOptions());
            this.posYPercent = new class_7172("concerto.options.posYPercent." + name, class_7172.method_42399(), ConcertoOptions::getPercentValueText, (class_7172.class_7178)class_7172.class_7177.field_37875, (Object)1.0, value -> this.writeOptions());
            this.posYDelta = new class_7172("concerto.options.posYDelta." + name, class_7172.method_42399(), ConcertoOptions::getPixelValueText, (class_7172.class_7178)new class_7172.class_7174(-250, 250), (Object)0, value -> this.writeOptions());
        }

        protected static void setPosition(PosOptions options, ClientConfig.PositionXYSupplier pos) {
            options.posXPercent.method_41748((Object)pos.getX().getPercentage());
            options.posXDelta.method_41748((Object)pos.getX().getDelta());
            options.posYPercent.method_41748((Object)pos.getY().getPercentage());
            options.posYDelta.method_41748((Object)pos.getY().getDelta());
        }

        @Override
        public void readOptions() {
            this.reader.accept(this);
        }

        @Override
        public void writeOptions() {
            if (!ConcertoOptions.this.canUpdate) {
                return;
            }
            this.writer.accept((Boolean)this.display.method_41753(), ConcertoOptions.getPositionXYString((Double)this.posXPercent.method_41753(), (Integer)this.posXDelta.method_41753(), (Double)this.posYPercent.method_41753(), (Integer)this.posYDelta.method_41753()));
        }

        @Override
        public Stream<class_7172<?>> streamOptions() {
            return Stream.of(this.display, this.posXPercent, this.posXDelta, this.posYPercent, this.posYDelta);
        }
    }

    private static interface OptionsUpdater {
        public void readOptions();

        public void writeOptions();

        public Stream<class_7172<?>> streamOptions();
    }
}

