/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.cdda.cooked_ioctl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.cdda.CddaMidLevel;
import org.tritonus.lowlevel.cdda.cooked_ioctl.CookedIoctl;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class CookedIoctlMidLevel
implements CddaMidLevel {
    private static int PCM_FRAMES_PER_CDDA_FRAME = 588;
    private static AudioFormat CDDA_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);

    public CookedIoctlMidLevel() {
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.<init>(): begin");
        }
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.<init>(): end");
        }
    }

    public Iterator getDevices() {
        String[] astrDevices = new String[]{"/dev/cdrom"};
        List<String> devicesList = Arrays.asList(astrDevices);
        Iterator<String> iterator = devicesList.iterator();
        return iterator;
    }

    public String getDefaultDevice() {
        return "/dev/cdrom";
    }

    public InputStream getTocAsXml(String strDevice) throws IOException {
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.getTocAsXML(): begin");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        int[] anValues = new int[2];
        int[] anStartFrame = new int[100];
        int[] anLength = new int[100];
        int[] anType = new int[100];
        boolean[] abCopy = new boolean[100];
        boolean[] abPre = new boolean[100];
        int[] anChannels = new int[100];
        CookedIoctl cookedIoctl = new CookedIoctl(strDevice);
        cookedIoctl.readTOC(anValues, anStartFrame, anLength, anType, abCopy, abPre, anChannels);
        int nTracks = anValues[1] - anValues[0] + 1;
        for (int i = 0; i <= nTracks; ++i) {
            out.print("<track");
            out.print(" id=\"" + (i + anValues[0]) + "\"");
            out.print(" start=\"" + anStartFrame[i] + "\"");
            out.print(" type=\"" + anType[i] + "\" />\n");
        }
        byte[] abData = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(abData);
        cookedIoctl.close();
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.getTocAsXML(): end");
        }
        return bais;
    }

    public AudioInputStream getTrack(String strDevice, int nTrack) throws IOException {
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.getInputStream(): begin");
        }
        CddaAudioInputStream audioInputStream = new CddaAudioInputStream(strDevice, nTrack);
        if (TDebug.TraceCdda) {
            TDebug.out("CookedIoctlMidLevel.getInputStream(): end");
        }
        return audioInputStream;
    }

    private class CddaAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private static final int BUFFER_SIZE = 2352;
        private CookedIoctl m_cookedIoctl;
        private int m_nCddaFrameCount;
        private int m_nStartFrame;
        private int m_nEndFrame;
        private byte[] m_abData;
        private int m_nTrack;

        public CddaAudioInputStream(String strDevice, int nTrack) {
            super(CDDA_FORMAT, -1L);
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.<init>(): begin");
            }
            this.m_nTrack = nTrack;
            int[] anValues = new int[2];
            int[] anStartFrame = new int[100];
            int[] anLength = new int[100];
            int[] anType = new int[100];
            boolean[] abCopy = new boolean[100];
            boolean[] abPre = new boolean[100];
            int[] anChannels = new int[100];
            this.m_cookedIoctl = new CookedIoctl(strDevice);
            this.m_cookedIoctl.readTOC(anValues, anStartFrame, anLength, anType, abCopy, abPre, anChannels);
            this.m_nCddaFrameCount = 0;
            this.m_nStartFrame = anStartFrame[this.getTrack()];
            this.frameLength = this.getTrackLengthInPcmFrames();
            this.m_abData = new byte[2352];
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.<init>(): end");
            }
        }

        private long getTrackLengthInPcmFrames() {
            int nCddaFrames = this.getTrackLengthInCddaFrames();
            long lLength = nCddaFrames * PCM_FRAMES_PER_CDDA_FRAME;
            return lLength;
        }

        private int getTrackLengthInCddaFrames() {
            int nLength = this.getEndFrame() - this.getStartFrame() + 1;
            return nLength;
        }

        private int getStartFrame() {
            return this.m_nStartFrame;
        }

        private int getEndFrame() {
            return this.m_nEndFrame;
        }

        private int getTrack() {
            return this.m_nTrack;
        }

        private int getCurrentFrameNumber() {
            return this.m_nCddaFrameCount + this.m_nStartFrame;
        }

        private void increaseCurrentFrameNumber() {
            ++this.m_nCddaFrameCount;
        }

        private boolean isEndOfTrackReached() {
            return this.m_nCddaFrameCount >= this.getTrackLengthInCddaFrames();
        }

        public void execute() {
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.execute(): begin");
            }
            if (!this.isEndOfTrackReached()) {
                if (TDebug.TraceCdda) {
                    TDebug.out("CddaAudioInputStream.execute(): begin");
                }
                while (this.getCircularBuffer().availableWrite() >= 2352 && !this.isEndOfTrackReached()) {
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): before readFrame()");
                    }
                    this.m_cookedIoctl.readFrame(this.getCurrentFrameNumber(), 1, this.m_abData);
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): after readFrame(), before cb.write()");
                    }
                    this.getCircularBuffer().write(this.m_abData, 0, 2352);
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): after cb.write()");
                    }
                    this.increaseCurrentFrameNumber();
                }
            } else {
                if (TDebug.TraceCdda) {
                    TDebug.out("CddaAudioInputStream.execute(): end of cdda track");
                }
                this.getCircularBuffer().close();
            }
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.execute(): end");
            }
        }

        public void close() throws IOException {
            this.m_cookedIoctl.close();
            super.close();
        }
    }
}

