/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto;

import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gregtao.concerto.command.MusicCommand;
import top.gregtao.concerto.command.MusicRoomCommand;
import top.gregtao.concerto.command.ShareMusicCommand;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.config.ConfigFile;
import top.gregtao.concerto.config.PresetPlaylistsConfig;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.http.netease.NeteaseCloudApiClient;
import top.gregtao.concerto.http.qq.QQMusicApiClient;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.network.ClientMusicNetworkHandler;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.util.ConcertoHotkeys;
import top.gregtao.concerto.util.ConcertoOptions;
import top.gregtao.concerto.util.ConcertoRunner;

public class ConcertoClient
implements ClientModInitializer {
    public static final String MOD_ID = "concerto";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ConcertoClient");
    public static final ConfigFile MUSIC_CONFIG = new ConfigFile("Concerto/musics.json");
    public static ClientState clientState = ClientState.LOCAL;
    public static boolean serverAvailable = false;
    public static List<Playlist> presetRadios = List.of();

    public static boolean isServerAvailable() {
        return serverAvailable || !ClientConfig.INSTANCE.options.handshakeRequired || class_310.method_1551().method_1542();
    }

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register(MusicCommand::register);
        ClientCommandRegistrationCallback.EVENT.register(ShareMusicCommand::register);
        ClientCommandRegistrationCallback.EVENT.register(MusicRoomCommand::register);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_43902((String)ConcertoClient.MOD_ID, (String)"music");
            }

            public void method_14491(class_3300 manager) {
                ConcertoRunner.run(() -> {
                    ClientConfig.INSTANCE.readOptions();
                    ConcertoOptions.INSTANCE.readOptions();
                    MusicPlayer.INSTANCE.reloadConfig(() -> LOGGER.info("Loaded general music playlist"));
                    PresetPlaylistsConfig.LOCAL_PLAYLISTS.read();
                    NeteaseCloudApiClient.LOCAL_USER.updateLoginStatus();
                    QQMusicApiClient.LOCAL_USER.updateLoginStatus();
                    KuGouMusicApiClient.LOCAL_USER.updateLoginStatus();
                    KuGouMusicApiClient.INSTANCE.refreshToken();
                    KuGouMusicApiClient.LOCAL_USER.updateVIPStatus();
                    if (ClientConfig.INSTANCE.options.kuGouMusicLite && KuGouMusicApiClient.LOCAL_USER.isLoggedIn() && ClientConfig.INSTANCE.options.autoGetKuGouDailyVIP) {
                        KuGouMusicApiClient.INSTANCE.receiveVip();
                    }
                });
            }
        });
        ClientMusicNetworkHandler.register();
        ConcertoHotkeys.register();
    }

    public static enum ClientState {
        LOCAL,
        MUSIC_ROOM,
        MUSIC_AGENT;

    }
}

