/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.Pair;

public class CacheManager {
    public static String CACHE_ROOT_FOLDER = "Concerto/cache/";
    public static CacheManager IMAGE_CACHE_MANAGER = new CacheManager("images");
    private final File folder;
    private int maxSize = 100000000;

    public CacheManager(String name) {
        this.folder = new File(CACHE_ROOT_FOLDER + name);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            throw new RuntimeException("Cannot mkdir");
        }
    }

    public CacheManager(String name, int maxSize) {
        this(name);
        this.maxSize = maxSize;
    }

    public static void cleanAllCache() {
        Path cacheRoot = Paths.get(CACHE_ROOT_FOLDER, new String[0]);
        if (!Files.exists(cacheRoot, new LinkOption[0]) || !Files.isDirectory(cacheRoot, new LinkOption[0])) {
            ConcertoServer.LOGGER.error("Cache folder does not exist or is not a directory: {}", (Object)cacheRoot);
            return;
        }
        try (Stream<Path> walk = Files.walk(cacheRoot, 1, new FileVisitOption[0]);){
            walk.filter(path -> !path.equals(cacheRoot)).forEach(CacheManager::deleteRecursively);
        }
        catch (IOException e) {
            ConcertoServer.LOGGER.error("Failed to scan cache folder: {}", (Object)cacheRoot, (Object)e);
        }
    }

    private static void deleteRecursively(Path path) {
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    ConcertoServer.LOGGER.error("Failed to delete: {}", p, (Object)e);
                }
            });
        }
        catch (IOException e) {
            ConcertoServer.LOGGER.error("Failed to traverse path: {}", (Object)path, (Object)e);
        }
    }

    public File getChild(String child) {
        return new File(this.folder.getAbsolutePath() + "/" + child);
    }

    public long getTotalSize() {
        long size = 0L;
        for (File file : Objects.requireNonNull(this.folder.listFiles())) {
            size += file.isFile() ? file.length() : 0L;
        }
        return size;
    }

    public void removeEarliest() {
        File[] files = this.folder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        AtomicLong size = new AtomicLong();
        List<Pair> list = Arrays.stream(files).filter(File::isFile).map(file -> {
            long len = file.length();
            size.addAndGet(len);
            try {
                BasicFileAttributes attributes = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
                return Pair.of(Pair.of(file, len), attributes.creationTime().toMillis());
            }
            catch (IOException e) {
                ConcertoClient.LOGGER.warn("Error occurs while trying removing a file", (Throwable)e);
                return Pair.of(Pair.of(file, len), 0L);
            }
        }).sorted(Comparator.comparingLong(Pair::getSecond)).toList();
        long finalSize = size.get();
        for (int pos = 0; finalSize > (long)this.maxSize && pos < list.size(); ++pos) {
            Pair pair = (Pair)list.get(pos).getFirst();
            if (((File)pair.getFirst()).delete()) {
                finalSize -= ((Long)pair.getSecond()).longValue();
                continue;
            }
            ConcertoClient.LOGGER.warn("Cannot remove file {}", (Object)((File)pair.getFirst()).getAbsolutePath());
        }
    }

    public boolean exists(String filename) {
        File file = this.getChild(filename);
        return file.exists() && !file.isDirectory();
    }

    public void addFile(String filename, InputStream inputStream) throws IOException {
        File file = this.getChild(filename);
        if (file.exists() || !file.getParentFile().exists() && !file.getParentFile().mkdirs() || !file.createNewFile()) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(inputStream.readAllBytes());
        }
        inputStream.close();
        if (this.getTotalSize() > (long)this.maxSize) {
            ConcertoRunner.run(this::removeEarliest);
        }
    }
}

