/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.network.room.ServerMusicAgent;
import top.gregtao.concerto.util.JsonUtil;

public class PresetPlaylistsConfig {
    public static final PresetPlaylistsConfig PRESET_RADIOS = new PresetPlaylistsConfig("preset_radios");
    public static final PresetPlaylistsConfig LOCAL_PLAYLISTS = new PresetPlaylistsConfig("local_playlists");
    private final File folder;
    private final List<Playlist> radios = new ArrayList<Playlist>();

    public PresetPlaylistsConfig(String folder) {
        this.folder = new File("Concerto/" + folder);
    }

    public List<Playlist> getRadios() {
        return this.radios;
    }

    public boolean checkPath() {
        if (!(this.folder.exists() && this.folder.isDirectory() || this.folder.mkdirs())) {
            ConcertoServer.LOGGER.error("Cannot mkdir: {}", (Object)this.folder);
            return false;
        }
        return this.folder.exists() && this.folder.isDirectory();
    }

    public void read() {
        if (!this.checkPath()) {
            ConcertoServer.LOGGER.info("No preset radios found.");
        }
        this.radios.clear();
        File[] files = this.folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    String content = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                    Playlist playlist = MusicJsonParsers.fromPlaylist(content);
                    if (playlist == null) {
                        throw new IOException();
                    }
                    if (file.getName().toLowerCase().endsWith("music_agent.json")) {
                        ServerMusicAgent.INSTANCE.freeTimePlaylist.addAll(playlist.getList());
                        ConcertoServer.LOGGER.info("Free time playlist for server music agent is loaded.");
                    }
                    this.radios.add(playlist);
                    ConcertoServer.LOGGER.info("Loaded preset radio: {} in {}", (Object)playlist.getMeta().title(), (Object)file.getName());
                }
                catch (IOException e) {
                    ConcertoServer.LOGGER.error("Error reading file: {}", (Object)file.getName());
                }
            }
        } else {
            ConcertoServer.LOGGER.info("No preset radios found.");
        }
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        JsonArray array = new JsonArray();
        for (Playlist playlist : this.getRadios()) {
            JsonObject object1 = MusicJsonParsers.toPlaylist(playlist);
            if (object1 == null) continue;
            array.add((JsonElement)object1);
        }
        object.add("data", (JsonElement)array);
        return object;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static List<Playlist> fromJson(JsonObject object) {
        try {
            ArrayList<Playlist> playlists = new ArrayList<Playlist>();
            for (JsonElement element : object.getAsJsonArray("data")) {
                Playlist playlist = MusicJsonParsers.fromPlaylist(element.getAsJsonObject());
                if (playlist == null) continue;
                playlists.add(playlist);
            }
            return playlists;
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static List<Playlist> fromJson(String s) {
        return PresetPlaylistsConfig.fromJson(JsonUtil.from(s));
    }

    public static boolean saveToLocalPlaylists(Playlist playlist) {
        File file = new File("Concerto/local_playlists/" + System.currentTimeMillis() + ".json");
        try {
            if (file.exists() || file.createNewFile()) {
                FileWriter writer = new FileWriter(file);
                writer.write(MusicJsonParsers.toPlaylist(playlist).toString());
                writer.close();
                return true;
            }
            throw new IOException();
        }
        catch (IOException e) {
            ConcertoClient.LOGGER.error("Cannot create/open file: {}", (Object)e.toString());
            return false;
        }
    }
}

