/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Quaternionf;
import org.joml.Vector2i;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.enums.TextAlignment;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.util.TextUtil;

public class InGameHudRenderer {
    public static ScrollingText MUSIC_DETAIL_SCROLL = new ScrollingText();

    public static void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_310 client = class_310.method_1551();
        if (MusicPlayer.INSTANCE.isPlaying()) {
            ClientConfig config = ClientConfig.INSTANCE;
            ClientConfig.ClientConfigOptions options = config.options;
            if (!options.hideWhenChat || !(client.field_1755 instanceof class_408)) {
                Vector2i pos;
                Vector2i pos2;
                int scaledWidth = client.method_22683().method_4486();
                int scaledHeight = client.method_22683().method_4502();
                String[] texts = MusicPlayerHandler.INSTANCE.getDisplayTexts();
                context = new class_332(class_310.method_1551(), context.method_51450());
                if (options.displayLyrics) {
                    pos2 = config.lyricsPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)class_2561.method_43470((String)texts[0]), options.lyricsAlignment, pos2.x, pos2.y, context, client.field_1772, (int)config.lyricsColor.getNumber());
                }
                if (options.displaySubLyrics) {
                    pos2 = config.subLyricsPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)class_2561.method_43470((String)texts[1]), options.subLyricsAlignment, pos2.x, pos2.y, context, client.field_1772, (int)config.subLyricsColor.getNumber());
                }
                class_5250 text3 = class_2561.method_43470((String)texts[3]);
                int text3Width = client.field_1772.method_27525((class_5348)text3);
                if (options.displayMusicDetails) {
                    pos = config.musicDetailsPosSupplier.getPos(scaledWidth, scaledHeight);
                    String state = MusicPlayer.INSTANCE.isPlayingTemp ? (ConcertoClient.clientState == ConcertoClient.ClientState.MUSIC_AGENT ? " | " + class_2561.method_43471((String)"concerto.agent").getString() : (ConcertoClient.clientState == ConcertoClient.ClientState.MUSIC_ROOM ? " | " + class_2561.method_43471((String)"concerto.room").getString() : "")) : "";
                    class_5250 text2 = class_2561.method_43470((String)(texts[2] + state));
                    MUSIC_DETAIL_SCROLL.setMaxWidth(text3Width);
                    MUSIC_DETAIL_SCROLL.setWidth(client.field_1772.method_27525((class_5348)text2));
                    MUSIC_DETAIL_SCROLL.tick(options.scrollingTextSpeed);
                    int startX = TextUtil.getTextRenderX((class_2561)text3, options.musicDetailsAlignment, client.field_1772, pos.x);
                    int n = pos.y;
                    int n2 = pos.y;
                    Objects.requireNonNull(client.field_1772);
                    context.method_44379(startX, n, startX + text3Width, n2 + 9);
                    context.method_51439(client.field_1772, (class_2561)text2, startX + MUSIC_DETAIL_SCROLL.getDx(), pos.y, (int)config.musicDetailsColor.getNumber(), options.textShadow);
                    context.method_44380();
                }
                if (options.displayTimeProgress) {
                    pos = config.timeProgressPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)text3, options.timeProgressAlignment, pos.x, pos.y, context, client.field_1772, (int)config.timeProgressTextColor.getNumber());
                    int blankWidth = client.field_1772.method_1727("                              ");
                    int timeWidth = (text3Width - blankWidth) / 2;
                    if (MusicPlayerHandler.INSTANCE.currentMeta != null && MusicPlayerHandler.INSTANCE.currentMeta.getDuration() != null) {
                        int x = switch (options.timeProgressAlignment) {
                            case TextAlignment.LEFT -> pos.x + timeWidth + 9;
                            case TextAlignment.CENTER -> pos.x - blankWidth / 2 + 9;
                            default -> pos.x - blankWidth - timeWidth + 9;
                        };
                        context.method_25294(x, pos.y + 3, x + blankWidth - 20, pos.y + 5, (int)config.timeProgressBgColor.getNumber());
                        context.method_25294(x, pos.y + 3, (int)((float)x + (float)(blankWidth - 20) * MusicPlayerHandler.INSTANCE.progressPercentage), pos.y + 5, (int)config.timeProgressColor.getNumber());
                    }
                }
                if (options.displayCoverImg) {
                    pos = config.coverImgPosSupplier.getPos(scaledWidth, scaledHeight);
                    int size = config.options.coverImgSize;
                    MusicPlayerHandler.INSTANCE.headPicture.method_46421(pos.x);
                    MusicPlayerHandler.INSTANCE.headPicture.method_46419(pos.y);
                    MusicPlayerHandler.INSTANCE.headPicture.setSize(size, size);
                    if (options.coverImgRotate) {
                        float cx = (float)pos.x + (float)size / 2.0f;
                        float cy = (float)pos.y + (float)size / 2.0f;
                        float angleRad = delta * (float)Math.PI / 180.0f;
                        context.method_51448().method_46416(cx, cy, 0.0f);
                        context.method_51448().method_22907(new Quaternionf().rotateZ(angleRad));
                        context.method_51448().method_46416(-cx, -cy, 0.0f);
                    }
                    MusicPlayerHandler.INSTANCE.headPicture.method_25394(context, mouseX, mouseY, delta);
                }
            }
        }
    }

    public static class ScrollingText {
        public static int STOP_TICKS = 180;
        private int width = 0;
        private int maxWidth = 0;
        private float dx = 0.0f;
        private float stopTicks = 0.0f;
        private boolean stop = false;
        private boolean go_back = false;

        private void reset() {
            this.dx = 0.0f;
            this.go_back = false;
            this.stop = true;
            this.stopTicks = STOP_TICKS;
        }

        public void setWidth(int width) {
            if (width != this.width) {
                this.reset();
            }
            this.width = width;
        }

        public void setMaxWidth(int maxWidth) {
            if (maxWidth > this.maxWidth + 5 || maxWidth < this.maxWidth - 5) {
                this.reset();
            }
            this.maxWidth = maxWidth;
        }

        public void tick(float speed) {
            if (this.width <= this.maxWidth) {
                return;
            }
            float delta = speed * 40.0f / (float)class_310.method_1551().method_47599();
            if (this.stop) {
                this.stopTicks -= delta;
                if (this.stopTicks <= 0.0f) {
                    this.stop = false;
                    this.go_back = !this.go_back;
                }
            } else {
                float limit = this.go_back ? 0.0f : (float)(this.maxWidth - this.width);
                float f = this.dx = this.go_back ? Math.min(limit, this.dx + delta) : Math.max(limit, this.dx - delta);
                if (this.dx == limit) {
                    this.stop = true;
                    this.stopTicks = STOP_TICKS;
                }
            }
        }

        public int getDx() {
            return this.width <= this.maxWidth ? (this.maxWidth - this.width) / 2 : (int)this.dx;
        }
    }
}

