/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.dff.BaseChunk;
import org.jaudiotagger.audio.dff.DffChunkType;
import org.jaudiotagger.audio.generic.Utils;

public class FsChunk
extends BaseChunk {
    private int sampleRate;

    public FsChunk(ByteBuffer dataBuffer) {
        super(dataBuffer);
    }

    @Override
    public void readDataChunch(FileChannel fc) throws IOException {
        super.readDataChunch(fc);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, 4);
        this.sampleRate = Integer.reverseBytes(audioData.getInt());
        this.skipToChunkEnd(fc);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String toString() {
        return DffChunkType.FS.getCode();
    }
}

