/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dsf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.audio.dsf.DsfChunkType;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;

public class DsdChunk {
    private long chunkSizeLength;
    private long fileLength;
    private long metadataOffset;
    public static final int CHUNKSIZE_LENGTH = 8;
    public static final int FILESIZE_LENGTH = 8;
    public static final int METADATA_OFFSET_LENGTH = 8;
    public static final int FMT_CHUNK_MIN_DATA_SIZE_ = 40;
    public static final int DSD_HEADER_LENGTH = IffHeaderChunk.SIGNATURE_LENGTH + 8 + 8 + 8;

    public static DsdChunk readChunk(ByteBuffer dataBuffer) {
        String type = Utils.readFourBytesAsChars(dataBuffer);
        if (DsfChunkType.DSD.getCode().equals(type)) {
            return new DsdChunk(dataBuffer);
        }
        return null;
    }

    private DsdChunk(ByteBuffer dataBuffer) {
        this.chunkSizeLength = dataBuffer.getLong();
        this.fileLength = dataBuffer.getLong();
        this.metadataOffset = dataBuffer.getLong();
    }

    public String toString() {
        return "ChunkSize:" + this.chunkSizeLength + ":fileLength:" + this.fileLength + ":metadata:" + this.metadataOffset;
    }

    public long getChunkSizeLength() {
        return this.chunkSizeLength;
    }

    public void setChunkSizeLength(long chunkSizeLength) {
        this.chunkSizeLength = chunkSizeLength;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getMetadataOffset() {
        return this.metadataOffset;
    }

    public void setMetadataOffset(long metadataOffset) {
        this.metadataOffset = metadataOffset;
    }

    public ByteBuffer write() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(DSD_HEADER_LENGTH);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(DsfChunkType.DSD.getCode().getBytes(StandardCharsets.US_ASCII));
        buffer.putLong(this.chunkSizeLength);
        buffer.putLong(this.fileLength);
        buffer.putLong(this.metadataOffset);
        buffer.flip();
        return buffer;
    }
}

