/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AggregatedFrame;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v23FieldKey;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v23PreferredFrameOrderComparator;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.TyerTdatAggregatedFrame;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIME;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMCL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;

public class ID3v23Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_CRCDATA = "crcdata";
    protected static final String TYPE_EXPERIMENTAL = "experimental";
    protected static final String TYPE_EXTENDED = "extended";
    protected static final String TYPE_PADDINGSIZE = "paddingsize";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    protected static int TAG_EXT_HEADER_LENGTH = 10;
    protected static int TAG_EXT_HEADER_CRC_LENGTH = 4;
    protected static int FIELD_TAG_EXT_SIZE_LENGTH = 4;
    protected static int TAG_EXT_HEADER_DATA_LENGTH = TAG_EXT_HEADER_LENGTH - FIELD_TAG_EXT_SIZE_LENGTH;
    public static final int MASK_V23_UNSYNCHRONIZATION = 128;
    public static final int MASK_V23_EXTENDED_HEADER = 64;
    public static final int MASK_V23_EXPERIMENTAL = 32;
    public static final int MASK_V23_CRC_DATA_PRESENT = 128;
    public static final int MASK_V23_EMBEDDED_INFO_FLAG = 2;
    protected boolean crcDataFlag = false;
    protected boolean experimental = false;
    protected boolean extended = false;
    private int crc32;
    private int paddingSize = 0;
    protected boolean unsynchronization = false;
    protected boolean compression = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 3;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 3;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public ID3v23Tag() {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.config("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v23Tag) {
            ID3v23Tag copyObject = (ID3v23Tag)copyObj;
            this.crcDataFlag = copyObject.crcDataFlag;
            this.experimental = copyObject.experimental;
            this.extended = copyObject.extended;
            this.crc32 = copyObject.crc32;
            this.paddingSize = copyObject.paddingSize;
        }
    }

    @Override
    protected void combineFrames(AbstractID3v2Frame newFrame, List<TagField> existing) {
        AbstractTagFrame existingFrame = null;
        for (TagField field : existing) {
            AbstractID3v2Frame frame;
            if (!(field instanceof AbstractID3v2Frame) || !(frame = (AbstractID3v2Frame)field).getIdentifier().equals(newFrame.getIdentifier())) continue;
            existingFrame = frame;
        }
        if (newFrame.getIdentifier().equals("IPLS") && existingFrame != null) {
            PairedTextEncodedStringNullTerminated.ValuePairs oldVps = ((FrameBodyIPLS)existingFrame.getBody()).getPairing();
            PairedTextEncodedStringNullTerminated.ValuePairs newVps = ((FrameBodyIPLS)newFrame.getBody()).getPairing();
            for (Pair next : newVps.getMapping()) {
                oldVps.add(next);
            }
        } else {
            existing.add(newFrame);
        }
    }

    @Override
    public void addFrame(AbstractID3v2Frame frame) {
        try {
            if (frame instanceof ID3v23Frame) {
                this.copyFrameIntoMap(frame.getIdentifier(), frame);
            } else {
                List<AbstractID3v2Frame> frames = this.convertFrame(frame);
                for (AbstractID3v2Frame next : frames) {
                    this.copyFrameIntoMap(next.getIdentifier(), next);
                }
            }
        }
        catch (InvalidFrameException ife) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier());
        }
    }

    @Override
    protected List<AbstractID3v2Frame> convertFrame(AbstractID3v2Frame frame) throws InvalidFrameException {
        ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
        if (frame.getIdentifier().equals("TDRC") && frame.getBody() instanceof FrameBodyTDRC) {
            ID3v23Frame newFrame;
            FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
            tmpBody.findMatchingMaskAndExtractV3Values();
            if (!tmpBody.getYear().equals("")) {
                newFrame = new ID3v23Frame("TYER");
                ((FrameBodyTYER)newFrame.getBody()).setText(tmpBody.getYear());
                frames.add(newFrame);
            }
            if (!tmpBody.getDate().equals("")) {
                newFrame = new ID3v23Frame("TDAT");
                ((FrameBodyTDAT)newFrame.getBody()).setText(tmpBody.getDate());
                ((FrameBodyTDAT)newFrame.getBody()).setMonthOnly(tmpBody.isMonthOnly());
                frames.add(newFrame);
            }
            if (!tmpBody.getTime().equals("")) {
                newFrame = new ID3v23Frame("TIME");
                ((FrameBodyTIME)newFrame.getBody()).setText(tmpBody.getTime());
                ((FrameBodyTIME)newFrame.getBody()).setHoursOnly(tmpBody.isHoursOnly());
                frames.add(newFrame);
            }
        } else if (frame.getIdentifier().equals("TIPL") && frame.getBody() instanceof FrameBodyTIPL) {
            List<Pair> pairs = ((FrameBodyTIPL)frame.getBody()).getPairing().getMapping();
            ID3v23Frame ipls = new ID3v23Frame((ID3v24Frame)frame, "IPLS");
            FrameBodyIPLS iplsBody = new FrameBodyIPLS(frame.getBody().getTextEncoding(), pairs);
            ipls.setBody(iplsBody);
            frames.add(ipls);
        } else if (frame.getIdentifier().equals("TMCL") && frame.getBody() instanceof FrameBodyTMCL) {
            List<Pair> pairs = ((FrameBodyTMCL)frame.getBody()).getPairing().getMapping();
            ID3v23Frame ipls = new ID3v23Frame((ID3v24Frame)frame, "IPLS");
            FrameBodyIPLS iplsBody = new FrameBodyIPLS(frame.getBody().getTextEncoding(), pairs);
            ipls.setBody(iplsBody);
            frames.add(ipls);
        } else {
            frames.add(new ID3v23Frame(frame));
        }
        return frames;
    }

    public ID3v23Tag(ID3v23Tag copyObject) {
        super(copyObject);
        logger.config("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v23Tag(AbstractTag mp3tag) {
        logger.config("Creating tag from a tag of a different version");
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v23Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag convertedTag = mp3tag instanceof ID3v24Tag ? (ID3v24Tag)mp3tag : new ID3v24Tag(mp3tag);
            this.setLoggingFilename(convertedTag.getLoggingFilename());
            this.copyPrimitives(convertedTag);
            this.copyFrames(convertedTag);
            logger.config("Created tag from a tag of a different version");
        }
    }

    public ID3v23Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v23Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2.30";
    }

    @Override
    public int getSize() {
        int size = 10;
        if (this.extended) {
            size += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                size += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        return size += super.getSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v23Tag)) {
            return false;
        }
        ID3v23Tag object = (ID3v23Tag)obj;
        if (this.crc32 != object.crc32) {
            return false;
        }
        if (this.crcDataFlag != object.crcDataFlag) {
            return false;
        }
        if (this.experimental != object.experimental) {
            return false;
        }
        if (this.extended != object.extended) {
            return false;
        }
        return this.paddingSize == object.paddingSize && super.equals(obj);
    }

    private void readHeaderFlags(ByteBuffer buffer) throws TagException {
        byte flags = buffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        this.extended = (flags & 0x40) != 0;
        boolean bl = this.experimental = (flags & 0x20) != 0;
        if ((flags & 0x10) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 16));
        }
        if ((flags & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((flags & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((flags & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((flags & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 1));
        }
        if (this.isUnsynchronization()) {
            logger.config(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.extended) {
            logger.config(ErrorMessage.ID3_TAG_EXTENDED.getMsg(this.getLoggingFilename()));
        }
        if (this.experimental) {
            logger.config(ErrorMessage.ID3_TAG_EXPERIMENTAL.getMsg(this.getLoggingFilename()));
        }
    }

    private void readExtendedHeader(ByteBuffer buffer, int size) {
        int extendedHeaderSize = buffer.getInt();
        if (extendedHeaderSize == TAG_EXT_HEADER_DATA_LENGTH) {
            byte extFlag = buffer.get();
            boolean bl = this.crcDataFlag = (extFlag & 0x80) != 0;
            if (this.crcDataFlag) {
                logger.warning(ErrorMessage.ID3_TAG_CRC_FLAG_SET_INCORRECTLY.getMsg(this.getLoggingFilename()));
            }
            buffer.get();
            this.paddingSize = buffer.getInt();
            if (this.paddingSize > 0) {
                logger.config(ErrorMessage.ID3_TAG_PADDING_SIZE.getMsg(this.getLoggingFilename(), this.paddingSize));
            }
            size -= this.paddingSize + TAG_EXT_HEADER_LENGTH;
        } else if (extendedHeaderSize == TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH) {
            logger.config(ErrorMessage.ID3_TAG_CRC.getMsg(this.getLoggingFilename()));
            byte extFlag = buffer.get();
            boolean bl = this.crcDataFlag = (extFlag & 0x80) != 0;
            if (!this.crcDataFlag) {
                logger.warning(ErrorMessage.ID3_TAG_CRC_FLAG_SET_INCORRECTLY.getMsg(this.getLoggingFilename()));
            }
            buffer.get();
            this.paddingSize = buffer.getInt();
            if (this.paddingSize > 0) {
                logger.config(ErrorMessage.ID3_TAG_PADDING_SIZE.getMsg(this.getLoggingFilename(), this.paddingSize));
            }
            size -= this.paddingSize + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH;
            this.crc32 = buffer.getInt();
            logger.config(ErrorMessage.ID3_TAG_CRC_SIZE.getMsg(this.getLoggingFilename(), this.crc32));
        } else {
            logger.warning(ErrorMessage.ID3_EXTENDED_HEADER_SIZE_INVALID.getMsg(this.getLoggingFilename(), extendedHeaderSize));
            buffer.position(buffer.position() - FIELD_TAG_EXT_SIZE_LENGTH);
        }
    }

    @Override
    public void read(ByteBuffer buffer) throws TagException {
        if (!this.seek(buffer)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        logger.config(this.getLoggingFilename() + ":Reading ID3v23 tag");
        this.readHeaderFlags(buffer);
        int size = ID3SyncSafeInteger.bufferToValue(buffer);
        logger.config(ErrorMessage.ID_TAG_SIZE.getMsg(this.getLoggingFilename(), size));
        if (this.extended) {
            this.readExtendedHeader(buffer, size);
        }
        ByteBuffer bufferWithoutHeader = buffer.slice();
        if (this.isUnsynchronization()) {
            bufferWithoutHeader = ID3Unsynchronization.synchronize(bufferWithoutHeader);
        }
        this.readFrames(bufferWithoutHeader, size);
        logger.config(this.getLoggingFilename() + ":Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":Start of frame body at:" + byteBuffer.position() + ",frames data size is:" + size);
        while (byteBuffer.position() < size) {
            try {
                int posBeforeRead = byteBuffer.position();
                logger.config(this.getLoggingFilename() + ":Looking for next frame at:" + posBeforeRead);
                ID3v23Frame next = new ID3v23Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                logger.config(this.getLoggingFilename() + ":Found " + id + " at frame at:" + posBeforeRead);
                this.loadFrameIntoMap(id, next);
            }
            catch (PaddingException ex) {
                logger.info(this.getLoggingFilename() + ":Found padding starting at:" + byteBuffer.position());
                break;
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 10;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame:" + ife.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException idete) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + idete.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.extended = false;
        this.experimental = false;
        this.crcDataFlag = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10 + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flagsByte = 0;
        if (this.isUnsynchronization()) {
            flagsByte = (byte)(flagsByte | 0x80);
        }
        if (this.extended) {
            flagsByte = (byte)(flagsByte | 0x40);
        }
        if (this.experimental) {
            flagsByte = (byte)(flagsByte | 0x20);
        }
        headerBuffer.put(flagsByte);
        int additionalHeaderSize = 0;
        if (this.extended) {
            additionalHeaderSize += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                additionalHeaderSize += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size + additionalHeaderSize));
        if (this.extended) {
            byte extFlagsByte1 = 0;
            byte extFlagsByte2 = 0;
            if (this.crcDataFlag) {
                headerBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
                extFlagsByte1 = (byte)(extFlagsByte1 | 0x80);
                headerBuffer.put(extFlagsByte1);
                headerBuffer.put(extFlagsByte2);
                headerBuffer.putInt(this.paddingSize);
                headerBuffer.putInt(this.crc32);
            } else {
                headerBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH);
                headerBuffer.put(extFlagsByte1);
                headerBuffer.put(extFlagsByte2);
                headerBuffer.putInt(padding);
            }
        }
        headerBuffer.flip();
        return headerBuffer;
    }

    @Override
    public long write(File file, long audioStartLocation) throws IOException {
        this.setLoggingFilename(file.getName());
        logger.config("Writing tag to file:" + this.getLoggingFilename());
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        logger.config(this.getLoggingFilename() + ":Current audiostart:" + audioStartLocation);
        logger.config(this.getLoggingFilename() + ":Size including padding:" + sizeIncPadding);
        logger.config(this.getLoggingFilename() + ":Padding:" + padding);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        this.writeBufferToFile(file, headerBuffer, bodyByteBuffer, padding, sizeIncPadding, audioStartLocation);
        return sizeIncPadding;
    }

    @Override
    public void write(WritableByteChannel channel, int currentTagSize) throws IOException {
        logger.config(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int padding = 0;
        if (currentTagSize > 0) {
            int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, currentTagSize);
            padding = sizeIncPadding - (bodyByteBuffer.length + 10);
            logger.config(this.getLoggingFilename() + ":Padding:" + padding);
        }
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
        this.writePadding(channel, padding);
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.isUnsynchronization());
        MP3File.getStructureFormatter().addElement(TYPE_EXTENDED, this.extended);
        MP3File.getStructureFormatter().addElement(TYPE_EXPERIMENTAL, this.experimental);
        MP3File.getStructureFormatter().addElement(TYPE_CRCDATA, this.crc32);
        MP3File.getStructureFormatter().addElement(TYPE_PADDINGSIZE, this.paddingSize);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    @Override
    public ID3v23Frame createFrame(String id) {
        return new ID3v23Frame(id);
    }

    public TagField createField(ID3v23FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(null, id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    public String getFirst(ID3v23FieldKey id3v23FieldKey) throws KeyNotFoundException {
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        FieldKey genericKey = ID3v23Frames.getInstanceOf().getGenericKeyFromId3(id3v23FieldKey);
        if (genericKey != null) {
            return super.getFirst(genericKey);
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(null, id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId());
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v23FieldKey id3v23FieldKey) throws KeyNotFoundException {
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(null, id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String id) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(null, id, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey genericKey) {
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v23FieldKey id3v23FieldKey = ID3v23Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException(genericKey.name());
        }
        return new AbstractID3v2Tag.FrameAndSubId(genericKey, id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v23Frames.getInstanceOf();
    }

    @Override
    public Comparator<String> getPreferredFrameOrderComparator() {
        return ID3v23PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            FrameBodyAPIC coverArt = (FrameBodyAPIC)((AbstractID3v2Frame)next).getBody();
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setMimeType(coverArt.getMimeType());
            artwork.setPictureType(coverArt.getPictureType());
            artwork.setDescription(coverArt.getDescription());
            if (coverArt.isImageUrl()) {
                artwork.setLinked(true);
                artwork.setImageUrl(coverArt.getImageUrl());
            } else {
                artwork.setBinaryData(coverArt.getImageData());
            }
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v23Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC body = (FrameBodyAPIC)frame.getBody();
        if (!artwork.isLinked()) {
            body.setObjectValue("PictureData", artwork.getBinaryData());
            body.setObjectValue("PictureType", artwork.getPictureType());
            body.setObjectValue("MIMEType", artwork.getMimeType());
            body.setObjectValue("Description", artwork.getDescription());
            return frame;
        }
        try {
            body.setObjectValue("PictureData", artwork.getImageUrl().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException uoe) {
            throw new RuntimeException(uoe.getMessage());
        }
        body.setObjectValue("PictureType", artwork.getPictureType());
        body.setObjectValue("MIMEType", "-->");
        body.setObjectValue("Description", artwork.getDescription());
        return frame;
    }

    public TagField createArtworkField(byte[] data, String mimeType) {
        ID3v23Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC body = (FrameBodyAPIC)frame.getBody();
        body.setObjectValue("PictureData", data);
        body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        body.setObjectValue("MIMEType", mimeType);
        body.setObjectValue("Description", "");
        return frame;
    }

    public int getPaddingSize() {
        return this.paddingSize;
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (values == null || values[0] == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        String value = values[0];
        if (genericKey == FieldKey.GENRE) {
            if (value == null) {
                throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
            }
            AbstractID3v2Tag.FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
            ID3v23Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTCON framebody = (FrameBodyTCON)frame.getBody();
            framebody.setV23Format();
            if (TagOptionSingleton.getInstance().isWriteMp3GenresAsText()) {
                framebody.setText(value);
            } else {
                framebody.setText(FrameBodyTCON.convertGenericToID3v23Genre(value));
            }
            return frame;
        }
        if (genericKey == FieldKey.YEAR) {
            if (value.length() == 1) {
                ID3v23Frame tyer = this.createFrame("TYER");
                ((AbstractFrameBodyTextInfo)tyer.getBody()).setText("000" + value);
                return tyer;
            }
            if (value.length() == 2) {
                ID3v23Frame tyer = this.createFrame("TYER");
                ((AbstractFrameBodyTextInfo)tyer.getBody()).setText("00" + value);
                return tyer;
            }
            if (value.length() == 3) {
                ID3v23Frame tyer = this.createFrame("TYER");
                ((AbstractFrameBodyTextInfo)tyer.getBody()).setText("0" + value);
                return tyer;
            }
            if (value.length() == 4) {
                ID3v23Frame tyer = this.createFrame("TYER");
                ((AbstractFrameBodyTextInfo)tyer.getBody()).setText(value);
                return tyer;
            }
            if (value.length() > 4) {
                ID3v23Frame tyer = this.createFrame("TYER");
                ((AbstractFrameBodyTextInfo)tyer.getBody()).setText(value.substring(0, 4));
                if (value.length() >= 10) {
                    String month = value.substring(5, 7);
                    String day = value.substring(8, 10);
                    ID3v23Frame tdat = this.createFrame("TDAT");
                    ((AbstractFrameBodyTextInfo)tdat.getBody()).setText(day + month);
                    TyerTdatAggregatedFrame ag = new TyerTdatAggregatedFrame();
                    ag.addFrame(tyer);
                    ag.addFrame(tdat);
                    return ag;
                }
                if (value.length() >= 7) {
                    String month = value.substring(5, 7);
                    String day = "01";
                    ID3v23Frame tdat = this.createFrame("TDAT");
                    ((AbstractFrameBodyTextInfo)tdat.getBody()).setText(day + month);
                    TyerTdatAggregatedFrame ag = new TyerTdatAggregatedFrame();
                    ag.addFrame(tyer);
                    ag.addFrame(tdat);
                    return ag;
                }
                return tyer;
            }
            return null;
        }
        return super.createField(genericKey, values);
    }

    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.YEAR) {
            AggregatedFrame af;
            List<TagField> fields = this.getFrame("TYERTDAT");
            AggregatedFrame aggregatedFrame = af = fields != null && !fields.isEmpty() ? (AggregatedFrame)fields.get(0) : null;
            if (af != null) {
                return af.getContent();
            }
            return super.getValue(genericKey, index);
        }
        if (genericKey == FieldKey.GENRE) {
            List<TagField> fields = this.getFields(genericKey);
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
                return FrameBodyTCON.convertID3v23GenreToGeneric(body.getValues().get(index));
            }
            return "";
        }
        return super.getValue(genericKey, index);
    }

    @Override
    protected void loadFrameIntoMap(String frameId, AbstractID3v2Frame next) {
        if (next.getBody() instanceof FrameBodyTCON) {
            ((FrameBodyTCON)next.getBody()).setV23Format();
        }
        super.loadFrameIntoMap(frameId, next);
    }

    @Override
    protected void loadFrameIntoSpecifiedMap(Map<String, List<TagField>> map, String frameId, AbstractID3v2Frame frame) {
        if (!frameId.equals("TYER") && !frameId.equals("TDAT")) {
            super.loadFrameIntoSpecifiedMap(map, frameId, frame);
            return;
        }
        if (frameId.equals("TDAT") && frame.getContent().length() == 0) {
            logger.warning(this.getLoggingFilename() + ":TDAT is empty so just ignoring");
            return;
        }
        if (map.containsKey(frameId) || map.containsKey("TYERTDAT")) {
            if (this.duplicateFrameId.length() > 0) {
                this.duplicateFrameId = this.duplicateFrameId + ";";
            }
            this.duplicateFrameId = this.duplicateFrameId + frameId;
            this.duplicateBytes += frame.getSize();
        } else if (frameId.equals("TYER")) {
            if (map.containsKey("TDAT")) {
                TyerTdatAggregatedFrame ag = new TyerTdatAggregatedFrame();
                ag.addFrame(frame);
                for (TagField field : map.get("TDAT")) {
                    if (!(field instanceof AbstractID3v2Frame)) continue;
                    ag.addFrame((AbstractID3v2Frame)field);
                }
                map.remove("TDAT");
                this.putAsList(map, "TYERTDAT", ag);
            } else {
                this.putAsList(map, "TYER", frame);
            }
        } else if (frameId.equals("TDAT")) {
            if (map.containsKey("TYER")) {
                TyerTdatAggregatedFrame ag = new TyerTdatAggregatedFrame();
                for (TagField field : map.get("TYER")) {
                    if (!(field instanceof AbstractID3v2Frame)) continue;
                    ag.addFrame((AbstractID3v2Frame)field);
                }
                ag.addFrame(frame);
                map.remove("TYER");
                this.putAsList(map, "TYERTDAT", ag);
            } else {
                this.putAsList(map, "TDAT", frame);
            }
        }
    }

    private void putAsList(Map<String, List<TagField>> map, String id, TagField tf) {
        ArrayList<TagField> fields = new ArrayList<TagField>();
        fields.add(tf);
        map.put(id, fields);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == FieldKey.GENRE) {
            List<TagField> fields = this.getFields(genericKey);
            ArrayList<String> convertedGenres = new ArrayList<String>();
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
                for (String next : body.getValues()) {
                    convertedGenres.add(FrameBodyTCON.convertID3v23GenreToGeneric(next));
                }
            }
            return convertedGenres;
        }
        if (genericKey == FieldKey.YEAR) {
            List<TagField> fields = this.getFields(genericKey);
            ArrayList<String> results = new ArrayList<String>();
            if (fields != null && fields.size() > 0) {
                for (TagField next : fields) {
                    if (!(next instanceof TagTextField)) continue;
                    results.add(((TagTextField)next).getContent());
                }
            }
            return results;
        }
        return super.getAll(genericKey);
    }

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (genericKey == FieldKey.YEAR) {
            AggregatedFrame af;
            List<TagField> fields = this.getFrame("TYERTDAT");
            AggregatedFrame aggregatedFrame = af = fields != null && !fields.isEmpty() ? (AggregatedFrame)fields.get(0) : null;
            if (af != null) {
                ArrayList<TagField> list = new ArrayList<TagField>();
                list.add(af);
                return list;
            }
            return super.getFields(genericKey);
        }
        return super.getFields(genericKey);
    }

    @Override
    public void removeFrame(String identifier) {
        logger.config("Removing frame with identifier:" + identifier);
        this.frameMap.remove(identifier);
        if (identifier.equals("TYER")) {
            this.frameMap.remove("TYER");
            this.frameMap.remove("TYERTDAT");
        } else {
            this.frameMap.remove(identifier);
        }
    }
}

