/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

public class Add {
    private static final short[] bitoff = new short[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static short saturate(int x) {
        return (short)(x < Short.MIN_VALUE ? Short.MIN_VALUE : (x > Short.MAX_VALUE ? Short.MAX_VALUE : x));
    }

    public static short saturate(long x) {
        return (short)(x < -32768L ? -32768L : (x > 32767L ? 32767L : x));
    }

    public static short SASR(int x, int by) {
        return (short)(x >> by);
    }

    public static short GSM_ADD(short a, short b) {
        int sum = a + b;
        return Add.saturate(sum);
    }

    public static short GSM_SUB(short a, short b) {
        int diff = a - b;
        return Add.saturate(diff);
    }

    public static short GSM_MULT(short a, short b) {
        if (a == Short.MIN_VALUE && b == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return Add.SASR(a * b, 15);
    }

    public static short GSM_MULT_R(short a, short b) {
        if (a == Short.MIN_VALUE && b == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int prod = a * b + 16384;
        return (short)((prod >>= 15) & 0xFFFF);
    }

    public static short GSM_ABS(short a) {
        int b = a < 0 ? (a == Short.MIN_VALUE ? Short.MAX_VALUE : -a) : a;
        return (short)b;
    }

    public static int GSM_L_MULT(short a, short b) throws IllegalArgumentException {
        if (a != Short.MIN_VALUE || b != Short.MIN_VALUE) {
            throw new IllegalArgumentException("One of the aruments must equal -32768");
        }
        return a * b << 1;
    }

    public static int GSM_L_ADD(int a, int b) {
        if (a <= 0) {
            if (b >= 0) {
                return a + b;
            }
            long A = (long)(-(a + 1)) + (long)(-(b + 1));
            return A >= Integer.MAX_VALUE ? Integer.MIN_VALUE : -((int)A) - 2;
        }
        if (b <= 0) {
            return a + b;
        }
        long A = (long)a + (long)b;
        return (int)(A > Integer.MAX_VALUE ? Integer.MAX_VALUE : A);
    }

    public static short gsm_norm(int a) throws IllegalArgumentException {
        if (a == 0) {
            throw new IllegalArgumentException("gsm_norm: a cannot = 0.");
        }
        if (a < 0) {
            if (a <= -1073741824) {
                return 0;
            }
            a ^= 0xFFFFFFFF;
        }
        return (short)((a & 0xFFFF0000) != 0 ? ((a & 0xFF000000) != 0 ? -1 + bitoff[0xFF & a >> 24] : 7 + bitoff[0xFF & a >> 16]) : ((a & 0xFF00) != 0 ? 15 + bitoff[0xFF & a >> 8] : 23 + bitoff[0xFF & a]));
    }

    public static short gsm_asl(short a, int n) {
        if (n >= 16) {
            return 0;
        }
        if (n <= -16) {
            if (a < 0) {
                return -1;
            }
            return 0;
        }
        if (n < 0) {
            return Add.gsm_asr(a, -n);
        }
        return (short)(a << n);
    }

    public static short gsm_asr(short a, int n) {
        if (n >= 16) {
            if (a < 0) {
                return -1;
            }
            return 0;
        }
        if (n <= -16) {
            return 0;
        }
        if (n < 0) {
            return (short)(a << -n);
        }
        return (short)(a >> n);
    }

    public static short gsm_div(short num, short denum) throws IllegalArgumentException {
        int L_num = num;
        short L_denum = denum;
        short div = 0;
        int k = 15;
        if (num < 0 || denum < num) {
            throw new IllegalArgumentException("gsm_div: num >= 0 && denum >= num");
        }
        if (num == 0) {
            return 0;
        }
        while (k != 0) {
            --k;
            div = (short)(div << 1);
            if ((L_num <<= 1) < L_denum) continue;
            L_num -= L_denum;
            div = (short)(div + 1);
        }
        return div;
    }
}

