/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.http.kugou;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.music.list.KuGouMusicPlaylist;

public class KuGouMusicUser {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private long userId;
    private String userName;
    private String avatarUrl;
    private boolean loggedIn = false;
    private boolean isLite = false;
    private VIPLevel vipLevel = VIPLevel.NONE;
    private LocalDateTime vipExpireTime;
    private final KuGouMusicApiClient apiClient;

    public KuGouMusicUser(KuGouMusicApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public boolean isLite() {
        return this.isLite;
    }

    public LocalDateTime getVipExpireTime() {
        return this.vipExpireTime;
    }

    public VIPLevel getVipLevel() {
        return this.vipLevel;
    }

    public boolean updateLoginStatus() {
        Optional<JsonObject> optional = this.apiClient.getUserDetail();
        try {
            JsonObject data = optional.map(json -> json.getAsJsonObject("data")).orElseThrow();
            Optional<JsonObject> dataOpt = Optional.of(data);
            this.userName = dataOpt.map(json -> json.get("nickname")).map(JsonElement::getAsString).orElseThrow();
            this.avatarUrl = dataOpt.map(json -> json.get("pic")).map(JsonElement::getAsString).orElseThrow();
            this.loggedIn = true;
            this.isLite = ClientConfig.INSTANCE.options.kuGouMusicLite;
            return true;
        }
        catch (Exception e) {
            this.loggedIn = false;
            return false;
        }
    }

    public boolean updateVIPStatus() {
        Optional<JsonArray> busiVipArray;
        LocalDateTime expireTime;
        String suVIPEndTime;
        LocalDateTime expireTime2;
        if (!this.loggedIn) {
            return false;
        }
        Optional<JsonObject> optional = KuGouMusicApiClient.INSTANCE.getVIPStatus();
        if (optional.map(json -> json.get("status")).isEmpty()) {
            this.vipLevel = VIPLevel.NONE;
            this.vipExpireTime = null;
            return false;
        }
        Optional<JsonObject> dataOpt = optional.map(json -> json.getAsJsonObject("data"));
        LocalDateTime maxExpireTime = LocalDateTime.now();
        VIPLevel maxExpireLevel = VIPLevel.NONE;
        String vipEndTime = dataOpt.map(json -> json.get("vip_end_time")).map(JsonElement::getAsString).orElse("");
        if (!vipEndTime.isEmpty() && (expireTime2 = this.parseTime(vipEndTime)).isAfter(maxExpireTime)) {
            maxExpireLevel = VIPLevel.VIP;
            maxExpireTime = expireTime2;
        }
        if (!(suVIPEndTime = dataOpt.map(json -> json.get("su_vip_end_time")).map(JsonElement::getAsString).orElse("")).isEmpty() && (expireTime = this.parseTime(suVIPEndTime)).isAfter(maxExpireTime)) {
            maxExpireLevel = VIPLevel.S_VIP;
            maxExpireTime = expireTime;
        }
        if (this.isLite() && (busiVipArray = dataOpt.map(json -> json.getAsJsonArray("busi_vip"))).isPresent()) {
            for (JsonElement element : busiVipArray.get()) {
                try {
                    Optional<JsonObject> objectOpt = Optional.ofNullable(element.getAsJsonObject());
                    String productType = objectOpt.map(obj -> obj.get("product_type")).map(JsonElement::getAsString).orElseThrow();
                    String expireTime3 = objectOpt.map(obj -> obj.get("vip_end_time")).map(JsonElement::getAsString).orElseThrow();
                    LocalDateTime time = this.parseTime(expireTime3);
                    if (!time.isAfter(maxExpireTime)) continue;
                    if (productType.equals("svip")) {
                        maxExpireLevel = VIPLevel.BUSI_S_VIP;
                    } else {
                        if (!productType.equals("tvip")) continue;
                        maxExpireLevel = VIPLevel.BUSI_T_VIP;
                    }
                    maxExpireTime = time;
                }
                catch (Exception exception) {}
            }
        }
        this.vipLevel = maxExpireLevel;
        this.vipExpireTime = maxExpireLevel != VIPLevel.NONE ? maxExpireTime : null;
        return true;
    }

    private LocalDateTime parseTime(String time) {
        return LocalDateTime.from(FORMATTER.parse(time));
    }

    public void logout() {
        this.apiClient.clearCookie();
        this.loggedIn = false;
    }

    public List<KuGouMusicPlaylist> getUserPlaylists(int page) {
        if (!this.loggedIn) {
            return new ArrayList<KuGouMusicPlaylist>();
        }
        Optional<JsonObject> optional = this.apiClient.getUserPlaylists(page);
        return optional.map(json -> json.getAsJsonObject("data")).map(data -> data.getAsJsonArray("info")).map(info -> StreamSupport.stream(info.spliterator(), false).map(element -> new KuGouMusicPlaylist(element.getAsJsonObject(), false, true)).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public boolean isVersionSame() {
        return this.isLite == ClientConfig.INSTANCE.options.kuGouMusicLite;
    }

    public static enum VIPLevel {
        NONE,
        VIP,
        S_VIP,
        BUSI_S_VIP,
        BUSI_T_VIP;

    }
}

