/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.http.qq;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.gregtao.concerto.util.HashUtil;

public class QQMusicApiEncrypt {

    public static class Sign {
        private static void test(List<Integer> resNum, int a, int b, int c) {
            int r25 = a >> 2;
            if (b != -1 && c != -1) {
                int r26 = a & 3;
                int r26_2 = r26 << 4;
                int r26_3 = b >> 4;
                int r26_4 = r26_2 | r26_3;
                int r27 = b & 0xF;
                int r27_2 = r27 << 2;
                int r27_3 = r27_2 | c >> 6;
                int r28 = c & 0x3F;
                resNum.add(r25);
                resNum.add(r26_4);
                resNum.add(r27_3);
                resNum.add(r28);
            } else {
                int r10 = a >> 2;
                int r11 = a & 3;
                int r11_2 = r11 << 4;
                resNum.add(r10);
                resNum.add(r11_2);
            }
        }

        private static String middle(List<Integer> ls) {
            ArrayList<Integer> resNum = new ArrayList<Integer>();
            ArrayList res = new ArrayList();
            for (int i = 0; i < ls.size(); i += 3) {
                if (ls.get(i) != null && i + 1 < ls.size() && ls.get(i + 1) != null && i + 2 < ls.size() && ls.get(i + 2) != null) {
                    Sign.test(resNum, ls.get(i), ls.get(i + 1), ls.get(i + 2));
                    continue;
                }
                Sign.test(resNum, ls.get(i), -1, -1);
            }
            char[] zd = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
            resNum.forEach(item -> res.add(String.valueOf(zd[item])));
            return String.join((CharSequence)"", res);
        }

        private static String head(String md5Str) {
            ArrayList res = new ArrayList();
            char[] chars = md5Str.toCharArray();
            List.of(Integer.valueOf(21), Integer.valueOf(4), Integer.valueOf(9), Integer.valueOf(26), Integer.valueOf(16), Integer.valueOf(20), Integer.valueOf(27), Integer.valueOf(30)).forEach(integer -> res.add(String.valueOf(chars[integer])));
            return String.join((CharSequence)"", res);
        }

        private static String tail(String md5Str) {
            ArrayList res = new ArrayList();
            char[] chars = md5Str.toCharArray();
            List.of(Integer.valueOf(18), Integer.valueOf(11), Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(6), Integer.valueOf(25)).forEach(integer -> res.add(String.valueOf(chars[integer])));
            return String.join((CharSequence)"", res);
        }

        private static List<Integer> getLs(String md5Str) {
            HashMap<Character, Integer> zd = new HashMap<Character, Integer>(Map.of(Character.valueOf('0'), 0, Character.valueOf('1'), 1, Character.valueOf('2'), 2, Character.valueOf('3'), 3, Character.valueOf('4'), 4, Character.valueOf('5'), 5, Character.valueOf('6'), 6, Character.valueOf('7'), 7, Character.valueOf('8'), 8, Character.valueOf('9'), 9));
            zd.putAll(Map.of(Character.valueOf('A'), 10, Character.valueOf('B'), 11, Character.valueOf('C'), 12, Character.valueOf('D'), 13, Character.valueOf('E'), 14, Character.valueOf('F'), 15));
            List<Integer> ol = List.of(212, 45, 80, 68, 195, 163, 163, 203, 157, 220, 254, 91, 204, 79, 104, 6);
            ArrayList<Integer> res = new ArrayList<Integer>();
            int j = 0;
            char[] chars = md5Str.toCharArray();
            for (int i = 0; i < md5Str.length(); i += 2) {
                int one = (Integer)zd.get(Character.valueOf(chars[i]));
                int two = (Integer)zd.get(Character.valueOf(chars[i + 1]));
                int r = one * 16 ^ two;
                res.add(r ^ ol.get(j));
                ++j;
            }
            return res;
        }

        public static String getSign(String params) {
            String md5Str = HashUtil.md5(params).toUpperCase();
            String h = Sign.head(md5Str);
            String e = Sign.tail(md5Str);
            List<Integer> ls = Sign.getLs(md5Str);
            String m = Sign.middle(ls);
            String res = ("zzb" + h + m + e).toLowerCase();
            res = res.replaceAll("[/+]", "");
            return res;
        }
    }

    public static class ZzcSign {
        private static final int[] PART_1_INDEXES = new int[]{23, 14, 6, 36, 16, 40, 7, 19};
        private static final int[] PART_2_INDEXES = new int[]{16, 1, 32, 12, 19, 27, 8, 5};
        private static final int[] SCRAMBLE_VALUES = new int[]{89, 39, 179, 150, 218, 82, 58, 252, 177, 52, 186, 123, 120, 64, 242, 133, 143, 161, 121, 179};

        public static String getSign(String payload) {
            String hash = HashUtil.sha1(payload);
            StringBuilder part1 = new StringBuilder();
            for (int index : PART_1_INDEXES) {
                if (index >= hash.length()) continue;
                part1.append(hash.charAt(index));
            }
            StringBuilder part2 = new StringBuilder();
            for (int index : PART_2_INDEXES) {
                if (index >= hash.length()) continue;
                part2.append(hash.charAt(index));
            }
            StringBuilder part3 = new StringBuilder();
            for (int i = 0; i < SCRAMBLE_VALUES.length; ++i) {
                int scramble = SCRAMBLE_VALUES[i];
                int value = Integer.parseInt(hash.substring(i * 2, i * 2 + 2), 16);
                part3.append((char)(scramble ^ value));
            }
            String b64Part = Base64.getEncoder().encodeToString(part3.toString().getBytes(StandardCharsets.UTF_8));
            b64Part = b64Part.replaceAll("[/+=]", "");
            return "zzc" + (String.valueOf(part1) + b64Part + String.valueOf(part2)).toLowerCase();
        }
    }
}

