/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.mixin;

import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.network.ClientMusicNetworkHandler;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.JsonUtil;

@Mixin(value={class_338.class})
public class ChatHudMixin {
    @Unique
    private static final Pattern PATTERN = Pattern.compile("Concerto:Share:([a-zA-Z0-9+/=]+)");

    @Unique
    private static void handleMessage(class_2561 text) {
        if (ConcertoClient.isServerAvailable()) {
            return;
        }
        Matcher matcher = PATTERN.matcher(text.getString());
        if (!matcher.find()) {
            return;
        }
        String code = new String(Base64.getDecoder().decode(matcher.group(1)));
        Music music = MusicJsonParsers.from(JsonUtil.from(code), false);
        if (music == null) {
            return;
        }
        music.getMeta();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        String[] authors = music.getMeta().getSource().split(",\\s");
        String sender = authors[authors.length - 1];
        if (client.field_1724.method_5476() == null || client.field_1724.method_5476().getString().equalsIgnoreCase(sender)) {
            try {
                ClientMusicNetworkHandler.addToWaitList(client, new MusicDataPacket(music, sender, true), (class_1657)client.field_1724);
            }
            catch (Exception e) {
                ConcertoClient.LOGGER.warn("Received an unsafe music data packet");
            }
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;IIZ)V"}, at={@At(value="HEAD")})
    public void addMessageInject2(class_2561 message, int messageId, int timestamp, boolean refresh, CallbackInfo ci) {
        ConcertoRunner.run(() -> ChatHudMixin.handleMessage(message));
    }
}

