/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music.lyrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.music.MusicTimestamp;
import top.gregtao.concerto.util.MathUtil;
import top.gregtao.concerto.util.Pair;

public abstract class Lyrics {
    private final ArrayList<Pair<MusicTimestamp, String>> lyricBody = new ArrayList();
    private int index = 0;

    public class_2561 getCurrent(int delta) {
        if (this.index + delta < 0 || this.index + delta >= this.lyricBody.size()) {
            throw new UnsupportedOperationException("Out of bound");
        }
        return new class_2585(this.lyricBody.get(this.index + delta).getSecond());
    }

    public class_2561 getCurrent() {
        return this.getCurrent(0);
    }

    public class_2561 nextLine() {
        ++this.index;
        return this.getCurrent();
    }

    public class_2561 stayOrNext(long timestamp) {
        if (this.index < this.lyricBody.size() - 1 && timestamp >= this.lyricBody.get(this.index + 1).getFirst().asMilliseconds()) {
            return this.nextLine();
        }
        return this.getCurrent();
    }

    public void addLine(MusicTimestamp timestamp, String line) {
        Collections.addAll(this.lyricBody, new Pair<MusicTimestamp, String>(timestamp, line));
    }

    public abstract void parse(String var1);

    public abstract String toString();

    public Lyrics load(String raw) {
        try {
            this.parse(raw);
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.error("Error parsing lyric", (Throwable)e);
        }
        this.sortLines();
        return this;
    }

    public void sortLines() {
        this.lyricBody.sort(Comparator.comparing(Pair::getFirst));
    }

    public class_2561 startFrom(long timestamp) {
        this.index = MathUtil.lowerBound(this.lyricBody, Pair.of(MusicTimestamp.ofMilliseconds(timestamp), ""), (o1, o2) -> ((MusicTimestamp)o2.getFirst()).compareTo((MusicTimestamp)o1.getFirst()));
        return this.getCurrent();
    }

    public ArrayList<Pair<MusicTimestamp, String>> getLyricBody() {
        return this.lyricBody;
    }

    public boolean isEmpty() {
        return this.getLyricBody().isEmpty();
    }
}

