/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player.streamplayer.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.PropertiesContainer;
import top.gregtao.concerto.player.streamplayer.enums.Status;
import top.gregtao.concerto.player.streamplayer.stream.DataSource;
import top.gregtao.concerto.player.streamplayer.stream.FileDataSource;
import top.gregtao.concerto.player.streamplayer.stream.FlacDecoderStream;
import top.gregtao.concerto.player.streamplayer.stream.Outlet;
import top.gregtao.concerto.player.streamplayer.stream.StreamDataSource;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerEventLauncher;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerException;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerInterface;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerListener;
import top.gregtao.concerto.player.streamplayer.stream.UrlDataSource;

public class StreamPlayer
implements StreamPlayerInterface,
Callable<Void> {
    private final Logger logger;
    private volatile Status status = Status.NOT_SPECIFIED;
    private DataSource source;
    private volatile AudioInputStream audioInputStream;
    private AudioInputStream encodedAudioInputStream;
    private final Object audioLock = new Object();
    private String mixerName;
    private Mixer mixer = null;
    private int currentLineBufferSize = -1;
    private int lineBufferSize = -1;
    private int encodedAudioLength = -1;
    private double speedFactor = 1.0;
    private static final int EXTERNAL_BUFFER_SIZE = 4096;
    byte[] trimBuffer;
    private final ExecutorService streamPlayerExecutorService;
    private Future<Void> future;
    private final ExecutorService eventsExecutorService;
    private final ArrayList<StreamPlayerListener> listeners;
    private final Map<String, Object> emptyMap = new HashMap<String, Object>();
    Map<String, Object> audioProperties;
    private final Outlet outlet;

    public StreamPlayer() {
        this(Logger.getLogger(StreamPlayer.class.getName()));
    }

    public StreamPlayer(Logger logger) {
        this(logger, Executors.newSingleThreadExecutor(), Executors.newSingleThreadExecutor());
    }

    public StreamPlayer(Logger logger, ExecutorService streamPlayerExecutorService, ExecutorService eventsExecutorService) {
        this.logger = logger;
        this.streamPlayerExecutorService = streamPlayerExecutorService;
        this.eventsExecutorService = eventsExecutorService;
        this.listeners = new ArrayList();
        this.outlet = new Outlet(logger);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.audioLock;
        synchronized (object) {
            this.closeStream();
        }
        this.outlet.flushAndFreeDataLine();
        this.audioInputStream = null;
        this.encodedAudioInputStream = null;
        this.encodedAudioLength = -1;
        this.outlet.setGainControl(null);
        this.outlet.setPanControl(null);
        this.outlet.setBalanceControl(null);
        this.status = Status.NOT_SPECIFIED;
        this.generateEvent(Status.NOT_SPECIFIED, -1, null);
    }

    private String generateEvent(Status status, int encodedStreamPosition, Object description) {
        try {
            return this.eventsExecutorService.submit(new StreamPlayerEventLauncher(this, status, encodedStreamPosition, description, this.listeners)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            this.logger.log(Level.WARNING, "Problem in StreamPlayer generateEvent() method", ex);
            return "Problem in StreamPlayer generateEvent() method";
        }
    }

    @Override
    public void addStreamPlayerListener(StreamPlayerListener streamPlayerListener) {
        Objects.requireNonNull(streamPlayerListener, "null is not allowed as StreamPlayerListener value.");
        this.listeners.add(streamPlayerListener);
    }

    @Override
    public void removeStreamPlayerListener(StreamPlayerListener streamPlayerListener) {
        if (this.listeners != null) {
            this.listeners.remove(streamPlayerListener);
        }
    }

    @Override
    @Deprecated
    public void open(Object object) throws StreamPlayerException {
        this.logger.info(() -> "open(" + String.valueOf(object) + ")\n");
        if (object == null) {
            return;
        }
        try {
            this.source = DataSource.newDataSource(object);
        }
        catch (OperationNotSupportedException e) {
            e.printStackTrace();
        }
        this.initAudioInputStream();
    }

    @Override
    public void open(File file) throws StreamPlayerException {
        this.logger.info(() -> "open(" + String.valueOf(file) + ")\n");
        this.source = new FileDataSource(file);
        this.initAudioInputStream();
    }

    @Override
    public void open(URL url) throws StreamPlayerException {
        this.logger.info(() -> "open(" + String.valueOf(url) + ")\n");
        this.source = new UrlDataSource(url);
        this.initAudioInputStream();
    }

    @Override
    public void open(InputStream stream) throws StreamPlayerException {
        this.logger.info(() -> "open(" + String.valueOf(stream) + ")\n");
        this.source = new StreamDataSource(stream);
        this.initAudioInputStream();
    }

    private void initAudioInputStream() throws StreamPlayerException {
        try {
            this.logger.info("Entered initAudioInputStream\n");
            this.reset();
            this.status = Status.OPENING;
            this.generateEvent(Status.OPENING, this.getEncodedStreamPosition(), this.source);
            this.audioInputStream = this.source.getAudioInputStream();
            this.createLine();
            this.status = Status.OPENED;
            this.generateEvent(Status.OPENED, this.getEncodedStreamPosition(), null);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            this.logger.log(Level.INFO, e.getMessage(), e);
            throw new StreamPlayerException(e);
        }
        this.logger.info("Exited initAudioInputStream\n");
    }

    private void initLine() throws LineUnavailableException, StreamPlayerException {
        this.logger.info("Initiating the line...");
        if (this.outlet.getSourceDataLine() == null) {
            this.createLine();
        }
        if (!this.outlet.getSourceDataLine().isOpen()) {
            this.currentLineBufferSize = this.lineBufferSize >= 0 ? this.lineBufferSize : this.outlet.getSourceDataLine().getBufferSize();
            this.openLine(this.audioInputStream.getFormat(), this.currentLineBufferSize);
        } else {
            AudioFormat format;
            AudioFormat audioFormat = format = this.audioInputStream == null ? null : this.audioInputStream.getFormat();
            if (!this.outlet.getSourceDataLine().getFormat().equals(format)) {
                this.outlet.getSourceDataLine().close();
                this.currentLineBufferSize = this.lineBufferSize >= 0 ? this.lineBufferSize : this.outlet.getSourceDataLine().getBufferSize();
                this.openLine(this.audioInputStream.getFormat(), this.currentLineBufferSize);
            }
        }
    }

    @Override
    public void setSpeedFactor(double speedFactor) {
        this.speedFactor = speedFactor;
    }

    public AudioInputStream decodeFlacToInputStream(InputStream inputStream, AudioFormat targetFormat, int bit) {
        try {
            this.logger.info(() -> "Entered decodeFlacToInputStream(" + String.valueOf(inputStream) + ")\n");
            return new AudioInputStream(new FlacDecoderStream(inputStream, targetFormat, bit, this.logger), targetFormat, -1L);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void createLine() throws LineUnavailableException, StreamPlayerException {
        this.logger.info("Entered CreateLine()!:\n");
        if (this.outlet.getSourceDataLine() != null) {
            this.logger.warning("Warning Source DataLine is not null!\n");
        } else {
            int nSampleSizeInBits;
            AudioFormat sourceFormat = this.audioInputStream.getFormat();
            this.logger.info(() -> "Create Line : Source format : " + String.valueOf(sourceFormat) + "\n");
            AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
            int bitBackup = nSampleSizeInBits = sourceFormat.getSampleSizeInBits();
            if (sourceFormat.getEncoding() == AudioFormat.Encoding.ULAW || sourceFormat.getEncoding() == AudioFormat.Encoding.ALAW || nSampleSizeInBits != 8) {
                nSampleSizeInBits = 16;
            }
            AudioFormat targetFormat = new AudioFormat(encoding, (float)((double)sourceFormat.getSampleRate() * this.speedFactor), nSampleSizeInBits, sourceFormat.getChannels(), nSampleSizeInBits / 8 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), false);
            this.logger.info(() -> "Sample Rate =" + targetFormat.getSampleRate() + ",Frame Rate=" + targetFormat.getFrameRate() + ",Bit Rate=" + targetFormat.getSampleSizeInBits() + "; Target format: " + String.valueOf(targetFormat) + "\n");
            this.encodedAudioInputStream = this.audioInputStream;
            try {
                this.encodedAudioLength = this.encodedAudioInputStream.available();
            }
            catch (IOException e) {
                this.logger.warning("Cannot get m_encodedAudioInputStream.available()\n" + String.valueOf(e));
            }
            this.audioInputStream = !sourceFormat.toString().toLowerCase().startsWith("flac") ? AudioSystem.getAudioInputStream(targetFormat, this.audioInputStream) : this.decodeFlacToInputStream(this.audioInputStream, targetFormat, bitBackup);
            DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.audioInputStream.getFormat(), -1);
            if (!AudioSystem.isLineSupported(lineInfo)) {
                throw new StreamPlayerException(StreamPlayerException.PlayerException.LINE_NOT_SUPPORTED);
            }
            if (this.mixerName == null) {
                this.mixerName = this.getMixers().get(0);
            }
            this.mixer = this.getMixer(this.mixerName);
            if (this.mixer == null) {
                this.outlet.setSourceDataLine((SourceDataLine)AudioSystem.getLine(lineInfo));
                this.mixerName = null;
            } else {
                this.logger.info("Mixer: " + String.valueOf(this.mixer.getMixerInfo()));
                this.outlet.setSourceDataLine((SourceDataLine)this.mixer.getLine(lineInfo));
            }
            this.logger.info(() -> "Line : " + String.valueOf(this.outlet.getSourceDataLine()));
            this.logger.info(() -> "Line Info : " + String.valueOf(this.outlet.getSourceDataLine().getLineInfo()));
            this.logger.info(() -> "Line AudioFormat: " + String.valueOf(this.outlet.getSourceDataLine().getFormat()) + "\n");
            this.logger.info("Exited CREATE LINE()!:\n");
        }
    }

    private void openLine(AudioFormat audioFormat, int currentLineBufferSize) throws LineUnavailableException {
        this.outlet.open(audioFormat, currentLineBufferSize);
    }

    @Override
    public void play() throws StreamPlayerException {
        if (this.status == Status.STOPPED) {
            this.initAudioInputStream();
        }
        if (this.status != Status.OPENED) {
            return;
        }
        this.awaitTermination();
        try {
            this.initLine();
        }
        catch (LineUnavailableException ex) {
            throw new StreamPlayerException(StreamPlayerException.PlayerException.CAN_NOT_INIT_LINE, (Throwable)ex);
        }
        if (this.outlet.isStartable()) {
            this.outlet.start();
            this.logger.info("Submitting new StreamPlayer Thread");
            this.streamPlayerExecutorService.submit(this);
            this.status = Status.PLAYING;
            this.generateEvent(Status.PLAYING, this.getEncodedStreamPosition(), null);
        }
    }

    @Override
    public boolean pause() {
        if (this.outlet.getSourceDataLine() == null || this.status != Status.PLAYING) {
            return false;
        }
        this.status = Status.PAUSED;
        this.logger.info("pausePlayback() completed");
        this.generateEvent(Status.PAUSED, this.getEncodedStreamPosition(), null);
        return true;
    }

    @Override
    public void stop() {
        if (this.status == Status.STOPPED) {
            return;
        }
        if (this.isPlaying()) {
            this.pause();
        }
        this.status = Status.STOPPED;
        this.logger.info("StreamPlayer stopPlayback() completed");
    }

    @Override
    public boolean resume() {
        if (this.outlet.getSourceDataLine() == null || this.status != Status.PAUSED) {
            return false;
        }
        this.outlet.start();
        this.status = Status.PLAYING;
        this.generateEvent(Status.RESUMED, this.getEncodedStreamPosition(), null);
        this.logger.info("resumePlayback() completed");
        return true;
    }

    private void awaitTermination() {
        if (this.future != null && !this.future.isDone()) {
            try {
                Thread delay = new Thread(() -> {
                    try {
                        for (int i = 0; i < 50 && !this.future.isDone(); ++i) {
                            Thread.sleep(20L);
                            this.logger.log(Level.INFO, "StreamPlayer Future is not yet done...");
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        this.logger.log(Level.INFO, ex.getMessage(), ex);
                    }
                });
                delay.start();
                delay.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            finally {
                this.future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekBytes(long bytes) throws StreamPlayerException {
        long totalSkipped = 0L;
        if (this.source.isFile()) {
            long bytesLength = this.getTotalBytes();
            this.logger.log(Level.INFO, "Bytes: " + bytes + " BytesLength: " + bytesLength);
            if (bytesLength <= 0L || bytes >= bytesLength) {
                this.generateEvent(Status.EOM, this.getEncodedStreamPosition(), null);
                return totalSkipped;
            }
            this.logger.info(() -> "Bytes to skip : " + bytes);
            Status previousStatus = this.status;
            this.status = Status.SEEKING;
            try {
                Object object = this.audioLock;
                synchronized (object) {
                    this.generateEvent(Status.SEEKING, -1, null);
                    this.initAudioInputStream();
                    if (this.audioInputStream != null) {
                        long skipped;
                        while (totalSkipped < bytes && (skipped = this.audioInputStream.skip(bytes - totalSkipped)) != 0L) {
                            this.logger.info("Skipped : " + (totalSkipped += skipped) + "/" + bytes);
                            if (totalSkipped == -1L) {
                                throw new StreamPlayerException(StreamPlayerException.PlayerException.SKIP_NOT_SUPPORTED);
                            }
                            this.logger.info("Skipping:" + totalSkipped);
                        }
                    }
                }
                this.generateEvent(Status.SEEKED, this.getEncodedStreamPosition(), null);
                this.status = Status.OPENED;
                if (previousStatus == Status.PLAYING) {
                    this.play();
                } else if (previousStatus == Status.PAUSED) {
                    this.play();
                    this.pause();
                }
            }
            catch (IOException ex) {
                this.logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return totalSkipped;
    }

    @Override
    public long seekSeconds(int seconds) throws StreamPlayerException {
        int durationInSeconds = this.getDurationInSeconds();
        this.validateSeconds(seconds, durationInSeconds);
        long totalBytes = this.getTotalBytes();
        double percentage = (double)(seconds * 100) / (double)durationInSeconds;
        long bytes = (long)((double)totalBytes * (percentage / 100.0));
        return this.seekBytes((long)this.getEncodedStreamPosition() + bytes);
    }

    @Override
    public long seekTo(int seconds) throws StreamPlayerException {
        int durationInSeconds = this.getDurationInSeconds();
        this.validateSeconds(seconds, durationInSeconds);
        long totalBytes = this.getTotalBytes();
        double percentage = (double)(seconds * 100) / (double)durationInSeconds;
        long bytes = (long)((double)totalBytes * (percentage / 100.0));
        return this.seekBytes(bytes);
    }

    private void validateSeconds(int seconds, int durationInSeconds) {
        if (seconds < 0) {
            throw new UnsupportedOperationException("Trying to skip negative seconds ");
        }
        if (seconds >= durationInSeconds) {
            throw new UnsupportedOperationException("Trying to skip with seconds {" + seconds + "} > maximum {" + durationInSeconds + "}");
        }
    }

    @Override
    public int getDurationInSeconds() {
        return this.source.getDurationInSeconds();
    }

    @Override
    public long getDurationInMilliseconds() {
        return this.source.getDurationInMilliseconds();
    }

    @Override
    public Duration getDuration() {
        return this.source.getDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() {
        int nBytesRead = 0;
        int audioDataLength = 4096;
        ByteBuffer audioDataBuffer = ByteBuffer.allocate(4096);
        audioDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Object object = this.audioLock;
        synchronized (object) {
            while (nBytesRead != -1 && this.status != Status.STOPPED && this.status != Status.NOT_SPECIFIED && this.status != Status.SEEKING) {
                try {
                    if (this.status == Status.PLAYING) {
                        int totalRead = 0;
                        for (int toRead = 4096; toRead > 0 && (nBytesRead = this.audioInputStream.read(audioDataBuffer.array(), totalRead, toRead)) > 0; toRead -= nBytesRead, totalRead += nBytesRead) {
                            if (this.outlet.getSourceDataLine().available() < this.outlet.getSourceDataLine().getBufferSize()) continue;
                            this.logger.info(() -> "Under run> Available=" + this.outlet.getSourceDataLine().available() + " , SourceDataLineBuffer=" + this.outlet.getSourceDataLine().getBufferSize());
                        }
                        if (totalRead <= 0) continue;
                        this.trimBuffer = audioDataBuffer.array();
                        if (totalRead < this.trimBuffer.length) {
                            this.trimBuffer = new byte[totalRead];
                            System.arraycopy(audioDataBuffer.array(), 0, this.trimBuffer, 0, totalRead);
                        }
                        this.outlet.getSourceDataLine().write(this.trimBuffer, 0, totalRead);
                        int nEncodedBytes = this.getEncodedStreamPosition();
                        this.listeners.forEach(listener -> {
                            if (this.audioInputStream instanceof PropertiesContainer) {
                                listener.progress(nEncodedBytes, this.outlet.getSourceDataLine().getMicrosecondPosition(), this.trimBuffer, ((PropertiesContainer)((Object)this.audioInputStream)).properties());
                            } else {
                                listener.progress(nEncodedBytes, this.outlet.getSourceDataLine().getMicrosecondPosition(), this.trimBuffer, this.emptyMap);
                            }
                        });
                        continue;
                    }
                    if (this.status != Status.PAUSED) continue;
                    this.outlet.flushAndStop();
                    this.goOutOfPause();
                }
                catch (IOException ex) {
                    this.logger.log(Level.WARNING, "\"Decoder Exception: \" ", ex);
                    this.status = Status.STOPPED;
                    this.generateEvent(Status.STOPPED, this.getEncodedStreamPosition(), null);
                }
            }
            this.outlet.drainStopAndFreeDataLine();
            this.closeStream();
            if (nBytesRead == -1) {
                this.generateEvent(Status.EOM, -1, null);
            }
        }
        this.status = Status.STOPPED;
        this.generateEvent(Status.STOPPED, -1, null);
        this.logger.info("Decoding thread completed");
        return null;
    }

    private void goOutOfPause() {
        try {
            while (this.status == Status.PAUSED) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.logger.warning("Thread cannot sleep.\n" + String.valueOf(ex));
        }
    }

    @Override
    public int getEncodedStreamPosition() {
        int position = -1;
        if (this.source.isFile() && this.encodedAudioInputStream != null) {
            try {
                position = this.encodedAudioLength - this.encodedAudioInputStream.available();
            }
            catch (IOException ex) {
                this.logger.log(Level.WARNING, "Cannot get m_encodedAudioInputStream.available()", ex);
                this.stop();
            }
        }
        return position;
    }

    private void closeStream() {
        try {
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
                this.logger.info("Stream closed");
            }
        }
        catch (IOException ex) {
            this.logger.warning("Cannot close stream\n" + String.valueOf(ex));
        }
    }

    @Override
    public int getLineBufferSize() {
        return this.lineBufferSize;
    }

    @Override
    public int getLineCurrentBufferSize() {
        return this.currentLineBufferSize;
    }

    @Override
    public List<String> getMixers() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        Arrays.stream(mixerInfos).forEach(mInfo -> {
            Line.Info lineInfo = new Line.Info(SourceDataLine.class);
            Mixer mixer = AudioSystem.getMixer(mInfo);
            if (mixer.isLineSupported(lineInfo)) {
                mixers.add(mInfo.getName());
            }
        });
        return mixers;
    }

    private Mixer getMixer(String name) {
        Mixer mixer = null;
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (name != null) {
            for (Mixer.Info mixerInfo : mixerInfos) {
                if (!mixerInfo.getName().equals(name)) continue;
                mixer = AudioSystem.getMixer(mixerInfo);
                break;
            }
        }
        return mixer;
    }

    @Override
    public void setMixerName(String mixerName) {
        this.mixerName = mixerName;
    }

    public String getMixerName() {
        return this.mixerName;
    }

    public Mixer getCurrentMixer() {
        return this.mixer;
    }

    @Override
    public float getGainValue() {
        return this.outlet.getGainValue();
    }

    @Override
    public float getMaximumGain() {
        return !this.outlet.hasControl(FloatControl.Type.MASTER_GAIN, this.outlet.getGainControl()) ? 0.0f : this.outlet.getGainControl().getMaximum();
    }

    @Override
    public float getMinimumGain() {
        return !this.outlet.hasControl(FloatControl.Type.MASTER_GAIN, this.outlet.getGainControl()) ? 0.0f : this.outlet.getGainControl().getMinimum();
    }

    @Override
    public float getPrecision() {
        return !this.outlet.hasControl(FloatControl.Type.PAN, this.outlet.getPanControl()) ? 0.0f : this.outlet.getPanControl().getPrecision();
    }

    @Override
    public float getPan() {
        return !this.outlet.hasControl(FloatControl.Type.PAN, this.outlet.getPanControl()) ? 0.0f : this.outlet.getPanControl().getValue();
    }

    @Override
    public boolean getMute() {
        return this.outlet.hasControl(BooleanControl.Type.MUTE, this.outlet.getMuteControl()) && this.outlet.getMuteControl().getValue();
    }

    @Override
    public float getBalance() {
        return !this.outlet.hasControl(FloatControl.Type.BALANCE, this.outlet.getBalanceControl()) ? 0.0f : this.outlet.getBalanceControl().getValue();
    }

    @Override
    public long getTotalBytes() {
        return this.encodedAudioLength;
    }

    @Override
    public int getPositionByte() {
        int positionByte = -1;
        if (this.audioProperties != null) {
            if (this.audioProperties.containsKey("mp3.position.byte")) {
                return (Integer)this.audioProperties.get("mp3.position.byte");
            }
            if (this.audioProperties.containsKey("ogg.position.byte")) {
                return (Integer)this.audioProperties.get("ogg.position.byte");
            }
        }
        return -1;
    }

    public Outlet getOutlet() {
        return this.outlet;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    private Map<String, Object> deepCopy(Map<String, Object> map) {
        HashMap<String, Object> copier = new HashMap<String, Object>();
        if (map != null) {
            map.keySet().forEach(key -> copier.put((String)key, map.get(key)));
        }
        return copier;
    }

    @Override
    public void setLineBufferSize(int size) {
        this.lineBufferSize = size;
    }

    @Override
    public void setPan(double fPan) {
        if (!this.outlet.hasControl(FloatControl.Type.PAN, this.outlet.getPanControl()) || fPan < -1.0 || fPan > 1.0) {
            return;
        }
        this.logger.info(() -> "Pan : " + fPan);
        this.outlet.getPanControl().setValue((float)fPan);
        this.generateEvent(Status.PAN, this.getEncodedStreamPosition(), null);
    }

    @Override
    public void setGain(double fGain) {
        if (this.isPlaying() || this.isPaused() && this.outlet.hasControl(FloatControl.Type.MASTER_GAIN, this.outlet.getGainControl())) {
            double logScaleGain = 20.0 * Math.log10(fGain);
            this.outlet.getGainControl().setValue((float)logScaleGain);
        }
    }

    @Override
    public void setLogScaleGain(double logScaleGain) {
        if (this.isPlaying() || this.isPaused() && this.outlet.hasControl(FloatControl.Type.MASTER_GAIN, this.outlet.getGainControl())) {
            this.outlet.getGainControl().setValue((float)logScaleGain);
        }
    }

    @Override
    public void setMute(boolean mute) {
        if (this.outlet.hasControl(BooleanControl.Type.MUTE, this.outlet.getMuteControl()) && this.outlet.getMuteControl().getValue() != mute) {
            this.outlet.getMuteControl().setValue(mute);
        }
    }

    @Override
    public void setBalance(float fBalance) {
        if (this.outlet.hasControl(FloatControl.Type.BALANCE, this.outlet.getBalanceControl()) && (double)fBalance >= -1.0 && (double)fBalance <= 1.0) {
            this.outlet.getBalanceControl().setValue(fBalance);
        } else {
            try {
                throw new StreamPlayerException(StreamPlayerException.PlayerException.BALANCE_CONTROL_NOT_SUPPORTED);
            }
            catch (StreamPlayerException ex) {
                this.logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void setEqualizer(float[] array, int stop) {
        if (!this.isPausedOrPlaying() || !(this.audioInputStream instanceof PropertiesContainer)) {
            return;
        }
        float[] equalizer = (float[])((PropertiesContainer)((Object)this.audioInputStream)).properties().get("mp3.equalizer");
        if (stop >= 0) {
            System.arraycopy(array, 0, equalizer, 0, stop);
        }
    }

    @Override
    public void setEqualizerKey(float value, int key) {
        if (!this.isPausedOrPlaying() || !(this.audioInputStream instanceof PropertiesContainer)) {
            return;
        }
        float[] equalizer = (float[])((PropertiesContainer)((Object)this.audioInputStream)).properties().get("mp3.equalizer");
        equalizer[key] = value;
    }

    @Override
    public double getSpeedFactor() {
        return this.speedFactor;
    }

    @Override
    public boolean isUnknown() {
        return this.status == Status.NOT_SPECIFIED;
    }

    @Override
    public boolean isPlaying() {
        return this.status == Status.PLAYING;
    }

    @Override
    public boolean isPaused() {
        return this.status == Status.PAUSED;
    }

    @Override
    public boolean isPausedOrPlaying() {
        return this.isPlaying() || this.isPaused();
    }

    @Override
    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    @Override
    public boolean isOpened() {
        return this.status == Status.OPENED;
    }

    @Override
    public boolean isSeeking() {
        return this.status == Status.SEEKING;
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public SourceDataLine getSourceDataLine() {
        return this.outlet.getSourceDataLine();
    }
}

