/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.enums.TextAlignment;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.util.TextUtil;
import top.gregtao.concerto.util.Vector2i;

public class InGameHudRenderer {
    public static ScrollingText MUSIC_DETAIL_SCROLL = new ScrollingText();

    public static void enableScissor(int x1, int y1, int x2, int y2) {
        class_1041 window = class_310.method_1551().method_22683();
        int bufferHeight = window.method_4506();
        double scaleFactor = window.method_4495();
        int rX1 = (int)((double)x1 * scaleFactor);
        int rY1 = (int)((double)bufferHeight - (double)y2 * scaleFactor);
        int rWidth = (int)((double)(x2 - x1) * scaleFactor);
        int rHeight = (int)((double)(y2 - y1) * scaleFactor);
        RenderSystem.enableScissor((int)rX1, (int)rY1, (int)Math.max(0, rWidth), (int)Math.max(0, rHeight));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void render(class_4587 matrices, float delta) {
        class_310 client = class_310.method_1551();
        if (MusicPlayer.INSTANCE.isPlaying()) {
            ClientConfig config = ClientConfig.INSTANCE;
            ClientConfig.ClientConfigOptions options = config.options;
            if (!options.hideWhenChat || !(client.field_1755 instanceof class_408)) {
                Vector2i pos;
                Vector2i pos2;
                int scaledWidth = client.method_22683().method_4486();
                int scaledHeight = client.method_22683().method_4502();
                String[] texts = MusicPlayerHandler.INSTANCE.getDisplayTexts();
                matrices = new class_4587();
                if (options.displayLyrics) {
                    pos2 = config.lyricsPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)new class_2585(texts[0]), options.lyricsAlignment, pos2.getX(), pos2.getY(), matrices, client.field_1772, (int)config.lyricsColor.getNumber());
                }
                if (options.displaySubLyrics) {
                    pos2 = config.subLyricsPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)new class_2585(texts[1]), options.subLyricsAlignment, pos2.getX(), pos2.getY(), matrices, client.field_1772, (int)config.subLyricsColor.getNumber());
                }
                class_2585 text3 = new class_2585(texts[3]);
                int text3Width = client.field_1772.method_27525((class_5348)text3);
                if (options.displayMusicDetails) {
                    pos = config.musicDetailsPosSupplier.getPos(scaledWidth, scaledHeight);
                    String state = MusicPlayer.INSTANCE.isPlayingTemp ? (ConcertoClient.clientState == ConcertoClient.ClientState.MUSIC_AGENT ? " | " + new class_2588("concerto.agent").getString() : (ConcertoClient.clientState == ConcertoClient.ClientState.MUSIC_ROOM ? " | " + new class_2588("concerto.room").getString() : "")) : "";
                    class_2585 text2 = new class_2585(texts[2] + state);
                    MUSIC_DETAIL_SCROLL.setMaxWidth(text3Width);
                    MUSIC_DETAIL_SCROLL.setWidth(client.field_1772.method_27525((class_5348)text2));
                    MUSIC_DETAIL_SCROLL.tick(options.scrollingTextSpeed);
                    int startX = TextUtil.getTextRenderX((class_2561)text3, options.musicDetailsAlignment, client.field_1772, pos.getX());
                    int n = pos.getY();
                    int n2 = pos.getY();
                    Objects.requireNonNull(client.field_1772);
                    InGameHudRenderer.enableScissor(startX, n, startX + text3Width, n2 + 9);
                    if (ClientConfig.INSTANCE.options.textShadow) {
                        client.field_1772.method_30881(matrices, (class_2561)text2, (float)(startX + MUSIC_DETAIL_SCROLL.getDx()), (float)pos.getY(), (int)config.musicDetailsColor.getNumber());
                    } else {
                        client.field_1772.method_30883(matrices, (class_2561)text2, (float)(startX + MUSIC_DETAIL_SCROLL.getDx()), (float)pos.getY(), (int)config.musicDetailsColor.getNumber());
                    }
                    InGameHudRenderer.disableScissor();
                }
                if (options.displayTimeProgress) {
                    pos = config.timeProgressPosSupplier.getPos(scaledWidth, scaledHeight);
                    TextUtil.renderText((class_2561)text3, options.timeProgressAlignment, pos.getX(), pos.getY(), matrices, client.field_1772, (int)config.timeProgressTextColor.getNumber());
                    int blankWidth = client.field_1772.method_1727("                              ");
                    int timeWidth = (text3Width - blankWidth) / 2;
                    if (MusicPlayerHandler.INSTANCE.currentMeta != null && MusicPlayerHandler.INSTANCE.currentMeta.getDuration() != null) {
                        int x = switch (options.timeProgressAlignment) {
                            case TextAlignment.LEFT -> pos.getX() + timeWidth + 9;
                            case TextAlignment.CENTER -> pos.getX() - blankWidth / 2 + 9;
                            default -> pos.getX() - blankWidth - timeWidth + 9;
                        };
                        class_332.method_25294((class_4587)matrices, (int)x, (int)(pos.getY() + 3), (int)(x + blankWidth - 20), (int)(pos.getY() + 5), (int)((int)config.timeProgressBgColor.getNumber()));
                        class_332.method_25294((class_4587)matrices, (int)x, (int)(pos.getY() + 3), (int)((int)((float)x + (float)(blankWidth - 20) * MusicPlayerHandler.INSTANCE.progressPercentage)), (int)(pos.getY() + 5), (int)((int)config.timeProgressColor.getNumber()));
                    }
                }
                if (options.displayCoverImg) {
                    matrices.method_22903();
                    pos = config.coverImgPosSupplier.getPos(scaledWidth, scaledHeight);
                    int size = config.options.coverImgSize;
                    MusicPlayerHandler.INSTANCE.headPicture.setX(pos.getX());
                    MusicPlayerHandler.INSTANCE.headPicture.setY(pos.getY());
                    MusicPlayerHandler.INSTANCE.headPicture.setSize(size, size);
                    if (options.coverImgRotate) {
                        float cx = (float)pos.getX() + (float)size / 2.0f;
                        float cy = (float)pos.getY() + (float)size / 2.0f;
                        float angleRad = (float)class_156.method_658() * (float)Math.PI / 180.0f / 50.0f;
                        matrices.method_22904((double)cx, (double)cy, 0.0);
                        matrices.method_22907(new class_1158(class_1160.field_20707, angleRad, false));
                        matrices.method_22904((double)(-cx), (double)(-cy), 0.0);
                    }
                    MusicPlayerHandler.INSTANCE.headPicture.method_25394(matrices, 0, 0, delta);
                    matrices.method_22909();
                }
            }
        }
    }

    public static class ScrollingText {
        public static int STOP_TICKS = 180;
        private int width = 0;
        private int maxWidth = 0;
        private float dx = 0.0f;
        private float stopTicks = 0.0f;
        private boolean stop = false;
        private boolean go_back = false;
        private long lastRenderTime = 0L;

        private void reset() {
            this.dx = 0.0f;
            this.go_back = false;
            this.stop = true;
            this.stopTicks = STOP_TICKS;
        }

        public void setWidth(int width) {
            if (width != this.width) {
                this.reset();
            }
            this.width = width;
        }

        public void setMaxWidth(int maxWidth) {
            if (maxWidth > this.maxWidth + 5 || maxWidth < this.maxWidth - 5) {
                this.reset();
            }
            this.maxWidth = maxWidth;
        }

        public long getRenderTimeDelta() {
            long delta = System.currentTimeMillis() - this.lastRenderTime;
            delta = Math.min(delta, 100L);
            this.lastRenderTime = System.currentTimeMillis();
            return delta;
        }

        public void tick(float speed) {
            if (this.width <= this.maxWidth) {
                return;
            }
            float delta = speed * 0.04f * (float)this.getRenderTimeDelta();
            if (this.stop) {
                this.stopTicks -= delta;
                if (this.stopTicks <= 0.0f) {
                    this.stop = false;
                    this.go_back = !this.go_back;
                }
            } else {
                float limit = this.go_back ? 0.0f : (float)(this.maxWidth - this.width);
                float f = this.dx = this.go_back ? Math.min(limit, this.dx + delta) : Math.max(limit, this.dx - delta);
                if (this.dx == limit) {
                    this.stop = true;
                    this.stopTicks = STOP_TICKS;
                }
            }
        }

        public int getDx() {
            return this.width <= this.maxWidth ? (this.maxWidth - this.width) / 2 : (int)this.dx;
        }
    }
}

