/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen.login;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import top.gregtao.concerto.http.HttpApiClient;
import top.gregtao.concerto.screen.ConcertoScreen;
import top.gregtao.concerto.screen.widget.TextWidget;

public class CookieLoginScreen
extends ConcertoScreen {
    private final HttpApiClient client;
    private final List<String> urlList;
    private class_342 field;
    private final Supplier<Boolean> loginStatusUpdater;

    public CookieLoginScreen(Supplier<Boolean> loginStatusUpdater, List<String> urlList, HttpApiClient client, class_2561 title, class_437 parent) {
        super((class_2561)new class_2585(new class_2588("concerto.screen.login").getString() + title.getString()), parent);
        this.client = client;
        this.urlList = urlList;
        this.loginStatusUpdater = loginStatusUpdater;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        TextWidget textWidget = new TextWidget(this.field_22789 / 2 - 200, 20, 400, 10, (class_2561)new class_2588("concerto.screen.login.cookie"), this.field_22793);
        this.method_25411(textWidget);
        this.field = new class_342(this.field_22793, this.field_22789 / 2 - 125, 30, 250, 20, class_2561.method_30163((String)""));
        this.field.method_1880(50000);
        this.method_25411((class_339)this.field);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 125, 60, 250, 20, (class_2561)new class_2588("concerto.screen.login.confirm"), button -> this.tryLogin()));
    }

    public static Map<String, String> parseCookiesRegex(String cookieHeader) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (cookieHeader == null || cookieHeader.isEmpty()) {
            return cookies;
        }
        Pattern pattern = Pattern.compile("(?<!\\S)([^=\\s]+)=([^;]*)(?=;|$)");
        Matcher matcher = pattern.matcher(cookieHeader);
        while (matcher.find()) {
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            cookies.put(key, value);
        }
        return cookies;
    }

    private void tryLogin() {
        Map<String, String> cookies = CookieLoginScreen.parseCookiesRegex(this.field.method_1882().trim());
        if (cookies.isEmpty()) {
            this.displayAlert((class_2561)new class_2588("concerto.screen.login.cookie.empty"));
        } else {
            for (String url : this.urlList) {
                try {
                    this.client.setCookies(url, cookies);
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.loginStatusUpdater.get().booleanValue()) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    player.method_7353((class_2561)new class_2588("concerto.screen.login.success"), false);
                }
                class_310.method_1551().method_1507(null);
            } else {
                this.displayAlert((class_2561)new class_2588("concerto.screen.login.cookie.failed"));
            }
        }
    }
}

