/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen.netease;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.WithMetaData;
import top.gregtao.concerto.enums.SearchType;
import top.gregtao.concerto.http.netease.NeteaseCloudApiClient;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.NeteaseCloudPlaylist;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.screen.MusicInfoScreen;
import top.gregtao.concerto.screen.PageScreen;
import top.gregtao.concerto.screen.PlaylistPreviewScreen;
import top.gregtao.concerto.screen.widget.ConcertoListWidget;
import top.gregtao.concerto.screen.widget.CyclingButtonWidget;
import top.gregtao.concerto.screen.widget.MetadataListWidget;
import top.gregtao.concerto.util.ConcertoRunner;

public class NeteaseCloudSearchScreen
extends PageScreen {
    public static String DEFAULT_KEYWORD = "";
    private MetadataListWidget<Music> musicList;
    private MetadataListWidget<NeteaseCloudPlaylist> playlistList;
    private MetadataListWidget<NeteaseCloudPlaylist> albumList;
    private Map<SearchType, ConcertoListWidget<?>> listWidgetsMap = new HashMap();
    protected class_342 searchBox;
    private class_4185 infoButton;
    private class_4185 searchButton;
    private class_4185 playButton;
    private class_4185 addButton;
    private CyclingButtonWidget<SearchType> typeButton;
    private SearchType searchType = SearchType.MUSIC;

    private <T extends WithMetaData> MetadataListWidget<T> initListsWidget() {
        return new MetadataListWidget<T>(this.field_22789, this.field_22790, 45, this.field_22790 - 35, 18){

            @Override
            public void onDoubleClicked(ConcertoListWidget.Entry entry) {
                try {
                    switch (NeteaseCloudSearchScreen.this.searchType) {
                        case MUSIC: {
                            MusicPlayer.INSTANCE.addMusicHere((Music)entry.item, true);
                            break;
                        }
                        case PLAYLIST: 
                        case ALBUM: {
                            class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)NeteaseCloudSearchScreen.this));
                        }
                    }
                }
                catch (ClassCastException e) {
                    ConcertoClient.LOGGER.error(e.getMessage());
                }
            }
        };
    }

    public NeteaseCloudSearchScreen(class_437 parent) {
        super((class_2561)new class_2588("concerto.screen.search.163"), parent);
    }

    private void search(String keyword, int page) {
        DEFAULT_KEYWORD = keyword;
        if (keyword.isEmpty()) {
            return;
        }
        ConcertoRunner.run(() -> {
            switch (this.searchType) {
                case MUSIC: {
                    this.musicList.reset(NeteaseCloudApiClient.INSTANCE.searchMusic(keyword, page), null);
                    break;
                }
                case PLAYLIST: {
                    this.playlistList.reset(NeteaseCloudApiClient.INSTANCE.searchPlaylist(keyword, page), null);
                    break;
                }
                case ALBUM: {
                    this.albumList.reset(NeteaseCloudApiClient.INSTANCE.searchAlbum(keyword, page), null);
                }
            }
            this.listWidgetsMap.get(this.searchType).method_25307(0.0);
        });
    }

    private void toggleSearch() {
        this.page = 0;
        this.search(this.searchBox.method_1882(), 0);
    }

    private void updateSearchType(SearchType type) {
        try {
            this.remove((class_364)this.listWidgetsMap.get(this.searchType));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.method_25429((class_364)this.listWidgetsMap.get(type));
        this.searchType = type;
        this.infoButton.field_22763 = type == SearchType.MUSIC;
        this.toggleSearch();
    }

    @Override
    public void onPageTurned(int page) {
        this.search(this.searchBox.method_1882(), page);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.setRenderBg(false);
        this.musicList = this.initListsWidget();
        this.playlistList = this.initListsWidget();
        this.albumList = this.initListsWidget();
        this.listWidgetsMap = Map.of(SearchType.MUSIC, this.musicList, SearchType.PLAYLIST, this.playlistList, SearchType.ALBUM, this.albumList);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 155, 17, 200, 20, this.searchBox, (class_2561)new class_2588("concerto.screen.search"));
        this.searchBox.method_1852(DEFAULT_KEYWORD);
        this.method_25411((class_339)this.searchBox);
        this.infoButton = new class_4185(this.field_22789 / 2 + 120, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.info"), button -> {
            ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
            if (entry != null) {
                class_310.method_1551().method_1507((class_437)new MusicInfoScreen((Music)entry.item, (class_437)this));
            }
        });
        this.method_25411((class_339)this.infoButton);
        this.searchButton = new class_4185(this.field_22789 / 2 + 50, 17, 52, 20, (class_2561)new class_2588("concerto.screen.search"), button -> this.toggleSearch());
        this.method_25411((class_339)this.searchButton);
        this.typeButton = CyclingButtonWidget.builder(SearchType::getName).values((SearchType[])SearchType.values()).initially(this.searchType).build(this.field_22789 / 2 + 105, 17, 65, 20, (class_2561)new class_2588("concerto.search_type"), (widget, type) -> this.updateSearchType((SearchType)type));
        this.method_25411((class_339)this.typeButton);
        this.playButton = new class_4185(this.field_22789 / 2 + 65, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.play"), button -> {
            switch (this.searchType) {
                case MUSIC: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusicHere((Music)entry.item, true);
                    }
                }
                case PLAYLIST: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.playlistList.method_25334();
                    if (entry != null) {
                        class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)this));
                    }
                }
                case ALBUM: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.albumList.method_25334();
                    if (entry == null) break;
                    class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)this));
                }
            }
        });
        this.method_25411((class_339)this.playButton);
        this.addButton = new class_4185(this.field_22789 / 2 + 10, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.add"), button -> {
            switch (this.searchType) {
                case MUSIC: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusic((Music)entry.item);
                    }
                }
                case PLAYLIST: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.playlistList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusic(() -> ((NeteaseCloudPlaylist)entry.item).getList(), () -> {});
                    }
                }
                case ALBUM: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.albumList.method_25334();
                    if (entry == null) break;
                    MusicPlayer.INSTANCE.addMusic(() -> ((NeteaseCloudPlaylist)entry.item).getList(), () -> {});
                }
            }
        });
        this.method_25411((class_339)this.addButton);
        this.updateSearchType(this.searchType);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        switch (this.searchType) {
            case PLAYLIST: {
                this.playlistList.method_25394(matrices, mouseX, mouseY, delta);
                break;
            }
            case MUSIC: {
                this.musicList.method_25394(matrices, mouseX, mouseY, delta);
                break;
            }
            case ALBUM: {
                this.albumList.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 && this.searchBox.method_20315()) {
            this.toggleSearch();
            return true;
        }
        return this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.searchBox.method_25400(chr, modifiers);
    }
}

