/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.config.CacheManager;
import top.gregtao.concerto.screen.ConcertoScreen;
import top.gregtao.concerto.util.HashUtil;

public class URLImageWidget
implements class_4068,
AutoCloseable {
    protected int width;
    protected int height;
    private int x;
    private int y;
    private String url;
    private class_1043 texture;
    private final class_2960 textureId;
    private State state = State.LOADING;
    private boolean border = true;

    public URLImageWidget(int width, int height, int x, int y, String url) {
        this.height = height;
        this.width = width;
        this.x = x;
        this.y = y;
        this.url = url;
        this.textureId = new class_2960("concerto", "image" + System.currentTimeMillis());
    }

    public URLImageWidget(int width, int height, int x, int y, String url, boolean border) {
        this(width, height, x, y, url);
        this.border = border;
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        if (originalImage.getWidth() == targetWidth && originalImage.getHeight() == targetHeight) {
            return originalImage;
        }
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 2);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }

    public static BufferedImage cropCircleImage(BufferedImage inputImage) {
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        int diameter = Math.min(width, height);
        BufferedImage output = new BufferedImage(diameter, diameter, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setClip(new Ellipse2D.Float(0.0f, 0.0f, diameter, diameter));
        int x = (width - diameter) / 2;
        int y = (height - diameter) / 2;
        g2.drawImage((Image)inputImage, -x, -y, null);
        g2.dispose();
        return output;
    }

    public static class_1011 toNativeImage(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
            return class_1011.method_4309((InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            ConcertoClient.LOGGER.error("Error parsing BufferedImage to NativeImage", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFileName() {
        return HashUtil.md5(this.url) + ".png";
    }

    public boolean cacheExists() {
        return CacheManager.IMAGE_CACHE_MANAGER.exists(this.getFileName());
    }

    public File getFromCache() {
        return CacheManager.IMAGE_CACHE_MANAGER.getChild(this.getFileName());
    }

    public void writeCacheFile(BufferedImage image) throws IOException {
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = rgbImage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
        if (!writers.hasNext()) {
            throw new IllegalStateException("No JPEG writers available");
        }
        ImageWriter writer = writers.next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(0.8f);
        ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(rgbImage, null, null), param);
        ios.close();
        writer.dispose();
        CacheManager.IMAGE_CACHE_MANAGER.addFile(this.getFileName(), new ByteArrayInputStream(outputStream.toByteArray()));
    }

    public static BufferedImage readImageFromUrl(String url) throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                return ImageIO.read(URI.create(url).toURL());
            }
            catch (Exception e) {
                ConcertoClient.LOGGER.warn("Error reading image from URL: {}", (Object)url);
                continue;
            }
        }
        throw new IOException("Error reading image from URL: " + url);
    }

    private void uploadImage(BufferedImage image, Runnable callback) {
        class_1011 nativeImage = URLImageWidget.toNativeImage(image);
        class_310.method_1551().method_20493(() -> {
            if (this.texture == null) {
                class_310.method_1551().method_1531().method_4615(this.textureId);
            }
            this.texture = new class_1043(nativeImage);
            class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)this.texture);
        }).thenRun(callback);
    }

    public void loadImage() {
        this.loadImage(true, false);
    }

    public void loadImage(boolean useCache, boolean cropCircle) {
        if (this.url == null) {
            return;
        }
        try {
            BufferedImage image;
            this.state = State.LOADING;
            if (useCache && this.cacheExists()) {
                image = URLImageWidget.resizeImage(ImageIO.read(this.getFromCache()), this.getImageWidth(), this.getImageHeight());
            } else {
                image = URLImageWidget.resizeImage(URLImageWidget.readImageFromUrl(this.url), this.getImageWidth(), this.getImageHeight());
                if (useCache) {
                    this.writeCacheFile(image);
                }
            }
            if (cropCircle) {
                image = URLImageWidget.cropCircleImage(image);
            }
            this.uploadImage(image, () -> {
                this.state = State.READY;
            });
        }
        catch (MalformedURLException e) {
            ConcertoClient.LOGGER.error("Malformed URL: {}", (Object)this.url, (Object)e);
            this.state = State.FAILED;
        }
        catch (IOException e) {
            ConcertoClient.LOGGER.error("Error while loading image: {}", (Object)this.url, (Object)e);
            this.state = State.FAILED;
        }
    }

    public void loadImage(Function<String, byte[]> imageSupplier) {
        this.loadImage(imageSupplier, true);
    }

    public void loadImage(Function<String, byte[]> imageSupplier, boolean useCache) {
        try {
            BufferedImage image;
            this.state = State.LOADING;
            if (useCache && this.cacheExists()) {
                image = URLImageWidget.resizeImage(ImageIO.read(this.getFromCache()), this.getImageWidth(), this.getImageHeight());
            } else {
                image = URLImageWidget.resizeImage(ImageIO.read(new ByteArrayInputStream(imageSupplier.apply(this.url))), this.getImageWidth(), this.getImageHeight());
                if (useCache) {
                    this.writeCacheFile(image);
                }
            }
            this.uploadImage(image, () -> {
                this.state = State.READY;
            });
        }
        catch (IOException e) {
            ConcertoClient.LOGGER.error("Error while loading image: {}", (Object)this.url, (Object)e);
            this.state = State.FAILED;
        }
    }

    @Override
    public void close() {
        this.state = State.FAILED;
        class_310.method_1551().method_1531().method_4615(this.textureId);
        if (this.texture != null) {
            this.texture.close();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.border) {
            URLImageWidget.drawBorder(matrices, this.x, this.y, this.width, this.height, -1);
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (this.url == null || this.texture == null) {
            class_5481 class_54812 = new class_2588("concerto.screen.url_image.empty").method_30937();
            int n = this.x + this.width / 2;
            Objects.requireNonNull(textRenderer);
            ConcertoScreen.drawCenteredTextWithShadow(matrices, textRenderer, class_54812, n, this.y + (this.height - 9) / 2, -1);
        } else {
            class_1011 image = this.texture.method_4525();
            if (image != null && this.state == State.READY) {
                matrices.method_22903();
                matrices.method_22905(0.0625f, 0.0625f, 1.0f);
                matrices.method_22904((double)(15 * this.x), (double)(15 * this.y), 0.0);
                RenderSystem.bindTexture((int)this.texture.method_4624());
                class_332.method_25290((class_4587)matrices, (int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.getImageWidth(), (int)this.getImageHeight(), (int)this.getImageWidth(), (int)this.getImageHeight());
                matrices.method_22909();
            } else if (this.state == State.LOADING) {
                class_5481 class_54813 = new class_2588("concerto.screen.loading").method_30937();
                int n = this.x + this.width / 2;
                Objects.requireNonNull(textRenderer);
                ConcertoScreen.drawCenteredTextWithShadow(matrices, textRenderer, class_54813, n, this.y + (this.height - 9) / 2, -1);
            } else {
                class_5481 class_54814 = new class_2588("concerto.fail").method_30937();
                int n = this.x + this.width / 2;
                Objects.requireNonNull(textRenderer);
                ConcertoScreen.drawCenteredTextWithShadow(matrices, textRenderer, class_54814, n, this.y + (this.height - 9) / 2, -1);
            }
        }
    }

    public static void drawBorder(class_4587 matrices, int x, int y, int width, int height, int color) {
        class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)color);
        class_332.method_25294((class_4587)matrices, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)color);
        class_332.method_25294((class_4587)matrices, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        class_332.method_25294((class_4587)matrices, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getImageWidth() {
        return this.getWidth() << 4;
    }

    public int getHeight() {
        return this.height;
    }

    public int getImageHeight() {
        return this.getHeight() << 4;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    static enum State {
        LOADING,
        FAILED,
        READY;

    }
}

