/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class EncryptionChunk
extends Chunk {
    private String keyID = "";
    private String licenseURL = "";
    private String protectionType = "";
    private String secretData = "";
    private final ArrayList<String> strings = new ArrayList();

    public EncryptionChunk(BigInteger chunkLen) {
        super(GUID.GUID_CONTENT_ENCRYPTION, chunkLen);
    }

    public void addString(String toAdd) {
        this.strings.add(toAdd);
    }

    public String getKeyID() {
        return this.keyID;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public String getProtectionType() {
        return this.protectionType;
    }

    public String getSecretData() {
        return this.secretData;
    }

    public Collection<String> getStrings() {
        return new ArrayList<String>(this.strings);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.insert(0, Utils.LINE_SEPARATOR + prefix + " Encryption:" + Utils.LINE_SEPARATOR);
        result.append(prefix).append("\t|->keyID ").append(this.keyID).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("\t|->secretData ").append(this.secretData).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("\t|->protectionType ").append(this.protectionType).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("\t|->licenseURL ").append(this.licenseURL).append(Utils.LINE_SEPARATOR);
        this.strings.iterator();
        for (String string : this.strings) {
            result.append(prefix).append("   |->").append(string).append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public void setKeyID(String toAdd) {
        this.keyID = toAdd;
    }

    public void setLicenseURL(String toAdd) {
        this.licenseURL = toAdd;
    }

    public void setProtectionType(String toAdd) {
        this.protectionType = toAdd;
    }

    public void setSecretData(String toAdd) {
        this.secretData = toAdd;
    }
}

