/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.mixin;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.gregtao.concerto.network.ServerMusicNetworkHandler;
import top.gregtao.concerto.network.room.MusicRoom;
import top.gregtao.concerto.network.room.ServerMusicAgent;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Inject(at={@At(value="TAIL")}, method={"onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;)V"})
    public void onPlayerConnectInject(class_2535 connection, class_3222 player, CallbackInfo ci) {
        Executor delayedExecutor = CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS);
        CompletableFuture.runAsync(() -> ServerMusicNetworkHandler.playerJoinHandshake(player), delayedExecutor);
    }

    @Inject(at={@At(value="HEAD")}, method={"remove(Lnet/minecraft/server/network/ServerPlayerEntity;)V"})
    public void removeInject(class_3222 player, CallbackInfo ci) {
        ArrayList<UUID> removeList = new ArrayList<UUID>();
        for (Map.Entry<UUID, MusicRoom> entry : MusicRoom.ROOMS.entrySet()) {
            if (entry.getValue().owner.equals(player.method_5477().getString())) {
                removeList.add(entry.getKey());
                try {
                    entry.getValue().serverOnRemove(player.method_5477().getString(), player.field_13995);
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!entry.getValue().members.containsKey(player.method_5477().getString())) continue;
            entry.getValue().serverOnQuit(player.method_5477().getString(), player.field_13995);
            break;
        }
        removeList.forEach(MusicRoom.ROOMS::remove);
        if (ServerMusicAgent.INSTANCE.isMember(player)) {
            ServerMusicAgent.INSTANCE.playerQuit(player);
        }
    }
}

