/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import top.gregtao.concerto.api.CacheableMusic;
import top.gregtao.concerto.api.DynamicPath;
import top.gregtao.concerto.api.JsonParser;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.api.MusicSourceNotFoundException;
import top.gregtao.concerto.enums.Sources;
import top.gregtao.concerto.http.HttpURLInputStream;
import top.gregtao.concerto.http.kugou.KuGouLyricsUtil;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.http.kugou.KuGouMusicApiCrypto;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.lyrics.DefaultFormatLyrics;
import top.gregtao.concerto.music.lyrics.Lyrics;
import top.gregtao.concerto.music.meta.music.BasicMusicMetaData;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.music.meta.music.UnknownMusicMeta;
import top.gregtao.concerto.util.FileUtil;
import top.gregtao.concerto.util.Optionals;
import top.gregtao.concerto.util.Pair;

public class KuGouMusic
extends Music
implements CacheableMusic,
DynamicPath {
    private final String albumAudioId;
    private String hash;
    private String rawPath;
    private String rawLyrics;
    private String rawSubLyrics;
    private String format;
    private final Map<Level, String> hashMap = new HashMap<Level, String>();

    public KuGouMusic(String id, String hash, boolean isEncodeAlbumAudioId) {
        this.albumAudioId = isEncodeAlbumAudioId ? this.toAlbumAudioId(id) : id;
        this.hash = hash;
    }

    public KuGouMusic(String id, boolean isEncodeAlbumAudioId) {
        this(id, "", isEncodeAlbumAudioId);
    }

    public KuGouMusic(JsonObject object) {
        Optional<JsonObject> optional = Optional.ofNullable(object);
        this.albumAudioId = Optionals.firstOf(optional, json -> json.get("MixSongID"), json -> json.get("mixsongid")).map(JsonElement::getAsString).orElse("");
        this.hash = Optionals.firstOf(optional, json -> json.get("FileHash"), json -> json.get("hash")).map(JsonElement::getAsString).orElse("");
        this.setMusicMeta(KuGouMusic.parseMetaDataForSong(object));
    }

    public KuGouMusic(MusicMetaData metaData, String albumAudioId, String hash) {
        this.setMusicMeta(metaData);
        this.albumAudioId = albumAudioId;
        this.hash = hash;
    }

    public String getAlbumAudioId() {
        return this.albumAudioId;
    }

    public String getHash() {
        return this.hash;
    }

    public Map<Level, String> getHashMap() {
        if (this.hashMap.isEmpty()) {
            return this.updateHashMap();
        }
        return this.hashMap;
    }

    public Map<Level, String> updateHashMap() {
        Optional<JsonObject> optional = KuGouMusicApiClient.INSTANCE.getMusicHash(this.hash);
        optional.map(json -> json.getAsJsonArray("data")).map(dataArray -> !dataArray.isEmpty() ? dataArray.get(0).getAsJsonObject() : null).ifPresent(data -> {
            for (Level level : Level.values()) {
                JsonElement jsonElement = data.get(level.getKey());
                if (jsonElement == null || jsonElement.getAsString().isEmpty()) continue;
                this.hashMap.put(level, jsonElement.getAsString());
            }
        });
        return this.hashMap;
    }

    @Override
    public String getSuffix() {
        return this.getLastSuffix();
    }

    @Override
    public Music getMusic() {
        return this;
    }

    @Override
    public String getLastRawPath() {
        if (this.rawPath == null) {
            this.getRawPath();
        }
        return this.rawPath;
    }

    @Override
    public String updateRawPath() {
        return this.getRawPath();
    }

    @Override
    public String getLastSuffix() {
        if (this.format == null) {
            this.getRawPath();
        }
        return this.format;
    }

    @Override
    public String getLastLyrics() {
        if (this.rawLyrics == null) {
            this.getLyrics();
        }
        return this.rawLyrics;
    }

    @Override
    public Pair<Lyrics, Lyrics> getLyrics() {
        try {
            Optional<JsonObject> optional = KuGouMusicApiClient.INSTANCE.lyricSearch(this.hash);
            JsonArray jsonArray = optional.map(obj -> obj.getAsJsonArray("candidates")).orElse(new JsonArray());
            Pair<String, String> bestLyric = this.getBestLyric(jsonArray);
            Pair pair = KuGouMusicApiClient.INSTANCE.getLyric(bestLyric.getFirst(), bestLyric.getSecond()).map(KuGouMusicApiCrypto::decodeLyrics).map(KuGouLyricsUtil::krcToLrc).orElseThrow();
            this.rawLyrics = (String)pair.getFirst();
            this.rawSubLyrics = (String)pair.getSecond();
            return Pair.of(new DefaultFormatLyrics().load((String)pair.getFirst()), new DefaultFormatLyrics().load((String)pair.getSecond()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Pair<String, String> getBestLyric(JsonArray jsonArray) {
        if (jsonArray.isEmpty()) {
            return null;
        }
        for (JsonElement jsonElement : jsonArray) {
            Optional<JsonObject> object = Optional.of(jsonElement.getAsJsonObject());
            Optional<Integer> contentFormat = object.map(obj -> obj.get("content_format")).map(JsonElement::getAsInt);
            if (!contentFormat.isPresent() || contentFormat.get() <= 1) continue;
            String id = object.map(obj -> obj.get("id")).map(JsonElement::getAsString).orElseThrow();
            String accessKey = object.map(obj -> obj.get("accesskey")).map(JsonElement::getAsString).orElseThrow();
            return Pair.of(id, accessKey);
        }
        Optional<JsonObject> object = Optional.ofNullable(jsonArray.get(0)).map(JsonElement::getAsJsonObject);
        String id = object.map(obj -> obj.get("id")).map(JsonElement::getAsString).orElseThrow();
        String accessKey = object.map(obj -> obj.get("accesskey")).map(JsonElement::getAsString).orElseThrow();
        return Pair.of(id, accessKey);
    }

    @Override
    public String getLastSubLyrics() {
        return this.rawSubLyrics;
    }

    @Override
    public JsonParser<Music> getJsonParser() {
        return MusicJsonParsers.KUGOU_MUSIC;
    }

    @Override
    public InputStream getMusicSource() throws MusicSourceNotFoundException {
        try {
            return FileUtil.createBuffered(new HttpURLInputStream(URI.create(this.getRawPath()).toURL(), this::getRawPath));
        }
        catch (Exception e) {
            throw new MusicSourceNotFoundException(e);
        }
    }

    @Override
    public String getLink() {
        return "https://www.kugou.com/";
    }

    @Override
    public void load() {
        Optional<JsonObject> musicDetail = KuGouMusicApiClient.INSTANCE.getMusicDetail(this.albumAudioId, "album_info,base,authors.base,audio_info");
        try {
            musicDetail.map(json -> json.getAsJsonObject("audio_info")).map(audioInfo -> audioInfo.get("hash")).map(JsonElement::getAsString).ifPresent(hash -> {
                this.hash = hash;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMusicMeta(musicDetail.map(KuGouMusic::parseMetaData).orElseGet(() -> new UnknownMusicMeta(Sources.KUGOU_MUSIC.getName().getString())));
        super.load();
    }

    public static MusicMetaData parseMetaData(JsonObject object) {
        Optional<JsonObject> optional = Optional.of(object);
        try {
            String name = Optionals.firstOf(optional.map(json -> json.getAsJsonObject("base")), json -> json.get("songname"), json -> json.get("audio_name")).map(JsonElement::getAsString).orElseThrow();
            Long duration = Optionals.firstOf(optional.map(json -> json.getAsJsonObject("audio_info")), json -> json.get("timelength"), json -> json.get("duration")).map(JsonElement::getAsLong).orElseThrow();
            List authorList = (List)Optionals.flatFirstOf(optional, KuGouMusic::getAuthorsList, KuGouMusic::getAuthorsListFromBase).orElseThrow();
            String headPic = optional.map(json -> json.getAsJsonObject("album_info")).map(albumInfo -> albumInfo.get("cover")).map(coverElement -> {
                if (coverElement.isJsonNull()) {
                    return "";
                }
                String cover = coverElement.getAsString();
                return cover.replace("{size}", "512");
            }).orElseThrow();
            return new BasicMusicMetaData(String.join((CharSequence)", ", authorList), name, Sources.KUGOU_MUSIC.getName().getString(), duration, headPic);
        }
        catch (Exception e) {
            return new UnknownMusicMeta(Sources.KUGOU_MUSIC.getName().getString());
        }
    }

    private static Optional<List<String>> getAuthorsList(JsonObject jsonObject) {
        return Optional.ofNullable(jsonObject).map(json -> json.getAsJsonArray("authors")).map(arr -> StreamSupport.stream(arr.spliterator(), false).map(JsonElement::getAsJsonObject).map(Optional::of).map(authorOpt -> Optionals.flatFirstOf(authorOpt, json -> Optional.ofNullable(json.getAsJsonObject("base")), Optional::ofNullable).map(base -> base.get("author_name"))).filter(nameElementOpt -> nameElementOpt.isPresent() && !((JsonElement)nameElementOpt.get()).isJsonNull()).map(nameElementOpt -> ((JsonElement)nameElementOpt.get()).getAsString()).collect(Collectors.toList()));
    }

    public static Optional<List<String>> getAuthorsListFromBase(JsonObject jsonObject) {
        return Optional.ofNullable(jsonObject).map(json -> json.getAsJsonObject("base")).map(base -> base.get("author_name")).map(JsonElement::getAsString).map(names -> Arrays.asList(names.split("\u3001")));
    }

    public static MusicMetaData parseMetaDataForSong(JsonObject object) {
        Optional<JsonObject> optional = Optional.ofNullable(object);
        try {
            long duration = (Long)Optionals.flatFirstOf(optional, json -> Optional.ofNullable(json.get("Duration")).map(JsonElement::getAsLong).map(l -> l * 1000L), json -> Optional.ofNullable(json.get("timelen")).map(JsonElement::getAsLong)).orElseThrow();
            List authorsList = Optionals.firstOf(optional, json -> json.get("Singers"), json -> json.get("singerinfo")).map(JsonElement::getAsJsonArray).map(arr -> StreamSupport.stream(arr.spliterator(), false).map(JsonElement::getAsJsonObject).map(json -> json.get("name")).filter(Objects::nonNull).map(JsonElement::getAsString).collect(Collectors.toList())).orElseThrow();
            String headPic = Optionals.firstOf(optional, json -> json.get("Image"), json -> json.get("cover")).map(JsonElement::getAsString).map(pic -> pic.replace("{size}", "512")).orElseThrow();
            String title = Optionals.firstOf(optional, json -> json.get("FileName"), json -> json.get("name")).map(JsonElement::getAsString).map(fullName -> fullName.replace(String.join((CharSequence)"\u3001", authorsList) + " - ", "")).orElseThrow();
            return new BasicMusicMetaData(String.join((CharSequence)", ", authorsList), title, Sources.KUGOU_MUSIC.getName().getString(), duration, headPic);
        }
        catch (Exception e) {
            return new UnknownMusicMeta(Sources.KUGOU_MUSIC.getName().getString());
        }
    }

    public String getRawPath() {
        String topHash = this.getTopHash();
        Optional<String> topMusicLink = KuGouMusicApiClient.INSTANCE.getMusicLink(topHash, true);
        if (topMusicLink.isPresent()) {
            this.rawPath = topMusicLink.get();
            this.format = FileUtil.getSuffix(URI.create(this.rawPath).getPath());
        } else {
            this.rawPath = null;
            this.format = null;
        }
        return this.rawPath;
    }

    public String toAlbumAudioId(String encodeAlbumAudioId) {
        if (encodeAlbumAudioId == null || encodeAlbumAudioId.length() < 3) {
            throw new IllegalArgumentException("Invalid encodeAlbumAudioId");
        }
        encodeAlbumAudioId = encodeAlbumAudioId.substring(0, encodeAlbumAudioId.length() - 2);
        long num = Long.parseLong(encodeAlbumAudioId, 36);
        return String.valueOf(num);
    }

    public String getTopHash() {
        return (String)this.getHashMap().entrySet().stream().min(Map.Entry.comparingByKey((a, b) -> Integer.compare(b.getRank(), a.getRank()))).orElseGet(() -> Map.entry(Level.STANDARD, this.hash)).getValue();
    }

    public static enum Level {
        STANDARD(0, "hash_128"),
        HIGH(1, "hash_320"),
        LOSSLESS(2, "hash_flac"),
        HIRES(3, "hash_high");

        private final int rank;
        private final String key;

        private Level(int rank, String key) {
            this.rank = rank;
            this.key = key;
        }

        public int getRank() {
            return this.rank;
        }

        public String getKey() {
            return this.key;
        }
    }
}

