/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music.lyrics;

import java.util.function.Consumer;
import top.gregtao.concerto.music.MusicTimestamp;
import top.gregtao.concerto.music.lyrics.Lyrics;
import top.gregtao.concerto.util.MathUtil;
import top.gregtao.concerto.util.Pair;
import top.gregtao.concerto.util.TextUtil;

public class DefaultFormatLyrics
extends Lyrics {
    @Override
    public void parse(String raw) {
        String[] lines;
        raw = TextUtil.trimSurrounding(raw, "[", "]");
        for (String line : lines = raw.split("(\n|\r|\r\n)")) {
            if ((line = line.trim()).isEmpty() || !line.matches(MusicTimestamp.FORMAT_REGEX) || line.endsWith("]")) continue;
            String[] args = line.split("]");
            for (int index = 0; index < args.length - 1; ++index) {
                String[] timesArr = args[index].substring(1).split(":");
                if (timesArr.length < 2) continue;
                String[] secondsArr = timesArr[1].split("\\.");
                String lyric = args[args.length - 1].trim();
                if (lyric.isEmpty() || lyric.startsWith("//")) continue;
                lyric = lyric.replaceAll(MusicTimestamp.INLINE_REGEX, "");
                if (secondsArr.length == 2) {
                    long milli = MathUtil.parseIntOrElse(secondsArr[1], 0);
                    int place = (int)(1000.0 / Math.pow(10.0, secondsArr[1].trim().length()));
                    this.addLine(MusicTimestamp.of(MathUtil.parseIntOrElse(timesArr[0], 0), MathUtil.parseIntOrElse(secondsArr[0], 0), (int)(milli * (long)place)), lyric);
                    continue;
                }
                this.addLine(MusicTimestamp.of(MathUtil.parseIntOrElse(timesArr[0], 0), MathUtil.parseIntOrElse(secondsArr[0], 0)), lyric);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.getLyricBody().forEach((Consumer<Pair<MusicTimestamp, String>>)((Consumer<Pair>)pair -> builder.append("[").append(((MusicTimestamp)pair.getFirst()).toString()).append("] ").append((String)pair.getSecond()).append("\n")));
        return builder.toString();
    }
}

