/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.network;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.server.MinecraftServer;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.api.UnsafeMusicException;
import top.gregtao.concerto.enums.Sources;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.util.JsonUtil;

public class MusicDataPacket {
    public static List<String> ALLOWED_SOURCES = List.of(Sources.NETEASE_CLOUD.method_15434(), Sources.QQ_MUSIC.method_15434(), Sources.KUGOU_MUSIC.method_15434());
    public final Music music;
    public String from = null;
    public String to;
    public boolean isS2C;
    public MinecraftServer server = null;

    public static boolean isMusicSafe(Music music) {
        return ALLOWED_SOURCES.contains(music.getJsonParser().name());
    }

    public MusicDataPacket(Music music, String target, boolean isS2C) throws UnsafeMusicException {
        if (!ALLOWED_SOURCES.contains(music.getJsonParser().name())) {
            throw new UnsafeMusicException("Not supported");
        }
        this.music = music;
        this.isS2C = isS2C;
        if (isS2C) {
            this.from = target;
        } else {
            this.to = target;
        }
    }

    public class_2540 toPacket(String senderName) {
        if (this.isS2C) {
            throw new RuntimeException("Only for C2S packet");
        }
        class_2540 buf = PacketByteBufs.create();
        JsonObject object = MusicJsonParsers.to(this.music);
        if (object != null) {
            JsonObject metaObject = object.getAsJsonObject("meta");
            String src = metaObject.get("src").getAsString();
            metaObject.addProperty("src", src + ", " + senderName);
            buf.method_10814(String.valueOf(object) + "\n" + (this.isS2C ? this.from : this.to));
        }
        return buf;
    }

    public class_2540 toPacket() {
        class_2540 buf = PacketByteBufs.create();
        JsonObject object = MusicJsonParsers.to(this.music);
        if (object != null) {
            buf.method_10814(String.valueOf(object) + "\n" + (this.isS2C ? this.from : this.to));
        }
        return buf;
    }

    public static MusicDataPacket fromPacket(class_2540 buf, boolean isS2C) throws UnsafeMusicException {
        try {
            String[] strings = buf.method_10800(Short.MAX_VALUE).split("\n");
            if (strings.length < 2) {
                return null;
            }
            return new MusicDataPacket(Objects.requireNonNull(MusicJsonParsers.from(JsonUtil.from(strings[0]))), strings[1], isS2C);
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

