/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.screen.kugou;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.WithMetaData;
import top.gregtao.concerto.enums.SearchType;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.list.KuGouMusicPlaylist;
import top.gregtao.concerto.music.list.Playlist;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.screen.MusicInfoScreen;
import top.gregtao.concerto.screen.PageScreen;
import top.gregtao.concerto.screen.PlaylistPreviewScreen;
import top.gregtao.concerto.screen.widget.ConcertoListWidget;
import top.gregtao.concerto.screen.widget.MetadataListWidget;
import top.gregtao.concerto.util.ConcertoRunner;

public class KuGouMusicSearchScreen
extends PageScreen {
    public static String DEFAULT_KEYWORD = "";
    private MetadataListWidget<Music> musicList;
    private MetadataListWidget<KuGouMusicPlaylist> playlistList;
    private MetadataListWidget<KuGouMusicPlaylist> albumList;
    private Map<SearchType, ConcertoListWidget<?>> listWidgetsMap = new HashMap();
    protected class_342 searchBox;
    private class_4185 infoButton;
    private class_4185 searchButton;
    private class_4185 playButton;
    private class_4185 addButton;
    private class_5676<SearchType> typeButton;
    private SearchType searchType = SearchType.MUSIC;

    private <T extends WithMetaData> MetadataListWidget<T> initListsWidget() {
        return new MetadataListWidget<T>(this.field_22789, this.field_22790, 45, this.field_22790 - 35, 18){

            @Override
            public void onDoubleClicked(ConcertoListWidget.Entry entry) {
                try {
                    switch (KuGouMusicSearchScreen.this.searchType) {
                        case MUSIC: {
                            MusicPlayer.INSTANCE.addMusicHere((Music)entry.item, true);
                            break;
                        }
                        case PLAYLIST: 
                        case ALBUM: {
                            class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)KuGouMusicSearchScreen.this));
                        }
                    }
                }
                catch (ClassCastException e) {
                    ConcertoClient.LOGGER.error(e.getMessage());
                }
            }
        };
    }

    public KuGouMusicSearchScreen(class_437 parent) {
        super((class_2561)new class_2588("concerto.screen.search.kugou"), parent);
    }

    private void search(String keyword, int page) {
        DEFAULT_KEYWORD = keyword;
        if (keyword.isEmpty()) {
            return;
        }
        ConcertoRunner.run(() -> {
            switch (this.searchType) {
                case MUSIC: {
                    this.musicList.reset(KuGouMusicApiClient.INSTANCE.searchMusic(keyword, page), null);
                    break;
                }
                case PLAYLIST: {
                    this.playlistList.reset(KuGouMusicApiClient.INSTANCE.searchPlaylist(keyword, page), null);
                    break;
                }
                case ALBUM: {
                    this.albumList.reset(KuGouMusicApiClient.INSTANCE.searchAlbum(keyword, page), null);
                }
            }
            this.listWidgetsMap.get(this.searchType).method_25307(0.0);
        });
    }

    private void toggleSearch() {
        this.page = 0;
        this.search(this.searchBox.method_1882(), 1);
    }

    private void updateSearchType(SearchType type) {
        try {
            this.method_37066((class_364)this.listWidgetsMap.get(this.searchType));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.method_37063((class_364)this.listWidgetsMap.get(type));
        this.refreshDrawable();
        this.searchType = type;
        this.infoButton.field_22763 = type == SearchType.MUSIC;
        this.toggleSearch();
    }

    @Override
    public void refreshDrawable() {
        try {
            super.refreshDrawable();
            this.method_37066((class_364)this.searchBox);
            this.method_37063((class_364)this.searchBox);
            this.method_25429((class_364)this.searchBox);
            this.method_37066((class_364)this.infoButton);
            this.method_37063((class_364)this.infoButton);
            this.method_37066((class_364)this.searchButton);
            this.method_37063((class_364)this.searchButton);
            this.method_37066((class_364)this.typeButton);
            this.method_37063((class_364)this.typeButton);
            this.method_37066((class_364)this.playButton);
            this.method_37063((class_364)this.playButton);
            this.method_37066((class_364)this.addButton);
            this.method_37063((class_364)this.addButton);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void onPageTurned(int page) {
        this.search(this.searchBox.method_1882(), page + 1);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.musicList = this.initListsWidget();
        this.playlistList = this.initListsWidget();
        this.albumList = this.initListsWidget();
        this.listWidgetsMap = Map.of(SearchType.MUSIC, this.musicList, SearchType.PLAYLIST, this.playlistList, SearchType.ALBUM, this.albumList);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 155, 17, 200, 20, this.searchBox, (class_2561)new class_2588("concerto.screen.search"));
        this.searchBox.method_1852(DEFAULT_KEYWORD);
        this.infoButton = new class_4185(this.field_22789 / 2 + 120, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.info"), button -> {
            ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
            if (entry != null) {
                class_310.method_1551().method_1507((class_437)new MusicInfoScreen((Music)entry.item, (class_437)this));
            }
        });
        this.searchButton = new class_4185(this.field_22789 / 2 + 50, 17, 52, 20, (class_2561)new class_2588("concerto.screen.search"), button -> this.toggleSearch());
        this.typeButton = class_5676.method_32606(SearchType::getName).method_32624((Object[])SearchType.values()).method_32619((Object)this.searchType).method_32617(this.field_22789 / 2 + 105, 17, 65, 20, (class_2561)new class_2588("concerto.search_type"), (widget, type) -> this.updateSearchType((SearchType)type));
        this.playButton = new class_4185(this.field_22789 / 2 + 65, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.play"), button -> {
            switch (this.searchType) {
                case MUSIC: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusicHere((Music)entry.item, true);
                    }
                }
                case PLAYLIST: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.playlistList.method_25334();
                    if (entry != null) {
                        class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)this));
                    }
                }
                case ALBUM: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.albumList.method_25334();
                    if (entry == null) break;
                    class_310.method_1551().method_1507((class_437)new PlaylistPreviewScreen((Playlist)entry.item, (class_437)this));
                }
            }
        });
        this.addButton = new class_4185(this.field_22789 / 2 + 10, this.field_22790 - 30, 50, 20, (class_2561)new class_2588("concerto.screen.add"), button -> {
            switch (this.searchType) {
                case MUSIC: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.musicList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusic((Music)entry.item);
                    }
                }
                case PLAYLIST: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.playlistList.method_25334();
                    if (entry != null) {
                        MusicPlayer.INSTANCE.addMusic(() -> ((KuGouMusicPlaylist)entry.item).getList(), () -> {});
                    }
                }
                case ALBUM: {
                    ConcertoListWidget.Entry entry = (ConcertoListWidget.Entry)this.albumList.method_25334();
                    if (entry == null) break;
                    MusicPlayer.INSTANCE.addMusic(() -> ((KuGouMusicPlaylist)entry.item).getList(), () -> {});
                }
            }
        });
        this.updateSearchType(this.searchType);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 && this.searchBox.method_20315()) {
            this.toggleSearch();
            return true;
        }
        return this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.searchBox.method_25400(chr, modifiers);
    }
}

