/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.FrameListener;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.apps.Player;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.io.RandomFileInputStream;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.SeekPoint;
import org.kc7bfi.jflac.metadata.SeekTable;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.util.ByteData;

public class SeekTablePlayer
implements PCMProcessor,
FrameListener {
    private AudioFormat fmt;
    private DataLine.Info info;
    private SourceDataLine line;
    private SeekTable seekTable;

    public void play(String inFileName, int fromSeekPoint, int toSeekPoint) throws IOException, LineUnavailableException {
        System.out.println("Play [" + inFileName + "]");
        RandomFileInputStream is = new RandomFileInputStream(inFileName);
        FLACDecoder decoder = new FLACDecoder(is);
        decoder.addPCMProcessor(this);
        decoder.addFrameListener(this);
        decoder.readMetadata();
        if (this.seekTable == null) {
            System.out.println("Missing SeekTable!");
            return;
        }
        SeekPoint from = this.seekTable.getSeekPoint(fromSeekPoint);
        SeekPoint to = null;
        if (toSeekPoint + 1 < this.seekTable.numberOfPoints()) {
            to = this.seekTable.getSeekPoint(toSeekPoint + 1);
        }
        System.out.println("Seek From: " + from);
        System.out.println("Seek To  : " + to);
        decoder.decode(from, to);
        this.line.drain();
        this.line.close();
    }

    @Override
    public void processStreamInfo(StreamInfo streamInfo) {
        try {
            this.fmt = Player.getAudioFormat(streamInfo);
            this.info = new DataLine.Info(SourceDataLine.class, this.fmt, -1);
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            this.line.open(this.fmt, -1);
            this.line.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processPCM(ByteData pcm) {
        this.line.write(pcm.getData(), 0, pcm.getLen());
    }

    @Override
    public void processMetadata(Metadata metadata) {
        if (metadata instanceof SeekTable) {
            this.seekTable = (SeekTable)metadata;
        }
    }

    @Override
    public void processFrame(Frame frame) {
    }

    @Override
    public void processError(String msg) {
        System.out.println("FLAC Error: " + msg);
    }

    public static void main(String[] args) {
        String flacFile = args[0];
        int fromSeekPoint = Integer.parseInt(args[1]);
        int toSeekPoint = Integer.parseInt(args[2]);
        try {
            SeekTablePlayer player = new SeekTablePlayer();
            player.play(flacFile, fromSeekPoint, toSeekPoint);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

