/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class PCM2PCMConversionProvider
extends TSimpleFormatConversionProvider {
    private static final boolean ONLY_FLOAT_CONVERSION = false;
    public static final AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    public static final AudioFormat.Encoding PCM_UNSIGNED = AudioFormat.Encoding.PCM_UNSIGNED;
    private static final int ALL = -1;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true)};
    private static final int UNSIGNED8 = 1;
    private static final int SIGNED8 = 2;
    private static final int BIG_ENDIAN16 = 3;
    private static final int LITTLE_ENDIAN16 = 4;
    private static final int BIG_ENDIAN24 = 5;
    private static final int LITTLE_ENDIAN24 = 6;
    private static final int BIG_ENDIAN32 = 7;
    private static final int LITTLE_ENDIAN32 = 8;
    private static final int CONVERT_NOT_POSSIBLE = 0;
    private static final int CONVERT_SIGN = 1;
    private static final int CONVERT_BYTE_ORDER16 = 2;
    private static final int CONVERT_BYTE_ORDER24 = 3;
    private static final int CONVERT_BYTE_ORDER32 = 4;
    private static final int CONVERT_16LTO8S = 5;
    private static final int CONVERT_16LTO8U = 6;
    private static final int CONVERT_16BTO8S = 7;
    private static final int CONVERT_16BTO8U = 8;
    private static final int CONVERT_8STO16L = 9;
    private static final int CONVERT_8STO16B = 10;
    private static final int CONVERT_8UTO16L = 11;
    private static final int CONVERT_8UTO16B = 12;
    private static final int CONVERT_ONLY_EXPAND_CHANNELS = 13;
    private static final int CONVERT_FLOAT = 100;
    private static final int CONVERT_NONE = 101;

    public PCM2PCMConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if (PCM2PCMConversionProvider.doMatch(targetFormat.getFrameRate(), sourceFormat.getFrameRate()) && PCM2PCMConversionProvider.doMatch(targetFormat.getSampleRate(), sourceFormat.getSampleRate())) {
            targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat);
            int sourceType = this.getFormatType(sourceFormat);
            int targetType = this.getFormatType(targetFormat);
            int conversionType = this.getConversionType(sourceType, sourceFormat.getChannels(), targetType, targetFormat.getChannels());
            if (TDebug.TraceAudioConverter) {
                TDebug.out("PCM2PCM: sourceType=" + PCM2PCMConversionProvider.formatType2Str(sourceType) + ", " + sourceFormat.getChannels() + "ch" + " targetType=" + PCM2PCMConversionProvider.formatType2Str(targetType) + ", " + targetFormat.getChannels() + "ch" + " conversionType=" + PCM2PCMConversionProvider.conversionType2Str(conversionType));
            }
            if (conversionType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            return new PCM2PCMStream(sourceStream, targetFormat, conversionType);
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">PCM2PCMFormatConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetEncoding);
        }
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            ArraySet<AudioFormat> result = new ArraySet<AudioFormat>();
            for (AudioFormat targetFormat : this.getCollectionTargetFormats()) {
                if (!this.isConversionSupported(targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat), sourceFormat)) continue;
                result.add(targetFormat);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + result.size() + " matching formats.");
            }
            return result.toArray(EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        boolean res;
        boolean bl = res = AudioFormats.matches(sourceFormat, targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat)) || PCM2PCMConversionProvider.doMatch(targetFormat.getFrameRate(), sourceFormat.getFrameRate()) && PCM2PCMConversionProvider.doMatch(targetFormat.getSampleRate(), sourceFormat.getSampleRate()) && this.getConversionType(this.getFormatType(sourceFormat), sourceFormat.getChannels(), this.getFormatType(targetFormat), targetFormat.getChannels()) != 0;
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">PCM2PCM: isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetFormat);
            TDebug.out("< result : " + res);
        }
        return res;
    }

    private int getFormatType(AudioFormat af) {
        int result = 0;
        AudioFormat.Encoding encoding = af.getEncoding();
        boolean bigEndian = af.isBigEndian();
        int ssib = af.getSampleSizeInBits();
        if (encoding.equals(PCM_SIGNED)) {
            if (ssib == 32) {
                result = bigEndian ? 7 : 8;
            } else if (ssib == 24) {
                result = bigEndian ? 5 : 6;
            } else if (ssib == 16) {
                result = bigEndian ? 3 : 4;
            } else if (ssib == 8) {
                result = 2;
            }
        } else if (encoding.equals(PCM_UNSIGNED) && ssib == 8) {
            result = 1;
        }
        return result;
    }

    private int getConversionType(int sourceType, int sourceChannels, int targetType, int targetChannels) {
        if (sourceType == 0 || targetType == 0 || sourceChannels != 1 && targetChannels != 1 && targetChannels != sourceChannels) {
            return 0;
        }
        if (sourceType == targetType) {
            if (sourceChannels == targetChannels) {
                return 101;
            }
            if (sourceChannels == 1 && targetChannels > 1) {
                return 13;
            }
        }
        if (sourceChannels == 1 && targetChannels >= 1 || sourceChannels == targetChannels) {
            if (sourceType == 1 && targetType == 2 || sourceType == 2 && targetType == 1) {
                return 1;
            }
            if (sourceType == 3 && targetType == 4 || sourceType == 4 && targetType == 3) {
                return 2;
            }
            if (sourceType == 5 && targetType == 6 || sourceType == 6 && targetType == 5) {
                return 3;
            }
            if (sourceType == 7 && targetType == 8 || sourceType == 8 && targetType == 7) {
                return 4;
            }
            if (sourceType == 2 && targetType == 4) {
                return 9;
            }
            if (sourceType == 2 && targetType == 3) {
                return 10;
            }
            if (sourceType == 1 && targetType == 4) {
                return 11;
            }
            if (sourceType == 1 && targetType == 3) {
                return 12;
            }
        }
        return 100;
    }

    private static String formatType2Str(int formatType) {
        switch (formatType) {
            case 0: {
                return "unsupported";
            }
            case 1: {
                return "UNSIGNED8";
            }
            case 2: {
                return "SIGNED8";
            }
            case 3: {
                return "BIG_ENDIAN16";
            }
            case 4: {
                return "LITTLE_ENDIAN16";
            }
            case 5: {
                return "BIG_ENDIAN24";
            }
            case 6: {
                return "LITTLE_ENDIAN24";
            }
            case 7: {
                return "BIG_ENDIAN32";
            }
            case 8: {
                return "LITTLE_ENDIAN32";
            }
        }
        return "unknown";
    }

    protected static String conversionType2Str(int conversionType) {
        switch (conversionType) {
            case 0: {
                return "CONVERT_NOT_POSSIBLE";
            }
            case 1: {
                return "CONVERT_SIGN";
            }
            case 2: {
                return "CONVERT_BYTE_ORDER16";
            }
            case 3: {
                return "CONVERT_BYTE_ORDER24";
            }
            case 4: {
                return "CONVERT_BYTE_ORDER32";
            }
            case 5: {
                return "CONVERT_16LTO8S";
            }
            case 6: {
                return "CONVERT_16LTO8U";
            }
            case 7: {
                return "CONVERT_16BTO8S";
            }
            case 8: {
                return "CONVERT_16BTO8U";
            }
            case 9: {
                return "CONVERT_8STO16L";
            }
            case 10: {
                return "CONVERT_8STO16B";
            }
            case 11: {
                return "CONVERT_8UTO16L";
            }
            case 12: {
                return "CONVERT_8UTO16B";
            }
            case 13: {
                return "CONVERT_ONLY_EXPAND_CHANNELS";
            }
            case 100: {
                return "CONVERT_FLOAT";
            }
            case 101: {
                return "CONVERT_NONE";
            }
        }
        return "unknown";
    }

    class PCM2PCMStream
    extends TSynchronousFilteredAudioInputStream {
        private int conversionType;
        private boolean needExpandChannels;
        private boolean needMixDown;
        private AudioFormat intermediateFloatBufferFormat;
        private FloatSampleBuffer floatBuffer;

        public PCM2PCMStream(AudioInputStream sourceStream, AudioFormat targetFormat, int conversionType) {
            super(sourceStream, new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), AudioUtils.getFrameSize(targetFormat.getChannels(), targetFormat.getSampleSizeInBits()), sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian(), targetFormat.properties()));
            this.floatBuffer = null;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("PCM2PCMStream: constructor. ConversionType=" + PCM2PCMConversionProvider.conversionType2Str(conversionType));
            }
            this.conversionType = conversionType;
            this.needExpandChannels = sourceStream.getFormat().getChannels() < targetFormat.getChannels();
            boolean bl = this.needMixDown = sourceStream.getFormat().getChannels() > targetFormat.getChannels();
            if (this.needMixDown && conversionType != 100) {
                throw new IllegalArgumentException("PCM2PCMStream: MixDown only possible with CONVERT_FLOAT");
            }
            if (this.needMixDown && targetFormat.getChannels() != 1) {
                throw new IllegalArgumentException("PCM2PCMStream: MixDown only possible with target channel count=1");
            }
            if (this.needExpandChannels && sourceStream.getFormat().getChannels() != 1) {
                throw new IllegalArgumentException("PCM2PCMStream: Expanding channels only possible with source channel count=1");
            }
            if (conversionType == 100) {
                int floatChannels = this.needExpandChannels ? 1 : targetFormat.getChannels();
                this.intermediateFloatBufferFormat = new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), floatChannels, AudioUtils.getFrameSize(floatChannels, targetFormat.getSampleSizeInBits()), sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian(), targetFormat.properties());
                this.enableConvertInPlace();
            }
            if (!(this.needExpandChannels || conversionType != 1 && conversionType != 2 && conversionType != 3 && conversionType != 4)) {
                this.enableConvertInPlace();
            }
            this.enableFloatConversion();
        }

        private final void do16BTO8S(byte[] inBuffer, int inCounter, byte[] outBuffer, int outByteOffset, int sampleCount) {
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = inBuffer[inCounter++];
                --sampleCount;
                ++inCounter;
            }
        }

        private final void do16BTO8U(byte[] inBuffer, int inCounter, byte[] outBuffer, int outByteOffset, int sampleCount) {
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = (byte)(inBuffer[inCounter++] + 128);
                --sampleCount;
                ++inCounter;
            }
        }

        private final void do8STO16L(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int sampleCount) {
            int inCounter = 0;
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = 0;
                outBuffer[outByteOffset++] = inBuffer[inCounter++];
                --sampleCount;
            }
        }

        private final void do8UTO16L(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int sampleCount) {
            int inCounter = 0;
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = 0;
                outBuffer[outByteOffset++] = (byte)(inBuffer[inCounter++] + 128);
                --sampleCount;
            }
        }

        private final void do8STO16B(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int sampleCount) {
            int inCounter = 0;
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = inBuffer[inCounter++];
                outBuffer[outByteOffset++] = 0;
                --sampleCount;
            }
        }

        private final void do8UTO16B(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int sampleCount) {
            int inCounter = 0;
            while (sampleCount > 0) {
                outBuffer[outByteOffset++] = (byte)(inBuffer[inCounter++] + 128);
                outBuffer[outByteOffset++] = 0;
                --sampleCount;
            }
        }

        private final void expandChannels(byte[] buffer, int offset, int frameCount, int bytesPerFrame, int channels) {
            int inOffset = offset + bytesPerFrame * frameCount;
            int outOffset = offset + bytesPerFrame * channels * frameCount;
            switch (bytesPerFrame) {
                case 1: {
                    if (channels == 2) {
                        while (frameCount > 0) {
                            buffer[--outOffset] = buffer[--inOffset];
                            buffer[--outOffset] = buffer[inOffset];
                            --frameCount;
                        }
                    } else {
                        while (frameCount > 0) {
                            --inOffset;
                            for (int channel = 0; channel < channels; ++channel) {
                                buffer[--outOffset] = buffer[inOffset];
                            }
                            --frameCount;
                        }
                    }
                    break;
                }
                case 2: {
                    if (channels == 2) {
                        while (frameCount > 0) {
                            buffer[--outOffset] = buffer[--inOffset];
                            buffer[--outOffset] = buffer[inOffset - 1];
                            buffer[--outOffset] = buffer[inOffset];
                            buffer[--outOffset] = buffer[--inOffset];
                            --frameCount;
                        }
                    } else {
                        while (frameCount > 0) {
                            --inOffset;
                            for (int channel = 0; channel < channels; ++channel) {
                                buffer[--outOffset] = buffer[inOffset];
                                buffer[--outOffset] = buffer[inOffset - 1];
                            }
                            --inOffset;
                            --frameCount;
                        }
                    }
                    break;
                }
                default: {
                    while (frameCount > 0) {
                        for (int channel = 0; channel < channels; ++channel) {
                            for (int by = 1; by <= bytesPerFrame; ++by) {
                                buffer[--outOffset] = buffer[inOffset - by];
                            }
                        }
                        inOffset -= bytesPerFrame;
                        --frameCount;
                    }
                    break block0;
                }
            }
        }

        private final void doFloatConversion(FloatSampleBuffer buffer) {
            this.doFloatConversion(buffer, this.needExpandChannels);
        }

        private final void doFloatConversion(FloatSampleBuffer buffer, boolean expandChannels) {
            if (this.needMixDown) {
                buffer.mixDownChannels();
            }
            if (expandChannels) {
                buffer.expandChannel(this.getFormat().getChannels());
            }
        }

        private final void doFloatConversion(byte[] inBuffer, int inByteOffset, byte[] outBuffer, int outByteOffset, int sampleCount) {
            int byteCount = sampleCount * ((this.getOriginalStream().getFormat().getSampleSizeInBits() + 7) / 8);
            if (this.floatBuffer == null) {
                this.floatBuffer = new FloatSampleBuffer();
            }
            this.floatBuffer.initFromByteArray(inBuffer, inByteOffset, byteCount, this.getOriginalStream().getFormat());
            this.doFloatConversion(this.floatBuffer, false);
            this.floatBuffer.convertToByteArray(outBuffer, outByteOffset, this.intermediateFloatBufferFormat);
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getOriginalStream().getFormat().getChannels();
            switch (this.conversionType) {
                case 1: {
                    TConversionTool.convertSign8(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 2: {
                    TConversionTool.swapOrder16(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 3: {
                    TConversionTool.swapOrder24(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 4: {
                    TConversionTool.swapOrder32(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 5: {
                    this.do16BTO8S(inBuffer, 1, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 6: {
                    this.do16BTO8U(inBuffer, 1, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 7: {
                    this.do16BTO8S(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 8: {
                    this.do16BTO8U(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 9: {
                    this.do8STO16L(inBuffer, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 10: {
                    this.do8STO16B(inBuffer, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 11: {
                    this.do8UTO16L(inBuffer, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 12: {
                    this.do8UTO16B(inBuffer, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                case 13: {
                    System.arraycopy(inBuffer, 0, outBuffer, outByteOffset, inFrameCount * this.getOriginalStream().getFormat().getFrameSize());
                    break;
                }
                case 100: {
                    this.doFloatConversion(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("PCM2PCMStream: Call to convert with unknown conversionType.");
                }
            }
            if (this.needExpandChannels) {
                this.expandChannels(outBuffer, outByteOffset, inFrameCount, (this.getFormat().getSampleSizeInBits() + 7) / 8, this.getFormat().getChannels());
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.getOriginalStream().getFormat().getChannels();
            switch (this.conversionType) {
                case 1: {
                    TConversionTool.convertSign8(buffer, byteOffset, sampleCount);
                    break;
                }
                case 2: {
                    TConversionTool.swapOrder16(buffer, byteOffset, sampleCount);
                    break;
                }
                case 3: {
                    TConversionTool.swapOrder24(buffer, byteOffset, sampleCount);
                    break;
                }
                case 4: {
                    TConversionTool.swapOrder32(buffer, byteOffset, sampleCount);
                    break;
                }
                case 100: {
                    this.doFloatConversion(buffer, byteOffset, buffer, byteOffset, sampleCount);
                    if (!this.needExpandChannels) break;
                    this.expandChannels(buffer, byteOffset, frameCount, (this.getFormat().getSampleSizeInBits() + 7) / 8, this.getFormat().getChannels());
                    break;
                }
                default: {
                    throw new RuntimeException("PCM2PCMStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }

        protected void convert(FloatSampleBuffer buffer, int offset, int count) {
            this.doFloatConversion(buffer);
        }
    }
}

