/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.config;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class ConfigFile {
    private final File file;

    public ConfigFile(File file) {
        this.file = file.getAbsoluteFile();
    }

    public ConfigFile(String path) {
        this(new File(path));
    }

    public String read() {
        try {
            if ((this.file.getParentFile().exists() || this.file.getParentFile().mkdirs()) && (this.file.exists() || this.file.createNewFile())) {
                return Files.readString(this.file.toPath(), StandardCharsets.UTF_8);
            }
            throw new RuntimeException("Cannot create new file");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean write(String str) {
        try {
            if ((this.file.getParentFile().exists() || this.file.getParentFile().mkdirs()) && (this.file.exists() || this.file.createNewFile())) {
                Files.writeString(this.file.toPath(), (CharSequence)str, StandardCharsets.UTF_8, new OpenOption[0]);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

