/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.JsonParser;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.api.MusicSourceNotFoundException;
import top.gregtao.concerto.api.UnsafeMusicException;
import top.gregtao.concerto.enums.Sources;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.PathFileMusic;
import top.gregtao.concerto.music.lyrics.DefaultFormatLyrics;
import top.gregtao.concerto.music.lyrics.Lyrics;
import top.gregtao.concerto.music.meta.music.BasicMusicMetaData;
import top.gregtao.concerto.music.meta.music.TimelessMusicMetaData;
import top.gregtao.concerto.player.streamplayer.enums.AudioType;
import top.gregtao.concerto.player.streamplayer.tools.TimeTool;
import top.gregtao.concerto.util.FileUtil;
import top.gregtao.concerto.util.HttpUtil;
import top.gregtao.concerto.util.Pair;
import top.gregtao.concerto.util.TextUtil;

public class LocalFileMusic
extends PathFileMusic {
    public static List<String> FORMATS = List.of("mp3", "ogg", "wav", "flac", "aac", "m4a");

    public LocalFileMusic(String rawPath) throws UnsafeMusicException {
        super(new File(TextUtil.trimSurrounding(rawPath, "\"", "\"")).getAbsolutePath());
        String suffix = HttpUtil.getSuffix(this.getRawPath()).substring(1).toLowerCase();
        if (!FORMATS.contains(suffix)) {
            ConcertoClient.LOGGER.warn("Unsupported source: {}", (Object)suffix);
            throw new UnsafeMusicException("Unsupported source: " + suffix);
        }
    }

    @Override
    public InputStream getMusicSource() {
        try {
            byte[] fileBytes = Files.readAllBytes(Path.of(this.getRawPath(), new String[0]));
            int alignedLength = (fileBytes.length + 4095) / 4096 * 4096;
            byte[] alignedBytes = new byte[alignedLength];
            System.arraycopy(fileBytes, 0, alignedBytes, 0, fileBytes.length);
            return new ByteArrayInputStream(alignedBytes);
        }
        catch (IOException e) {
            throw new MusicSourceNotFoundException(e);
        }
    }

    @Override
    public Pair<Lyrics, Lyrics> getLyrics() throws IOException {
        Lyrics lyrics = null;
        try {
            lyrics = new DefaultFormatLyrics().load(String.join((CharSequence)"\n", Files.readAllLines(Path.of(HttpUtil.getRawPathWithoutSuffix(this.getRawPath()) + ".lrc", new String[0]))));
        }
        catch (NoSuchFileException e) {
            try {
                lyrics = new DefaultFormatLyrics().load(FileUtil.getLocalAudioLyrics(AudioFileIO.read(new File(this.getRawPath()))));
            }
            catch (IOException | CannotReadException | InvalidAudioFrameException | ReadOnlyFileException | TagException e1) {
                ConcertoClient.LOGGER.warn("Error occurs while loading file: '{}'", (Object)this.getRawPath());
            }
        }
        return Pair.of(lyrics, null);
    }

    @Override
    public void load() {
        String coverImg;
        String author;
        String title;
        try {
            AudioFile file = AudioFileIO.read(new File(this.getRawPath()));
            Tag tag = file.getTagAndConvertOrCreateDefault();
            title = tag.getFirst(FieldKey.TITLE);
            author = FileUtil.getLocalAudioAuthors(file);
            coverImg = FileUtil.getCoverAsObjectURL(file);
        }
        catch (Exception e) {
            coverImg = null;
            title = null;
            author = null;
        }
        long duration = TimeTool.durationInMilliseconds(new File(this.getRawPath()).getAbsolutePath(), AudioType.FILE);
        if (duration <= 0L) {
            this.setMusicMeta(new TimelessMusicMetaData(author == null || author.isEmpty() ? TextUtil.getTranslatable("concerto.unknown") : author, title == null || title.isEmpty() ? this.getRawPath() : title, Sources.LOCAL_FILE.getName().getString()));
        } else {
            this.setMusicMeta(new BasicMusicMetaData(author == null || author.isEmpty() ? TextUtil.getTranslatable("concerto.unknown") : author, title == null || title.isEmpty() ? this.getRawPath() : title, Sources.LOCAL_FILE.getName().getString(), TimeTool.durationInMilliseconds(new File(this.getRawPath()).getAbsolutePath(), AudioType.FILE), coverImg == null ? "" : coverImg));
        }
        super.load();
    }

    @Override
    public JsonParser<Music> getJsonParser() {
        return MusicJsonParsers.LOCAL_FILE;
    }

    public static ArrayList<Music> getMusicsInFolder(File file) {
        ArrayList<Music> list = new ArrayList<Music>();
        if (!file.isDirectory()) {
            return list;
        }
        File[] files = file.listFiles((dir, name) -> FORMATS.contains(FileUtil.getSuffix(name).toLowerCase()));
        if (files == null) {
            return list;
        }
        for (File file1 : files) {
            list.add(new LocalFileMusic(file1.getAbsolutePath()));
        }
        return list;
    }
}

