/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.network.room;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.api.DynamicPath;
import top.gregtao.concerto.config.ServerConfig;
import top.gregtao.concerto.http.HttpURLInputStream;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.SharedMusic;
import top.gregtao.concerto.network.ServerMusicNetworkHandler;
import top.gregtao.concerto.util.ConcertoRunner;

public class ServerMusicAgent {
    public static ServerMusicAgent INSTANCE = new ServerMusicAgent();
    private final Map<class_3222, Long> members = new HashMap<class_3222, Long>();
    private final ScheduledExecutorService voteScheduler = Executors.newScheduledThreadPool(1);
    private final Lock voteLock = new ReentrantLock();
    private volatile boolean isVoting = false;
    private final List<class_3222> yesVoters = new ArrayList<class_3222>();
    private final List<class_3222> noVoters = new ArrayList<class_3222>();
    private ScheduledFuture<?> voteFuture;
    private final ScheduledExecutorService musicScheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> playNextFuture;
    private final ConcurrentLinkedQueue<Music> musicQueue = new ConcurrentLinkedQueue();
    private Music currentMusic = null;
    private Music currentSharedMusic = null;
    private int totalBytes = 0;
    private long playTime = 0L;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean isPlaying = new AtomicBoolean(false);
    private final AtomicBoolean currentlyFreeTime = new AtomicBoolean(false);
    public ArrayList<Music> freeTimePlaylist = new ArrayList();
    private int freeTimePlaylistIndex = 0;

    public void stop() {
        if (this.isStopped.get()) {
            return;
        }
        this.isStopped.set(true);
        this.playNextFuture.cancel(false);
        this.membersForEach(ServerMusicNetworkHandler::musicAgentSendStop);
    }

    public void start() {
        if (!this.isStopped.get()) {
            return;
        }
        this.isStopped.set(false);
        this.schedulePlayNext(0, false);
    }

    private Music getNextFreeTimeMusic() {
        if (this.freeTimePlaylist.isEmpty()) {
            return null;
        }
        this.freeTimePlaylistIndex = (this.freeTimePlaylistIndex + 1) % this.freeTimePlaylist.size();
        return this.freeTimePlaylist.get(this.freeTimePlaylistIndex);
    }

    public boolean hasNextMusic() {
        return !this.musicQueue.isEmpty() || !this.freeTimePlaylist.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveVoteRequest(class_3222 player) {
        if (this.isVoting) {
            player.method_7353((class_2561)new class_2588("concerto.agent.vote.voting"), false);
            return;
        }
        if (!this.isPlaying.get()) {
            player.method_7353((class_2561)new class_2588("concerto.agent.not_playing"), false);
            return;
        }
        ServerMusicAgent serverMusicAgent = this;
        synchronized (serverMusicAgent) {
            this.voteLock.lock();
            this.isVoting = true;
            this.yesVoters.clear();
            this.noVoters.clear();
            this.voteFuture = this.voteScheduler.schedule(this::endVoting, 15L, TimeUnit.SECONDS);
            this.voteLock.unlock();
            this.membersForEach(ServerMusicNetworkHandler::sendVote2Member);
            ConcertoServer.LOGGER.info("Vote request created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveVote(class_3222 player, boolean vote) {
        if (!this.isVoting) {
            player.method_7353((class_2561)new class_2588("concerto.agent.vote.ended"), false);
            return;
        }
        ServerMusicAgent serverMusicAgent = this;
        synchronized (serverMusicAgent) {
            if (this.yesVoters.contains(player) || this.noVoters.contains(player)) {
                player.method_7353((class_2561)new class_2588("concerto.agent.vote.duplicate"), false);
                return;
            }
            this.voteLock.lock();
            (vote ? this.yesVoters : this.noVoters).add(player);
            if (this.yesVoters.size() + this.noVoters.size() == this.members.size() && this.voteFuture.cancel(false)) {
                this.endVoting();
            }
            this.voteLock.unlock();
            player.method_7353((class_2561)new class_2588("concerto.agent.vote_for", new Object[]{vote ? new class_2588("concerto.accept").getString() : new class_2588("concerto.reject").getString()}), false);
            ConcertoServer.LOGGER.info("Player {} voted {}", (Object)player.method_5477().getString(), (Object)vote);
        }
    }

    private synchronized void endVoting() {
        boolean success;
        boolean bl = success = this.yesVoters.size() > this.noVoters.size();
        if (success) {
            ConcertoServer.LOGGER.info("Vote: Play the next music");
            if (!this.hasNextMusic()) {
                this.membersForEach(ServerMusicNetworkHandler::musicAgentSendStop);
            } else if (this.playNextFuture.isDone() || this.playNextFuture.cancel(false)) {
                this.playNextMusic();
            }
        } else {
            ConcertoServer.LOGGER.info("Vote: Keep current music");
        }
        class_2588 text = new class_2588(success ? "concerto.agent.vote.success" : "concerto.agent.vote.failed", new Object[]{this.yesVoters.size(), this.noVoters.size()});
        this.broadcast((class_2561)text);
        this.isVoting = false;
    }

    public synchronized void playNextMusic() {
        try {
            this.currentMusic = this.musicQueue.poll();
            if (this.currentMusic == null) {
                this.currentMusic = this.getNextFreeTimeMusic();
                this.currentlyFreeTime.set(this.currentMusic != null);
            } else {
                this.currentlyFreeTime.set(false);
            }
            this.currentSharedMusic = null;
            this.totalBytes = 0;
            this.playTime = 0L;
            if (this.currentMusic == null) {
                ConcertoServer.LOGGER.info("Music agent paused");
                this.isPlaying.set(false);
            } else {
                Music music;
                ConcertoServer.LOGGER.info("Start playing music {}, duration {}", (Object)this.currentMusic.getMeta().title(), (Object)this.currentMusic.getMeta().getDuration());
                if (ServerConfig.INSTANCE.options.musicAgentUseShared && (music = this.currentMusic) instanceof DynamicPath) {
                    DynamicPath dynamicPath = (DynamicPath)((Object)music);
                    String path = dynamicPath.updateRawPath();
                    if (path == null) {
                        ConcertoServer.LOGGER.warn("Cannot play music {}", (Object)this.currentMusic.getMeta().title());
                        this.broadcast((class_2561)new class_2588("concerto.agent.play.failed", new Object[]{this.currentMusic.getMeta().title(), this.currentMusic.getMeta().author()}));
                        this.schedulePlayNext(0, false);
                        return;
                    }
                    this.totalBytes = HttpURLInputStream.getTotalBytes(path);
                    this.currentSharedMusic = new SharedMusic(path, this.currentMusic.getMeta(), dynamicPath.getLastLyrics(), dynamicPath.getLastSubLyrics());
                } else {
                    this.currentSharedMusic = this.currentMusic;
                }
                this.isPlaying.set(true);
                this.playTime = System.currentTimeMillis();
                ServerMusicNetworkHandler.musicAgentSendMusic(this.getMembers(), this.currentSharedMusic);
                this.schedulePlayNext(this.currentMusic.getMeta().getDuration().asSeconds(), false);
            }
        }
        catch (Exception e) {
            ConcertoServer.LOGGER.error("Play music failed", (Throwable)e);
            this.broadcast((class_2561)new class_2588("concerto.agent.error"));
            this.reset();
        }
    }

    public void broadcast(class_2561 text) {
        this.members.forEach((player, time) -> player.method_7353(text, false));
    }

    public synchronized boolean isMember(class_3222 player) {
        return this.members.containsKey(player);
    }

    public synchronized void addMusic(class_3222 player, Music music) {
        Long lastAddTime = this.members.getOrDefault(player, 0L);
        int wait = (int)((long)ServerConfig.INSTANCE.options.musicAgentAddTimeLimit - (System.currentTimeMillis() - lastAddTime) / 1000L);
        if (wait > 0) {
            player.method_7353((class_2561)new class_2588("concerto.agent.add.too_quick", new Object[]{wait}), false);
            return;
        }
        ConcertoRunner.run(() -> {
            ConcertoServer.LOGGER.info("Added music {}", (Object)music.getMeta().title());
            this.musicQueue.offer(music);
            this.members.put(player, System.currentTimeMillis());
            this.broadcast((class_2561)new class_2588("concerto.agent.add", new Object[]{player == null ? new class_2588("concerto.unknown").getString() : player.method_5477().getString(), music.getMeta().title(), music.getMeta().author()}));
            if (!this.isPlaying.get() || this.currentlyFreeTime.get()) {
                this.schedulePlayNext(0, false);
            }
        });
    }

    public synchronized void playerJoin(class_3222 player) {
        ConcertoServer.LOGGER.info("Player {} joined music agent", (Object)player.method_5477().getString());
        this.members.put(player, -1L);
        if (!this.isPlaying.get() && this.hasNextMusic()) {
            this.schedulePlayNext(0, false);
        } else if (this.isPlaying.get() && this.currentSharedMusic != null) {
            ConcertoRunner.run(() -> {
                Music patt0$temp = this.currentSharedMusic;
                if (patt0$temp instanceof SharedMusic) {
                    SharedMusic shared = (SharedMusic)patt0$temp;
                    shared.startTime = System.currentTimeMillis() - this.playTime;
                    shared.startByte = (long)this.totalBytes * (System.currentTimeMillis() - this.playTime) / this.currentMusic.getMeta().getDuration().asMilliseconds();
                    shared.setRawPath(((DynamicPath)((Object)this.currentSharedMusic)).updateRawPath());
                }
                ServerMusicNetworkHandler.musicAgentSendMusic(player, this.currentSharedMusic);
            });
        }
    }

    public synchronized void playerQuit(class_3222 player) {
        ConcertoServer.LOGGER.info("Player {} quited music agent", (Object)player.method_5477().getString());
        this.members.remove(player);
    }

    public synchronized void schedulePlayNext(int delay, boolean force) {
        if (this.isStopped.get()) {
            return;
        }
        if (this.playNextFuture != null && !this.playNextFuture.isDone()) {
            this.playNextFuture.cancel(force);
        }
        this.playNextFuture = this.musicScheduler.schedule(this::playNextMusic, (long)delay, TimeUnit.SECONDS);
    }

    public synchronized void reset() {
        this.voteLock.lock();
        this.isVoting = false;
        this.yesVoters.clear();
        this.noVoters.clear();
        this.voteLock.unlock();
        if (this.playNextFuture != null) {
            this.playNextFuture.cancel(true);
        }
        if (this.voteFuture != null) {
            this.voteFuture.cancel(true);
        }
        this.musicQueue.clear();
        this.currentSharedMusic = null;
        this.currentMusic = null;
        this.totalBytes = 0;
        this.playTime = 0L;
        this.isPlaying.set(false);
        this.currentlyFreeTime.set(false);
        ConcertoServer.LOGGER.info("Reset server music agent");
    }

    public List<class_3222> getMembers() {
        return this.members.keySet().stream().toList();
    }

    public void membersForEach(Consumer<class_3222> consumer) {
        this.members.forEach((player, time) -> consumer.accept((class_3222)player));
    }

    public List<Music> getMusicQueue() {
        return this.musicQueue.stream().toList();
    }
}

