/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import top.gregtao.concerto.ConcertoClient;

public class QRCodeRenderer {
    public static final int SIZE = 128;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;

    public static byte[] generateQRCode(String text) {
        return QRCodeRenderer.generateQRCode(text, 128, 128);
    }

    public static byte[] generateQRCode(String text, int width, int height) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            BitMatrix matrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, width, height);
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, "png", stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WriterException | IOException e) {
                ConcertoClient.LOGGER.error("Error while generating QR Code", (Throwable)e);
                return new byte[0];
            }
        }
        stream.close();
        return byArray;
    }

    public static byte[] generateQRCode(String text, int margin) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            BitMatrix matrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, 0, 0, Map.of(EncodeHintType.MARGIN, 0));
            int qrWidth = matrix.getWidth();
            int qrHeight = matrix.getHeight();
            int width = qrWidth + margin * 2;
            int height = qrHeight + margin * 2;
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int xi = x - margin;
                    int yi = y - margin;
                    if (xi < 0 || xi >= qrWidth || yi < 0 || yi >= qrHeight) {
                        image.setRGB(x, y, -1);
                        continue;
                    }
                    image.setRGB(x, y, matrix.get(xi, yi) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, "png", stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WriterException | IOException e) {
                ConcertoClient.LOGGER.error("Error while generating QR Code", (Throwable)e);
                return new byte[0];
            }
        }
        stream.close();
        return byArray;
    }
}

