/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import org.jaudiotagger.audio.wav.chunk.WavFactChunk;
import org.jaudiotagger.audio.wav.chunk.WavFormatChunk;
import org.jaudiotagger.logging.Hex;

public class WavInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");
    private String loggingName;
    private boolean isFoundAudio = false;
    private boolean isFoundFormat = false;

    public WavInfoReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public GenericAudioHeader read(Path path) throws CannotReadException, IOException {
        GenericAudioHeader info;
        block15: {
            info = new GenericAudioHeader();
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, info)) continue;
                        break block15;
                    }
                    break block15;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        if (this.isFoundFormat && this.isFoundAudio) {
            info.setFormat(SupportedFileFormat.WAV.getDisplayName());
            info.setLossless(true);
            this.calculateTrackLength(info);
            return info;
        }
        throw new CannotReadException(this.loggingName + " Unable to safetly read chunks for this file, appears to be corrupt");
    }

    private void calculateTrackLength(GenericAudioHeader info) throws CannotReadException {
        if (info.getNoOfSamples() != null) {
            if (info.getSampleRateAsNumber() > 0) {
                info.setPreciseLength((float)info.getNoOfSamples().longValue() / (float)info.getSampleRateAsNumber());
            }
        } else if (info.getAudioDataLength() > 0L) {
            info.setPreciseLength((float)info.getAudioDataLength().longValue() / (float)info.getByteRate().intValue());
        } else {
            throw new CannotReadException(this.loggingName + " Wav Data Header Missing");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readChunk(FileChannel fc, GenericAudioHeader info) throws IOException, CannotReadException {
        block19: {
            block18: {
                chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
                if (!chunkHeader.readHeader(fc)) {
                    return false;
                }
                id = chunkHeader.getID();
                WavInfoReader.logger.info(this.loggingName + " Reading Chunk:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                chunkType = WavChunkType.get(id);
                if (chunkType == null) break block18;
                switch (1.$SwitchMap$org$jaudiotagger$audio$wav$WavChunkType[chunkType.ordinal()]) {
                    case 1: {
                        fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        chunk = new WavFactChunk(fmtChunkData, chunkHeader, info);
                        if (!chunk.readChunk()) {
                            return false;
                        }
                        break block19;
                    }
                    case 2: {
                        info.setAudioDataLength(chunkHeader.getSize());
                        info.setAudioDataStartPosition(fc.position());
                        info.setAudioDataEndPosition(fc.position() + chunkHeader.getSize());
                        fc.position(fc.position() + chunkHeader.getSize());
                        this.isFoundAudio = true;
                        break block19;
                    }
                    case 3: {
                        fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        chunk = new WavFormatChunk(fmtChunkData, chunkHeader, info);
                        if (!chunk.readChunk()) {
                            return false;
                        }
                        this.isFoundFormat = true;
                        break block19;
                    }
                    default: {
                        if (fc.position() + chunkHeader.getSize() > fc.size()) ** GOTO lbl35
                        fc.position(fc.position() + chunkHeader.getSize());
                        break block19;
lbl35:
                        // 1 sources

                        if (!this.isFoundAudio || !this.isFoundFormat) ** GOTO lbl40
                        WavInfoReader.logger.severe(this.loggingName + " Size of Chunk Header larger than data, skipping to file end:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                        fc.position(fc.size());
                        break block19;
lbl40:
                        // 1 sources

                        WavInfoReader.logger.severe(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                        throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                    }
                }
            }
            if (id.substring(1, 3).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                WavInfoReader.logger.severe(this.loggingName + " Found Corrupt LIST Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                WavInfoReader.logger.severe(this.loggingName + " Found Corrupt LIST Chunk (2), starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                fc.position(fc.position() - 9L);
                return true;
            }
            if (id.equals("\u0000\u0000\u0000\u0000") && chunkHeader.getSize() == 0L) {
                fileRemainder = (int)(fc.size() - fc.position());
                restOfFile = ByteBuffer.allocate(fileRemainder);
                fc.read(restOfFile);
                restOfFile.flip();
                while (restOfFile.hasRemaining() && restOfFile.get() == 0) {
                }
                WavInfoReader.logger.severe(this.loggingName + "Found Null Padding, starting at " + chunkHeader.getStartLocationInFile() + ", size:" + restOfFile.position() + 8);
                fc.position(chunkHeader.getStartLocationInFile() + (long)restOfFile.position() + 8L - 1L);
                return true;
            }
            if (chunkHeader.getSize() >= 0L) ** GOTO lbl75
            if (this.isFoundAudio && this.isFoundFormat) {
                WavInfoReader.logger.severe(this.loggingName + " Size of Chunk Header is negative, skipping to file end:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                fc.position(fc.size());
            } else {
                msg = this.loggingName + " Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                WavInfoReader.logger.severe(msg);
                throw new CannotReadException(msg);
lbl75:
                // 1 sources

                if (fc.position() + chunkHeader.getSize() <= fc.size()) {
                    WavInfoReader.logger.severe(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize() + " for " + chunkHeader.getID());
                    fc.position(fc.position() + chunkHeader.getSize());
                } else if (this.isFoundAudio && this.isFoundFormat) {
                    WavInfoReader.logger.severe(this.loggingName + " Size of Chunk Header larger than data, skipping to file end:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    fc.position(fc.size());
                } else {
                    WavInfoReader.logger.severe(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                    throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                }
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

