/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.EnumMap;
import java.util.Map;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3v24FieldKey;

public class ID3v24Frames
extends ID3Frames {
    public static final String FRAME_ID_ACCOMPANIMENT = "TPE2";
    public static final String FRAME_ID_ALBUM = "TALB";
    public static final String FRAME_ID_ALBUM_SORT_ORDER = "TSOA";
    public static final String FRAME_ID_ARTIST = "TPE1";
    public static final String FRAME_ID_ATTACHED_PICTURE = "APIC";
    public static final String FRAME_ID_AUDIO_ENCRYPTION = "AENC";
    public static final String FRAME_ID_AUDIO_SEEK_POINT_INDEX = "ASPI";
    public static final String FRAME_ID_BPM = "TBPM";
    public static final String FRAME_ID_CHAPTER = "CHAP";
    public static final String FRAME_ID_CHAPTER_TOC = "CTOC";
    public static final String FRAME_ID_COMMENT = "COMM";
    public static final String FRAME_ID_COMMERCIAL_FRAME = "COMR";
    public static final String FRAME_ID_COMPOSER = "TCOM";
    public static final String FRAME_ID_CONDUCTOR = "TPE3";
    public static final String FRAME_ID_CONTENT_GROUP_DESC = "TIT1";
    public static final String FRAME_ID_COPYRIGHTINFO = "TCOP";
    public static final String FRAME_ID_ENCODEDBY = "TENC";
    public static final String FRAME_ID_ENCODING_TIME = "TDEN";
    public static final String FRAME_ID_ENCRYPTION = "ENCR";
    public static final String FRAME_ID_EQUALISATION2 = "EQU2";
    public static final String FRAME_ID_EVENT_TIMING_CODES = "ETCO";
    public static final String FRAME_ID_FILE_OWNER = "TOWN";
    public static final String FRAME_ID_FILE_TYPE = "TFLT";
    public static final String FRAME_ID_GENERAL_ENCAPS_OBJECT = "GEOB";
    public static final String FRAME_ID_GENRE = "TCON";
    public static final String FRAME_ID_GROUP_ID_REG = "GRID";
    public static final String FRAME_ID_HW_SW_SETTINGS = "TSSE";
    public static final String FRAME_ID_INITIAL_KEY = "TKEY";
    public static final String FRAME_ID_INVOLVED_PEOPLE = "TIPL";
    public static final String FRAME_ID_ISRC = "TSRC";
    public static final String FRAME_ID_ITUNES_GROUPING = "GRP1";
    public static final String FRAME_ID_LANGUAGE = "TLAN";
    public static final String FRAME_ID_LENGTH = "TLEN";
    public static final String FRAME_ID_LINKED_INFO = "LINK";
    public static final String FRAME_ID_LYRICIST = "TEXT";
    public static final String FRAME_ID_MEDIA_TYPE = "TMED";
    public static final String FRAME_ID_MOOD = "TMOO";
    public static final String FRAME_ID_MOVEMENT = "MVNM";
    public static final String FRAME_ID_MOVEMENT_NO = "MVIN";
    public static final String FRAME_ID_MPEG_LOCATION_LOOKUP_TABLE = "MLLT";
    public static final String FRAME_ID_MUSICIAN_CREDITS = "TMCL";
    public static final String FRAME_ID_MUSIC_CD_ID = "MCDI";
    public static final String FRAME_ID_ORIGARTIST = "TOPE";
    public static final String FRAME_ID_ORIGINAL_RELEASE_TIME = "TDOR";
    public static final String FRAME_ID_ORIG_FILENAME = "TOFN";
    public static final String FRAME_ID_ORIG_LYRICIST = "TOLY";
    public static final String FRAME_ID_ORIG_TITLE = "TOAL";
    public static final String FRAME_ID_OWNERSHIP = "OWNE";
    public static final String FRAME_ID_ARTIST_SORT_ORDER = "TSOP";
    public static final String FRAME_ID_PLAYLIST_DELAY = "TDLY";
    public static final String FRAME_ID_PLAY_COUNTER = "PCNT";
    public static final String FRAME_ID_POPULARIMETER = "POPM";
    public static final String FRAME_ID_POSITION_SYNC = "POSS";
    public static final String FRAME_ID_PRIVATE = "PRIV";
    public static final String FRAME_ID_PRODUCED_NOTICE = "TPRO";
    public static final String FRAME_ID_PUBLISHER = "TPUB";
    public static final String FRAME_ID_RADIO_NAME = "TRSN";
    public static final String FRAME_ID_RADIO_OWNER = "TRSO";
    public static final String FRAME_ID_RECOMMENDED_BUFFER_SIZE = "RBUF";
    public static final String FRAME_ID_RELATIVE_VOLUME_ADJUSTMENT2 = "RVA2";
    public static final String FRAME_ID_RELEASE_TIME = "TDRL";
    public static final String FRAME_ID_REMIXED = "TPE4";
    public static final String FRAME_ID_REVERB = "RVRB";
    public static final String FRAME_ID_SEEK = "SEEK";
    public static final String FRAME_ID_SET = "TPOS";
    public static final String FRAME_ID_SET_SUBTITLE = "TSST";
    public static final String FRAME_ID_SIGNATURE = "SIGN";
    public static final String FRAME_ID_SYNC_LYRIC = "SYLT";
    public static final String FRAME_ID_SYNC_TEMPO = "SYTC";
    public static final String FRAME_ID_TAGGING_TIME = "TDTG";
    public static final String FRAME_ID_TERMS_OF_USE = "USER";
    public static final String FRAME_ID_TITLE = "TIT2";
    public static final String FRAME_ID_TITLE_REFINEMENT = "TIT3";
    public static final String FRAME_ID_TITLE_SORT_ORDER = "TSOT";
    public static final String FRAME_ID_TRACK = "TRCK";
    public static final String FRAME_ID_UNIQUE_FILE_ID = "UFID";
    public static final String FRAME_ID_UNSYNC_LYRICS = "USLT";
    public static final String FRAME_ID_URL_ARTIST_WEB = "WOAR";
    public static final String FRAME_ID_URL_COMMERCIAL = "WCOM";
    public static final String FRAME_ID_URL_COPYRIGHT = "WCOP";
    public static final String FRAME_ID_URL_FILE_WEB = "WOAF";
    public static final String FRAME_ID_URL_OFFICIAL_RADIO = "WORS";
    public static final String FRAME_ID_URL_PAYMENT = "WPAY";
    public static final String FRAME_ID_URL_PUBLISHERS = "WPUB";
    public static final String FRAME_ID_URL_SOURCE_WEB = "WOAS";
    public static final String FRAME_ID_USER_DEFINED_INFO = "TXXX";
    public static final String FRAME_ID_USER_DEFINED_URL = "WXXX";
    public static final String FRAME_ID_YEAR = "TDRC";
    public static final String FRAME_ID_ALBUM_ARTIST_SORT_ORDER_ITUNES = "TSO2";
    public static final String FRAME_ID_COMPOSER_SORT_ORDER_ITUNES = "TSOC";
    public static final String FRAME_ID_IS_COMPILATION = "TCMP";
    public static final String FRAME_ID_PERFORMER_SORT_OWNER = "TSOP";
    public static final String FRAME_ID_TITLE_SORT_OWNER = "TSOT";
    protected EnumMap<FieldKey, ID3v24FieldKey> tagFieldToId3 = new EnumMap(FieldKey.class);
    protected EnumMap<ID3v24FieldKey, FieldKey> id3ToTagField = new EnumMap(ID3v24FieldKey.class);
    private static ID3v24Frames id3v24Frames;

    public static ID3v24Frames getInstanceOf() {
        if (id3v24Frames == null) {
            id3v24Frames = new ID3v24Frames();
        }
        return id3v24Frames;
    }

    private ID3v24Frames() {
        this.supportedFrames.add(FRAME_ID_ACCOMPANIMENT);
        this.supportedFrames.add(FRAME_ID_ALBUM);
        this.supportedFrames.add(FRAME_ID_ALBUM_SORT_ORDER);
        this.supportedFrames.add(FRAME_ID_ARTIST);
        this.supportedFrames.add(FRAME_ID_ATTACHED_PICTURE);
        this.supportedFrames.add(FRAME_ID_AUDIO_ENCRYPTION);
        this.supportedFrames.add(FRAME_ID_AUDIO_SEEK_POINT_INDEX);
        this.supportedFrames.add(FRAME_ID_BPM);
        this.supportedFrames.add(FRAME_ID_CHAPTER);
        this.supportedFrames.add(FRAME_ID_CHAPTER_TOC);
        this.supportedFrames.add(FRAME_ID_COMMENT);
        this.supportedFrames.add(FRAME_ID_COMMERCIAL_FRAME);
        this.supportedFrames.add(FRAME_ID_COMPOSER);
        this.supportedFrames.add(FRAME_ID_CONDUCTOR);
        this.supportedFrames.add(FRAME_ID_CONTENT_GROUP_DESC);
        this.supportedFrames.add(FRAME_ID_COPYRIGHTINFO);
        this.supportedFrames.add(FRAME_ID_ENCODEDBY);
        this.supportedFrames.add(FRAME_ID_ENCODING_TIME);
        this.supportedFrames.add(FRAME_ID_ENCRYPTION);
        this.supportedFrames.add(FRAME_ID_EQUALISATION2);
        this.supportedFrames.add(FRAME_ID_EVENT_TIMING_CODES);
        this.supportedFrames.add(FRAME_ID_FILE_OWNER);
        this.supportedFrames.add(FRAME_ID_FILE_TYPE);
        this.supportedFrames.add(FRAME_ID_GENERAL_ENCAPS_OBJECT);
        this.supportedFrames.add(FRAME_ID_GENRE);
        this.supportedFrames.add(FRAME_ID_GROUP_ID_REG);
        this.supportedFrames.add(FRAME_ID_HW_SW_SETTINGS);
        this.supportedFrames.add(FRAME_ID_INITIAL_KEY);
        this.supportedFrames.add(FRAME_ID_INVOLVED_PEOPLE);
        this.supportedFrames.add(FRAME_ID_ISRC);
        this.supportedFrames.add(FRAME_ID_ITUNES_GROUPING);
        this.supportedFrames.add(FRAME_ID_LANGUAGE);
        this.supportedFrames.add(FRAME_ID_LENGTH);
        this.supportedFrames.add(FRAME_ID_LINKED_INFO);
        this.supportedFrames.add(FRAME_ID_LYRICIST);
        this.supportedFrames.add(FRAME_ID_MEDIA_TYPE);
        this.supportedFrames.add(FRAME_ID_MOOD);
        this.supportedFrames.add(FRAME_ID_MOVEMENT);
        this.supportedFrames.add(FRAME_ID_MOVEMENT_NO);
        this.supportedFrames.add(FRAME_ID_MPEG_LOCATION_LOOKUP_TABLE);
        this.supportedFrames.add(FRAME_ID_MUSIC_CD_ID);
        this.supportedFrames.add(FRAME_ID_MUSICIAN_CREDITS);
        this.supportedFrames.add(FRAME_ID_ORIGARTIST);
        this.supportedFrames.add(FRAME_ID_ORIGINAL_RELEASE_TIME);
        this.supportedFrames.add(FRAME_ID_ORIG_FILENAME);
        this.supportedFrames.add(FRAME_ID_ORIG_LYRICIST);
        this.supportedFrames.add(FRAME_ID_ORIG_TITLE);
        this.supportedFrames.add(FRAME_ID_OWNERSHIP);
        this.supportedFrames.add("TSOP");
        this.supportedFrames.add(FRAME_ID_PLAYLIST_DELAY);
        this.supportedFrames.add(FRAME_ID_PLAY_COUNTER);
        this.supportedFrames.add(FRAME_ID_POPULARIMETER);
        this.supportedFrames.add(FRAME_ID_POSITION_SYNC);
        this.supportedFrames.add(FRAME_ID_PRIVATE);
        this.supportedFrames.add(FRAME_ID_PRODUCED_NOTICE);
        this.supportedFrames.add(FRAME_ID_PUBLISHER);
        this.supportedFrames.add(FRAME_ID_RADIO_NAME);
        this.supportedFrames.add(FRAME_ID_RADIO_OWNER);
        this.supportedFrames.add(FRAME_ID_RECOMMENDED_BUFFER_SIZE);
        this.supportedFrames.add(FRAME_ID_RELATIVE_VOLUME_ADJUSTMENT2);
        this.supportedFrames.add(FRAME_ID_RELEASE_TIME);
        this.supportedFrames.add(FRAME_ID_REMIXED);
        this.supportedFrames.add(FRAME_ID_REVERB);
        this.supportedFrames.add(FRAME_ID_SEEK);
        this.supportedFrames.add(FRAME_ID_SET);
        this.supportedFrames.add(FRAME_ID_SET_SUBTITLE);
        this.supportedFrames.add(FRAME_ID_SIGNATURE);
        this.supportedFrames.add(FRAME_ID_SYNC_LYRIC);
        this.supportedFrames.add(FRAME_ID_SYNC_TEMPO);
        this.supportedFrames.add(FRAME_ID_TAGGING_TIME);
        this.supportedFrames.add(FRAME_ID_TERMS_OF_USE);
        this.supportedFrames.add(FRAME_ID_TITLE);
        this.supportedFrames.add(FRAME_ID_TITLE_REFINEMENT);
        this.supportedFrames.add("TSOT");
        this.supportedFrames.add(FRAME_ID_TRACK);
        this.supportedFrames.add(FRAME_ID_UNIQUE_FILE_ID);
        this.supportedFrames.add(FRAME_ID_UNSYNC_LYRICS);
        this.supportedFrames.add(FRAME_ID_URL_ARTIST_WEB);
        this.supportedFrames.add(FRAME_ID_URL_COMMERCIAL);
        this.supportedFrames.add(FRAME_ID_URL_COPYRIGHT);
        this.supportedFrames.add(FRAME_ID_URL_FILE_WEB);
        this.supportedFrames.add(FRAME_ID_URL_OFFICIAL_RADIO);
        this.supportedFrames.add(FRAME_ID_URL_PAYMENT);
        this.supportedFrames.add(FRAME_ID_URL_PUBLISHERS);
        this.supportedFrames.add(FRAME_ID_URL_SOURCE_WEB);
        this.supportedFrames.add(FRAME_ID_USER_DEFINED_INFO);
        this.supportedFrames.add(FRAME_ID_USER_DEFINED_URL);
        this.supportedFrames.add(FRAME_ID_YEAR);
        this.extensionFrames.add(FRAME_ID_IS_COMPILATION);
        this.extensionFrames.add(FRAME_ID_ALBUM_ARTIST_SORT_ORDER_ITUNES);
        this.extensionFrames.add(FRAME_ID_COMPOSER_SORT_ORDER_ITUNES);
        this.commonFrames.add(FRAME_ID_ARTIST);
        this.commonFrames.add(FRAME_ID_ALBUM);
        this.commonFrames.add(FRAME_ID_TITLE);
        this.commonFrames.add(FRAME_ID_GENRE);
        this.commonFrames.add(FRAME_ID_TRACK);
        this.commonFrames.add(FRAME_ID_YEAR);
        this.commonFrames.add(FRAME_ID_COMMENT);
        this.binaryFrames.add(FRAME_ID_ATTACHED_PICTURE);
        this.binaryFrames.add(FRAME_ID_AUDIO_ENCRYPTION);
        this.binaryFrames.add(FRAME_ID_ENCRYPTION);
        this.binaryFrames.add(FRAME_ID_EQUALISATION2);
        this.binaryFrames.add(FRAME_ID_EVENT_TIMING_CODES);
        this.binaryFrames.add(FRAME_ID_GENERAL_ENCAPS_OBJECT);
        this.binaryFrames.add(FRAME_ID_RELATIVE_VOLUME_ADJUSTMENT2);
        this.binaryFrames.add(FRAME_ID_RECOMMENDED_BUFFER_SIZE);
        this.binaryFrames.add(FRAME_ID_UNIQUE_FILE_ID);
        this.idToValue.put(FRAME_ID_ACCOMPANIMENT, "Text: Band/Orchestra/Accompaniment");
        this.idToValue.put(FRAME_ID_ALBUM, "Text: Album/Movie/Show title");
        this.idToValue.put(FRAME_ID_ALBUM_SORT_ORDER, "Album sort order");
        this.idToValue.put(FRAME_ID_ARTIST, "Text: Lead artist(s)/Lead performer(s)/Soloist(s)/Performing group");
        this.idToValue.put(FRAME_ID_ATTACHED_PICTURE, "Attached picture");
        this.idToValue.put(FRAME_ID_AUDIO_ENCRYPTION, "Audio encryption");
        this.idToValue.put(FRAME_ID_AUDIO_SEEK_POINT_INDEX, "Audio seek point index");
        this.idToValue.put(FRAME_ID_BPM, "Text: BPM (Beats Per Minute)");
        this.idToValue.put(FRAME_ID_CHAPTER, "Chapter");
        this.idToValue.put(FRAME_ID_CHAPTER_TOC, "Chapter TOC");
        this.idToValue.put(FRAME_ID_COMMENT, "Comments");
        this.idToValue.put(FRAME_ID_COMMERCIAL_FRAME, "Commercial Frame");
        this.idToValue.put(FRAME_ID_COMPOSER, "Text: Composer");
        this.idToValue.put(FRAME_ID_CONDUCTOR, "Text: Conductor/Performer refinement");
        this.idToValue.put(FRAME_ID_CONTENT_GROUP_DESC, "Text: Content group description");
        this.idToValue.put(FRAME_ID_COPYRIGHTINFO, "Text: Copyright message");
        this.idToValue.put(FRAME_ID_ENCODEDBY, "Text: Encoded by");
        this.idToValue.put(FRAME_ID_ENCODING_TIME, "Text: Encoding time");
        this.idToValue.put(FRAME_ID_ENCRYPTION, "Encryption method registration");
        this.idToValue.put(FRAME_ID_EQUALISATION2, "Equalization (2)");
        this.idToValue.put(FRAME_ID_EVENT_TIMING_CODES, "Event timing codes");
        this.idToValue.put(FRAME_ID_FILE_OWNER, "Text:File Owner");
        this.idToValue.put(FRAME_ID_FILE_TYPE, "Text: File type");
        this.idToValue.put(FRAME_ID_GENERAL_ENCAPS_OBJECT, "General encapsulated datatype");
        this.idToValue.put(FRAME_ID_GENRE, "Text: Content type");
        this.idToValue.put(FRAME_ID_GROUP_ID_REG, "Group ID Registration");
        this.idToValue.put(FRAME_ID_HW_SW_SETTINGS, "Text: Software/hardware and settings used for encoding");
        this.idToValue.put(FRAME_ID_INITIAL_KEY, "Text: Initial key");
        this.idToValue.put(FRAME_ID_INVOLVED_PEOPLE, "Involved people list");
        this.idToValue.put(FRAME_ID_ISRC, "Text: ISRC (International Standard Recording Code)");
        this.idToValue.put(FRAME_ID_ITUNES_GROUPING, "iTunes Grouping");
        this.idToValue.put(FRAME_ID_LANGUAGE, "Text: Language(s)");
        this.idToValue.put(FRAME_ID_LENGTH, "Text: Length");
        this.idToValue.put(FRAME_ID_LINKED_INFO, "Linked information");
        this.idToValue.put(FRAME_ID_LYRICIST, "Text: Lyricist/text writer");
        this.idToValue.put(FRAME_ID_MEDIA_TYPE, "Text: Media type");
        this.idToValue.put(FRAME_ID_MOOD, "Text: Mood");
        this.idToValue.put(FRAME_ID_MOVEMENT, "Text: Movement");
        this.idToValue.put(FRAME_ID_MOVEMENT_NO, "Text: Movement No");
        this.idToValue.put(FRAME_ID_MPEG_LOCATION_LOOKUP_TABLE, "MPEG location lookup table");
        this.idToValue.put(FRAME_ID_MUSIC_CD_ID, "Music CD Identifier");
        this.idToValue.put(FRAME_ID_ORIGARTIST, "Text: Original artist(s)/performer(s)");
        this.idToValue.put(FRAME_ID_ORIGINAL_RELEASE_TIME, "Text: Original release time");
        this.idToValue.put(FRAME_ID_ORIG_FILENAME, "Text: Original filename");
        this.idToValue.put(FRAME_ID_ORIG_LYRICIST, "Text: Original Lyricist(s)/text writer(s)");
        this.idToValue.put(FRAME_ID_ORIG_TITLE, "Text: Original album/Movie/Show title");
        this.idToValue.put(FRAME_ID_OWNERSHIP, "Ownership");
        this.idToValue.put("TSOP", "Performance Sort Order");
        this.idToValue.put(FRAME_ID_PLAYLIST_DELAY, "Text: Playlist delay");
        this.idToValue.put(FRAME_ID_PLAY_COUNTER, "Play counter");
        this.idToValue.put(FRAME_ID_POPULARIMETER, "Popularimeter");
        this.idToValue.put(FRAME_ID_POSITION_SYNC, "Position Sync");
        this.idToValue.put(FRAME_ID_PRIVATE, "Private frame");
        this.idToValue.put(FRAME_ID_PRODUCED_NOTICE, "Produced Notice");
        this.idToValue.put(FRAME_ID_PUBLISHER, "Text: Publisher");
        this.idToValue.put(FRAME_ID_RADIO_NAME, "Text: Radio Name");
        this.idToValue.put(FRAME_ID_RADIO_OWNER, "Text: Radio Owner");
        this.idToValue.put(FRAME_ID_RECOMMENDED_BUFFER_SIZE, "Recommended buffer size");
        this.idToValue.put(FRAME_ID_RELATIVE_VOLUME_ADJUSTMENT2, "Relative volume adjustment(2)");
        this.idToValue.put(FRAME_ID_RELEASE_TIME, "Release Time");
        this.idToValue.put(FRAME_ID_REMIXED, "Text: Interpreted, remixed, or otherwise modified by");
        this.idToValue.put(FRAME_ID_REVERB, "Reverb");
        this.idToValue.put(FRAME_ID_SEEK, "Seek");
        this.idToValue.put(FRAME_ID_SET, "Text: Part of a setField");
        this.idToValue.put(FRAME_ID_SET_SUBTITLE, "Text: Set subtitle");
        this.idToValue.put(FRAME_ID_SIGNATURE, "Signature");
        this.idToValue.put(FRAME_ID_SYNC_LYRIC, "Synchronized lyric/text");
        this.idToValue.put(FRAME_ID_SYNC_TEMPO, "Synced tempo codes");
        this.idToValue.put(FRAME_ID_TAGGING_TIME, "Text: Tagging time");
        this.idToValue.put(FRAME_ID_TERMS_OF_USE, "Terms of Use");
        this.idToValue.put(FRAME_ID_TITLE, "Text: title");
        this.idToValue.put(FRAME_ID_TITLE_REFINEMENT, "Text: Subtitle/Description refinement");
        this.idToValue.put("TSOT", "Text: title sort order");
        this.idToValue.put(FRAME_ID_TRACK, "Text: Track number/Position in setField");
        this.idToValue.put(FRAME_ID_UNIQUE_FILE_ID, "Unique file identifier");
        this.idToValue.put(FRAME_ID_UNSYNC_LYRICS, "Unsychronized lyric/text transcription");
        this.idToValue.put(FRAME_ID_URL_ARTIST_WEB, "URL: Official artist/performer webpage");
        this.idToValue.put(FRAME_ID_URL_COMMERCIAL, "URL: Commercial information");
        this.idToValue.put(FRAME_ID_URL_COPYRIGHT, "URL: Copyright/Legal information");
        this.idToValue.put(FRAME_ID_URL_FILE_WEB, "URL: Official audio file webpage");
        this.idToValue.put(FRAME_ID_URL_OFFICIAL_RADIO, "URL: Official Radio website");
        this.idToValue.put(FRAME_ID_URL_PAYMENT, "URL: Payment for this recording ");
        this.idToValue.put(FRAME_ID_URL_PUBLISHERS, "URL: Publishers official webpage");
        this.idToValue.put(FRAME_ID_URL_SOURCE_WEB, "URL: Official audio source webpage");
        this.idToValue.put(FRAME_ID_USER_DEFINED_INFO, "User defined text information frame");
        this.idToValue.put(FRAME_ID_USER_DEFINED_URL, "User defined URL link frame");
        this.idToValue.put(FRAME_ID_YEAR, "Text:Year");
        this.idToValue.put(FRAME_ID_IS_COMPILATION, "Is Compilation");
        this.idToValue.put(FRAME_ID_ALBUM_ARTIST_SORT_ORDER_ITUNES, "Text:Album Artist Sort Order Frame");
        this.idToValue.put(FRAME_ID_COMPOSER_SORT_ORDER_ITUNES, "Text:Composer Sort Order Frame");
        this.createMaps();
        this.multipleFrames.add(FRAME_ID_USER_DEFINED_INFO);
        this.multipleFrames.add(FRAME_ID_USER_DEFINED_URL);
        this.multipleFrames.add(FRAME_ID_ATTACHED_PICTURE);
        this.multipleFrames.add(FRAME_ID_PRIVATE);
        this.multipleFrames.add(FRAME_ID_COMMENT);
        this.multipleFrames.add(FRAME_ID_UNIQUE_FILE_ID);
        this.multipleFrames.add(FRAME_ID_UNSYNC_LYRICS);
        this.multipleFrames.add(FRAME_ID_POPULARIMETER);
        this.multipleFrames.add(FRAME_ID_GENERAL_ENCAPS_OBJECT);
        this.multipleFrames.add(FRAME_ID_URL_ARTIST_WEB);
        this.multipleFrames.add(FRAME_ID_RELATIVE_VOLUME_ADJUSTMENT2);
        this.discardIfFileAlteredFrames.add(FRAME_ID_EVENT_TIMING_CODES);
        this.discardIfFileAlteredFrames.add(FRAME_ID_MPEG_LOCATION_LOOKUP_TABLE);
        this.discardIfFileAlteredFrames.add(FRAME_ID_POSITION_SYNC);
        this.discardIfFileAlteredFrames.add(FRAME_ID_SYNC_LYRIC);
        this.discardIfFileAlteredFrames.add(FRAME_ID_SYNC_TEMPO);
        this.discardIfFileAlteredFrames.add(FRAME_ID_EVENT_TIMING_CODES);
        this.discardIfFileAlteredFrames.add(FRAME_ID_ENCODEDBY);
        this.discardIfFileAlteredFrames.add(FRAME_ID_LENGTH);
        this.tagFieldToId3.put(FieldKey.ACOUSTID_FINGERPRINT, ID3v24FieldKey.ACOUSTID_FINGERPRINT);
        this.tagFieldToId3.put(FieldKey.ACOUSTID_ID, ID3v24FieldKey.ACOUSTID_ID);
        this.tagFieldToId3.put(FieldKey.ALBUM, ID3v24FieldKey.ALBUM);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTIST, ID3v24FieldKey.ALBUM_ARTIST);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTIST_SORT, ID3v24FieldKey.ALBUM_ARTIST_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTISTS, ID3v24FieldKey.ALBUM_ARTISTS);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTISTS_SORT, ID3v24FieldKey.ALBUM_ARTISTS_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_SORT, ID3v24FieldKey.ALBUM_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_YEAR, ID3v24FieldKey.ALBUM_YEAR);
        this.tagFieldToId3.put(FieldKey.AMAZON_ID, ID3v24FieldKey.AMAZON_ID);
        this.tagFieldToId3.put(FieldKey.ARRANGER, ID3v24FieldKey.ARRANGER);
        this.tagFieldToId3.put(FieldKey.ARRANGER_SORT, ID3v24FieldKey.ARRANGER_SORT);
        this.tagFieldToId3.put(FieldKey.ARTIST, ID3v24FieldKey.ARTIST);
        this.tagFieldToId3.put(FieldKey.ARTISTS, ID3v24FieldKey.ARTISTS);
        this.tagFieldToId3.put(FieldKey.ARTISTS_SORT, ID3v24FieldKey.ARTISTS_SORT);
        this.tagFieldToId3.put(FieldKey.ARTIST_SORT, ID3v24FieldKey.ARTIST_SORT);
        this.tagFieldToId3.put(FieldKey.BARCODE, ID3v24FieldKey.BARCODE);
        this.tagFieldToId3.put(FieldKey.BPM, ID3v24FieldKey.BPM);
        this.tagFieldToId3.put(FieldKey.CATALOG_NO, ID3v24FieldKey.CATALOG_NO);
        this.tagFieldToId3.put(FieldKey.CHOIR, ID3v24FieldKey.CHOIR);
        this.tagFieldToId3.put(FieldKey.CHOIR_SORT, ID3v24FieldKey.CHOIR_SORT);
        this.tagFieldToId3.put(FieldKey.CLASSICAL_CATALOG, ID3v24FieldKey.CLASSICAL_CATALOG);
        this.tagFieldToId3.put(FieldKey.CLASSICAL_NICKNAME, ID3v24FieldKey.CLASSICAL_NICKNAME);
        this.tagFieldToId3.put(FieldKey.COMMENT, ID3v24FieldKey.COMMENT);
        this.tagFieldToId3.put(FieldKey.COMPOSER, ID3v24FieldKey.COMPOSER);
        this.tagFieldToId3.put(FieldKey.COMPOSER_SORT, ID3v24FieldKey.COMPOSER_SORT);
        this.tagFieldToId3.put(FieldKey.CONDUCTOR, ID3v24FieldKey.CONDUCTOR);
        this.tagFieldToId3.put(FieldKey.CONDUCTOR_SORT, ID3v24FieldKey.CONDUCTOR_SORT);
        this.tagFieldToId3.put(FieldKey.COPYRIGHT, ID3v24FieldKey.COPYRIGHT);
        this.tagFieldToId3.put(FieldKey.COUNTRY, ID3v24FieldKey.COUNTRY);
        this.tagFieldToId3.put(FieldKey.COVER_ART, ID3v24FieldKey.COVER_ART);
        this.tagFieldToId3.put(FieldKey.CUSTOM1, ID3v24FieldKey.CUSTOM1);
        this.tagFieldToId3.put(FieldKey.CUSTOM2, ID3v24FieldKey.CUSTOM2);
        this.tagFieldToId3.put(FieldKey.CUSTOM3, ID3v24FieldKey.CUSTOM3);
        this.tagFieldToId3.put(FieldKey.CUSTOM4, ID3v24FieldKey.CUSTOM4);
        this.tagFieldToId3.put(FieldKey.CUSTOM5, ID3v24FieldKey.CUSTOM5);
        this.tagFieldToId3.put(FieldKey.DISC_NO, ID3v24FieldKey.DISC_NO);
        this.tagFieldToId3.put(FieldKey.DISC_SUBTITLE, ID3v24FieldKey.DISC_SUBTITLE);
        this.tagFieldToId3.put(FieldKey.DISC_TOTAL, ID3v24FieldKey.DISC_NO);
        this.tagFieldToId3.put(FieldKey.DJMIXER, ID3v24FieldKey.DJMIXER);
        this.tagFieldToId3.put(FieldKey.DJMIXER_SORT, ID3v24FieldKey.DJMIXER_SORT);
        this.tagFieldToId3.put(FieldKey.MOOD_ELECTRONIC, ID3v24FieldKey.MOOD_ELECTRONIC);
        this.tagFieldToId3.put(FieldKey.ENCODER, ID3v24FieldKey.ENCODER);
        this.tagFieldToId3.put(FieldKey.ENGINEER, ID3v24FieldKey.ENGINEER);
        this.tagFieldToId3.put(FieldKey.ENGINEER_SORT, ID3v24FieldKey.ENGINEER_SORT);
        this.tagFieldToId3.put(FieldKey.ENSEMBLE, ID3v24FieldKey.ENSEMBLE);
        this.tagFieldToId3.put(FieldKey.ENSEMBLE_SORT, ID3v24FieldKey.ENSEMBLE_SORT);
        this.tagFieldToId3.put(FieldKey.FBPM, ID3v24FieldKey.FBPM);
        this.tagFieldToId3.put(FieldKey.GENRE, ID3v24FieldKey.GENRE);
        this.tagFieldToId3.put(FieldKey.GROUP, ID3v24FieldKey.GROUP);
        this.tagFieldToId3.put(FieldKey.GROUPING, ID3v24FieldKey.GROUPING);
        this.tagFieldToId3.put(FieldKey.INSTRUMENT, ID3v24FieldKey.INSTRUMENT);
        this.tagFieldToId3.put(FieldKey.INVOLVEDPEOPLE, ID3v24FieldKey.INVOLVED_PEOPLE);
        this.tagFieldToId3.put(FieldKey.IPI, ID3v24FieldKey.IPI);
        this.tagFieldToId3.put(FieldKey.ISRC, ID3v24FieldKey.ISRC);
        this.tagFieldToId3.put(FieldKey.ISWC, ID3v24FieldKey.ISWC);
        this.tagFieldToId3.put(FieldKey.IS_CLASSICAL, ID3v24FieldKey.IS_CLASSICAL);
        this.tagFieldToId3.put(FieldKey.IS_COMPILATION, ID3v24FieldKey.IS_COMPILATION);
        this.tagFieldToId3.put(FieldKey.IS_SOUNDTRACK, ID3v24FieldKey.IS_SOUNDTRACK);
        this.tagFieldToId3.put(FieldKey.IS_GREATEST_HITS, ID3v24FieldKey.IS_GREATEST_HITS);
        this.tagFieldToId3.put(FieldKey.IS_HD, ID3v24FieldKey.IS_HD);
        this.tagFieldToId3.put(FieldKey.IS_LIVE, ID3v24FieldKey.IS_LIVE);
        this.tagFieldToId3.put(FieldKey.ITUNES_GROUPING, ID3v24FieldKey.ITUNES_GROUPING);
        this.tagFieldToId3.put(FieldKey.JAIKOZ_ID, ID3v24FieldKey.JAIKOZ_ID);
        this.tagFieldToId3.put(FieldKey.KEY, ID3v24FieldKey.KEY);
        this.tagFieldToId3.put(FieldKey.LANGUAGE, ID3v24FieldKey.LANGUAGE);
        this.tagFieldToId3.put(FieldKey.LYRICIST, ID3v24FieldKey.LYRICIST);
        this.tagFieldToId3.put(FieldKey.LYRICIST_SORT, ID3v24FieldKey.LYRICIST_SORT);
        this.tagFieldToId3.put(FieldKey.LYRICS, ID3v24FieldKey.LYRICS);
        this.tagFieldToId3.put(FieldKey.MEDIA, ID3v24FieldKey.MEDIA);
        this.tagFieldToId3.put(FieldKey.MIXER, ID3v24FieldKey.MIXER);
        this.tagFieldToId3.put(FieldKey.MIXER_SORT, ID3v24FieldKey.MIXER_SORT);
        this.tagFieldToId3.put(FieldKey.MOOD, ID3v24FieldKey.MOOD);
        this.tagFieldToId3.put(FieldKey.MOOD_ACOUSTIC, ID3v24FieldKey.MOOD_ACOUSTIC);
        this.tagFieldToId3.put(FieldKey.MOOD_AGGRESSIVE, ID3v24FieldKey.MOOD_AGGRESSIVE);
        this.tagFieldToId3.put(FieldKey.MOOD_AROUSAL, ID3v24FieldKey.MOOD_AROUSAL);
        this.tagFieldToId3.put(FieldKey.MOOD_DANCEABILITY, ID3v24FieldKey.MOOD_DANCEABILITY);
        this.tagFieldToId3.put(FieldKey.MOOD_HAPPY, ID3v24FieldKey.MOOD_HAPPY);
        this.tagFieldToId3.put(FieldKey.MOOD_INSTRUMENTAL, ID3v24FieldKey.MOOD_INSTRUMENTAL);
        this.tagFieldToId3.put(FieldKey.MOOD_PARTY, ID3v24FieldKey.MOOD_PARTY);
        this.tagFieldToId3.put(FieldKey.MOOD_RELAXED, ID3v24FieldKey.MOOD_RELAXED);
        this.tagFieldToId3.put(FieldKey.MOOD_SAD, ID3v24FieldKey.MOOD_SAD);
        this.tagFieldToId3.put(FieldKey.MOOD_VALENCE, ID3v24FieldKey.MOOD_VALENCE);
        this.tagFieldToId3.put(FieldKey.MOVEMENT, ID3v24FieldKey.MOVEMENT);
        this.tagFieldToId3.put(FieldKey.MOVEMENT_NO, ID3v24FieldKey.MOVEMENT_NO);
        this.tagFieldToId3.put(FieldKey.MOVEMENT_TOTAL, ID3v24FieldKey.MOVEMENT_TOTAL);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_ARTISTID, ID3v24FieldKey.MUSICBRAINZ_ARTISTID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_DISC_ID, ID3v24FieldKey.MUSICBRAINZ_DISC_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_ORIGINAL_RELEASE_ID, ID3v24FieldKey.MUSICBRAINZ_ORIGINAL_RELEASEID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, ID3v24FieldKey.MUSICBRAINZ_RELEASEARTISTID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASEID, ID3v24FieldKey.MUSICBRAINZ_RELEASEID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, ID3v24FieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID, ID3v24FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, ID3v24FieldKey.MUSICBRAINZ_RELEASE_STATUS);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_TRACK_ID, ID3v24FieldKey.MUSICBRAINZ_RELEASE_TRACK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, ID3v24FieldKey.MUSICBRAINZ_RELEASE_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_TRACK_ID, ID3v24FieldKey.MUSICBRAINZ_TRACK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK, ID3v24FieldKey.MUSICBRAINZ_WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RECORDING_WORK, ID3v24FieldKey.MUSICBRAINZ_RECORDING_WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RECORDING_WORK_ID, ID3v24FieldKey.MUSICBRAINZ_RECORDING_WORK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID, ID3v24FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID);
        this.tagFieldToId3.put(FieldKey.MUSICIP_ID, ID3v24FieldKey.MUSICIP_ID);
        this.tagFieldToId3.put(FieldKey.OCCASION, ID3v24FieldKey.OCCASION);
        this.tagFieldToId3.put(FieldKey.OPUS, ID3v24FieldKey.OPUS);
        this.tagFieldToId3.put(FieldKey.ORCHESTRA, ID3v24FieldKey.ORCHESTRA);
        this.tagFieldToId3.put(FieldKey.ORCHESTRA_SORT, ID3v24FieldKey.ORCHESTRA_SORT);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_ALBUM, ID3v24FieldKey.ORIGINAL_ALBUM);
        this.tagFieldToId3.put(FieldKey.ORIGINALRELEASEDATE, ID3v24FieldKey.ORIGINALRELEASEDATE);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_ARTIST, ID3v24FieldKey.ORIGINAL_ARTIST);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_LYRICIST, ID3v24FieldKey.ORIGINAL_LYRICIST);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_YEAR, ID3v24FieldKey.ORIGINAL_YEAR);
        this.tagFieldToId3.put(FieldKey.OVERALL_WORK, ID3v24FieldKey.OVERALL_WORK);
        this.tagFieldToId3.put(FieldKey.PART, ID3v24FieldKey.PART);
        this.tagFieldToId3.put(FieldKey.PART_NUMBER, ID3v24FieldKey.PART_NUMBER);
        this.tagFieldToId3.put(FieldKey.PART_TYPE, ID3v24FieldKey.PART_TYPE);
        this.tagFieldToId3.put(FieldKey.PERFORMER, ID3v24FieldKey.PERFORMER);
        this.tagFieldToId3.put(FieldKey.PERFORMER_NAME, ID3v24FieldKey.PERFORMER_NAME);
        this.tagFieldToId3.put(FieldKey.PERFORMER_NAME_SORT, ID3v24FieldKey.PERFORMER_NAME_SORT);
        this.tagFieldToId3.put(FieldKey.PERIOD, ID3v24FieldKey.PERIOD);
        this.tagFieldToId3.put(FieldKey.PRODUCER, ID3v24FieldKey.PRODUCER);
        this.tagFieldToId3.put(FieldKey.PRODUCER_SORT, ID3v24FieldKey.PRODUCER_SORT);
        this.tagFieldToId3.put(FieldKey.QUALITY, ID3v24FieldKey.QUALITY);
        this.tagFieldToId3.put(FieldKey.RANKING, ID3v24FieldKey.RANKING);
        this.tagFieldToId3.put(FieldKey.RATING, ID3v24FieldKey.RATING);
        this.tagFieldToId3.put(FieldKey.RECORD_LABEL, ID3v24FieldKey.RECORD_LABEL);
        this.tagFieldToId3.put(FieldKey.RECORDINGDATE, ID3v24FieldKey.RECORDINGDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGSTARTDATE, ID3v24FieldKey.RECORDINGSTARTDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGENDDATE, ID3v24FieldKey.RECORDINGENDDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGLOCATION, ID3v24FieldKey.RECORDINGLOCATION);
        this.tagFieldToId3.put(FieldKey.REMIXER, ID3v24FieldKey.REMIXER);
        this.tagFieldToId3.put(FieldKey.ROONALBUMTAG, ID3v24FieldKey.ROONALBUMTAG);
        this.tagFieldToId3.put(FieldKey.ROONTRACKTAG, ID3v24FieldKey.ROONTRACKTAG);
        this.tagFieldToId3.put(FieldKey.SCRIPT, ID3v24FieldKey.SCRIPT);
        this.tagFieldToId3.put(FieldKey.SECTION, ID3v24FieldKey.SECTION);
        this.tagFieldToId3.put(FieldKey.SINGLE_DISC_TRACK_NO, ID3v24FieldKey.SINGLE_DISC_TRACK_NO);
        this.tagFieldToId3.put(FieldKey.SONGKONG_ID, ID3v24FieldKey.SONGKONG_ID);
        this.tagFieldToId3.put(FieldKey.SUBTITLE, ID3v24FieldKey.SUBTITLE);
        this.tagFieldToId3.put(FieldKey.TAGS, ID3v24FieldKey.TAGS);
        this.tagFieldToId3.put(FieldKey.TEMPO, ID3v24FieldKey.TEMPO);
        this.tagFieldToId3.put(FieldKey.TIMBRE, ID3v24FieldKey.TIMBRE);
        this.tagFieldToId3.put(FieldKey.TITLE, ID3v24FieldKey.TITLE);
        this.tagFieldToId3.put(FieldKey.TITLE_MOVEMENT, ID3v24FieldKey.TITLE_MOVEMENT);
        this.tagFieldToId3.put(FieldKey.TITLE_SORT, ID3v24FieldKey.TITLE_SORT);
        this.tagFieldToId3.put(FieldKey.TONALITY, ID3v24FieldKey.TONALITY);
        this.tagFieldToId3.put(FieldKey.TRACK, ID3v24FieldKey.TRACK);
        this.tagFieldToId3.put(FieldKey.TRACK_TOTAL, ID3v24FieldKey.TRACK_TOTAL);
        this.tagFieldToId3.put(FieldKey.URL_DISCOGS_ARTIST_SITE, ID3v24FieldKey.URL_DISCOGS_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_DISCOGS_RELEASE_SITE, ID3v24FieldKey.URL_DISCOGS_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.URL_LYRICS_SITE, ID3v24FieldKey.URL_LYRICS_SITE);
        this.tagFieldToId3.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, ID3v24FieldKey.URL_OFFICIAL_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, ID3v24FieldKey.URL_OFFICIAL_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, ID3v24FieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, ID3v24FieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.WORK, ID3v24FieldKey.WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1, ID3v24FieldKey.WORK_PART_LEVEL1);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_TYPE, ID3v24FieldKey.WORK_PART_LEVEL1_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2, ID3v24FieldKey.WORK_PART_LEVEL2);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_TYPE, ID3v24FieldKey.WORK_PART_LEVEL2_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3, ID3v24FieldKey.WORK_PART_LEVEL3);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_TYPE, ID3v24FieldKey.WORK_PARTOF_LEVEL3_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4, ID3v24FieldKey.WORK_PART_LEVEL4);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_TYPE, ID3v24FieldKey.WORK_PART_LEVEL4_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5, ID3v24FieldKey.WORK_PART_LEVEL5);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_TYPE, ID3v24FieldKey.WORK_PART_LEVEL5_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6, ID3v24FieldKey.WORK_PART_LEVEL6);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_TYPE, ID3v24FieldKey.WORK_PART_LEVEL6_TYPE);
        this.tagFieldToId3.put(FieldKey.VERSION, ID3v24FieldKey.VERSION);
        this.tagFieldToId3.put(FieldKey.WORK_TYPE, ID3v24FieldKey.WORK_TYPE);
        this.tagFieldToId3.put(FieldKey.YEAR, ID3v24FieldKey.YEAR);
        this.populateId3ToTagField();
    }

    private void populateId3ToTagField() {
        for (Map.Entry<FieldKey, ID3v24FieldKey> next : this.tagFieldToId3.entrySet()) {
            this.id3ToTagField.put((ID3v24FieldKey)((Enum)next.getValue()), next.getKey());
        }
    }

    @Override
    public void setITunes12_6WorkGroupingMode(boolean id3v2ITunes12_6Mode) {
        if (id3v2ITunes12_6Mode) {
            this.tagFieldToId3.put(FieldKey.WORK, ID3v24FieldKey.GROUPING);
            this.tagFieldToId3.put(FieldKey.GROUPING, ID3v24FieldKey.ITUNES_GROUPING);
        } else {
            this.tagFieldToId3.put(FieldKey.WORK, ID3v24FieldKey.WORK);
            this.tagFieldToId3.put(FieldKey.GROUPING, ID3v24FieldKey.GROUPING);
        }
        this.populateId3ToTagField();
    }

    public ID3v24FieldKey getId3KeyFromGenericKey(FieldKey genericKey) {
        return this.tagFieldToId3.get((Object)genericKey);
    }

    public FieldKey getGenericKeyFromId3(ID3v24FieldKey fieldKey) {
        return this.id3ToTagField.get((Object)fieldKey);
    }
}

