/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.jaudiotagger.tag.TagOptionSingleton;

public class ShiftData {
    public static void shiftDataByOffsetToMakeSpace(SeekableByteChannel fc, int offset) throws IOException {
        long origFileSize = fc.size();
        long startPos = fc.position();
        long amountToBeWritten = fc.size() - startPos;
        int chunkSize = (int)TagOptionSingleton.getInstance().getWriteChunkSize();
        long count = amountToBeWritten / (long)chunkSize;
        long mod = amountToBeWritten % (long)chunkSize;
        ByteBuffer chunkBuffer = ByteBuffer.allocate(chunkSize);
        long readPos = fc.size() - (long)chunkSize;
        long writePos = fc.size() - (long)chunkSize + (long)offset;
        int i = 0;
        while ((long)i < count) {
            fc.position(readPos);
            fc.read(chunkBuffer);
            chunkBuffer.flip();
            fc.position(writePos);
            fc.write(chunkBuffer);
            chunkBuffer.rewind();
            readPos -= (long)chunkSize;
            writePos -= (long)chunkSize;
            ++i;
        }
        if (mod > 0L) {
            chunkBuffer = ByteBuffer.allocate((int)mod);
            fc.position(startPos);
            fc.read(chunkBuffer);
            chunkBuffer.flip();
            fc.position(startPos + (long)offset);
            fc.write(chunkBuffer);
        }
        if (fc instanceof SeekableByteChannel && offset < 0) {
            fc.truncate(origFileSize + (long)offset);
        }
    }

    public static void shiftDataByOffsetToShrinkSpace(SeekableByteChannel fc, int shrinkBy) throws IOException {
        long startPos = fc.position();
        long amountToBeWritten = fc.size() - startPos;
        int chunkSize = (int)TagOptionSingleton.getInstance().getWriteChunkSize();
        long count = amountToBeWritten / (long)chunkSize;
        long mod = amountToBeWritten % (long)chunkSize;
        ByteBuffer chunkBuffer = ByteBuffer.allocate(chunkSize);
        long readPos = startPos;
        long writePos = startPos - (long)shrinkBy;
        int i = 0;
        while ((long)i < count) {
            fc.position(readPos);
            fc.read(chunkBuffer);
            chunkBuffer.flip();
            fc.position(writePos);
            fc.write(chunkBuffer);
            chunkBuffer.rewind();
            readPos += (long)chunkSize;
            writePos += (long)chunkSize;
            ++i;
        }
        if (mod > 0L) {
            chunkBuffer = ByteBuffer.allocate((int)mod);
            fc.position(readPos);
            fc.read(chunkBuffer);
            chunkBuffer.flip();
            fc.position(writePos);
            fc.write(chunkBuffer);
        }
        if (fc instanceof SeekableByteChannel) {
            fc.truncate(fc.position());
        }
    }
}

