/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import org.jaudiotagger.utils.tree.EventListenerList;
import org.jaudiotagger.utils.tree.MutableTreeNode;
import org.jaudiotagger.utils.tree.TreeModel;
import org.jaudiotagger.utils.tree.TreeModelEvent;
import org.jaudiotagger.utils.tree.TreeModelListener;
import org.jaudiotagger.utils.tree.TreeNode;
import org.jaudiotagger.utils.tree.TreePath;

public class DefaultTreeModel<T>
implements Serializable,
TreeModel<T> {
    private static final long serialVersionUID = -267197228234880401L;
    protected TreeNode<T> root;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean asksAllowsChildren;

    public DefaultTreeModel(TreeNode<T> root) {
        this(root, false);
    }

    public DefaultTreeModel(TreeNode<T> root, boolean asksAllowsChildren) {
        this.root = root;
        this.asksAllowsChildren = asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean newValue) {
        this.asksAllowsChildren = newValue;
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setRoot(TreeNode<T> root) {
        TreeNode<T> oldRoot = this.root;
        this.root = root;
        if (root == null && oldRoot != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(root);
        }
    }

    @Override
    public TreeNode<T> getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(TreeNode<T> parent, TreeNode<T> child) {
        if (parent == null || child == null) {
            return -1;
        }
        return parent.getIndex(child);
    }

    @Override
    public TreeNode<T> getChild(TreeNode<T> parent, int index) {
        return parent.getChildAt(index);
    }

    @Override
    public int getChildCount(TreeNode<T> parent) {
        return parent.getChildCount();
    }

    @Override
    public boolean isLeaf(TreeNode<T> node) {
        if (this.asksAllowsChildren) {
            return !node.getAllowsChildren();
        }
        return node.isLeaf();
    }

    public void reload() {
        this.reload(this.root);
    }

    @Override
    public void valueForPathChanged(TreePath<T> path, T newValue) {
        MutableTreeNode aNode = (MutableTreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    public void insertNodeInto(MutableTreeNode<T> newChild, MutableTreeNode<T> parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(MutableTreeNode<T> node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        TreeNode[] removedArray = new TreeNode[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void nodeChanged(TreeNode<T> node) {
        if (this.listenerList != null && node != null) {
            TreeNode<T> parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void reload(TreeNode<T> node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void nodesWereInserted(TreeNode<T> node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            TreeNode[] newChildren = new TreeNode[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode<T> node, int[] childIndices, TreeNode<T>[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(TreeNode<T> node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    TreeNode[] cChildren = new TreeNode[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode<T> node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public TreeNode<T>[] getPathToRoot(TreeNode<T> aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode<T>[] getPathToRoot(TreeNode<T> aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesChanged(Object source, TreeNode<T>[] path, int[] childIndices, TreeNode<T>[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent<T> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent<T>(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, TreeNode<T>[] path, int[] childIndices, TreeNode<T>[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent<T> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent<T>(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, TreeNode<T>[] path, int[] childIndices, TreeNode<T>[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent<T> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent<T>(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, TreeNode<T>[] path, int[] childIndices, TreeNode<T>[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent<T> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent<T>(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath<T> path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent<T> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent<T>(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public <X extends EventListener> X[] getListeners(Class<X> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.root != null && this.root instanceof Serializable) {
            values.addElement("root");
            values.addElement(this.root);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("root")) {
            this.root = (TreeNode)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }
}

