/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.sound.spi.RingedAudioInputStream;
import org.kc7bfi.jflac.util.ByteData;

public class Flac2PcmAudioInputStream
extends RingedAudioInputStream
implements PCMProcessor {
    private FLACDecoder decoder;
    private ByteData pcmData;
    private StreamInfo streamInfo;
    private Metadata[] metaData;

    public Flac2PcmAudioInputStream(InputStream in, AudioFormat format, long length) {
        this(in, format, length, 2048);
    }

    public Flac2PcmAudioInputStream(InputStream in, AudioFormat format, long length, int size) {
        super(in, format, length, size);
    }

    @Override
    protected void fill() throws IOException {
        if (this.decoder == null) {
            this.initDecoder();
        }
        if (this.decoder.isEOF()) {
            this.buffer.setEOF(true);
        } else {
            Frame frame = this.decoder.readNextFrame();
            if (frame != null) {
                this.pcmData = this.decoder.decodeFrame(frame, this.pcmData);
                this.processPCM(this.pcmData);
            }
        }
    }

    protected void initDecoder() throws IOException {
        this.decoder = new FLACDecoder(this.in);
        this.decoder.addPCMProcessor(this);
        this.metaData = this.decoder.readMetadata();
    }

    @Override
    public void processStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    @Override
    public void processPCM(ByteData pcm) {
        this.buffer.resize(pcm.getLen() * 2);
        this.buffer.put(pcm.getData(), 0, pcm.getLen());
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public Metadata[] getMetaData() {
        return this.metaData;
    }
}

